/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ArgsTypeJsonDeserializer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.insensitive.UserInsensitiveRequest;
import org.apache.kylin.metadata.user.ManagedUser;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UserRequest
implements UserInsensitiveRequest {
    @JsonProperty
    private String username;
    @JsonProperty
    private String password;
    @JsonProperty
    private List<String> authorities = Lists.newArrayList();
    @JsonProperty
    @JsonDeserialize(using=ArgsTypeJsonDeserializer.BooleanJsonDeserializer.class)
    private Boolean disabled;
    @JsonProperty
    private Boolean defaultPassword;

    public List<SimpleGrantedAuthority> transformSimpleGrantedAuthorities() {
        return this.authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public ManagedUser updateManager(ManagedUser managedUser) {
        if (Objects.nonNull(this.disabled)) {
            managedUser.setDisabled(this.disabled.booleanValue());
        }
        if (Objects.nonNull(this.defaultPassword)) {
            managedUser.setDefaultPassword(this.defaultPassword.booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            managedUser.setPassword(this.password);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isEmpty((CharSequence)managedUser.getUsername())) {
            managedUser.setUsername(this.username);
        }
        if (CollectionUtils.isNotEmpty(this.authorities)) {
            List<SimpleGrantedAuthority> simpleGrantedAuthorities;
            if (this.authorities.stream().anyMatch("--disabled--"::equals)) {
                managedUser.setDisabled(true);
                this.authorities.remove("--disabled--");
            }
            if (!(simpleGrantedAuthorities = this.transformSimpleGrantedAuthorities()).contains(ManagedUser.DEFAULT_GROUP)) {
                simpleGrantedAuthorities.add(ManagedUser.DEFAULT_GROUP);
            }
            managedUser.setAuthorities(simpleGrantedAuthorities);
        }
        return managedUser;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public Boolean getDefaultPassword() {
        return this.defaultPassword;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setDefaultPassword(Boolean defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRequest)) {
            return false;
        }
        UserRequest other = (UserRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<String> this$authorities = this.getAuthorities();
        List<String> other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Boolean this$defaultPassword = this.getDefaultPassword();
        Boolean other$defaultPassword = other.getDefaultPassword();
        return !(this$defaultPassword == null ? other$defaultPassword != null : !((Object)this$defaultPassword).equals(other$defaultPassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<String> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Boolean $defaultPassword = this.getDefaultPassword();
        result = result * 59 + ($defaultPassword == null ? 43 : ((Object)$defaultPassword).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserRequest(username=" + this.getUsername() + ", password=" + this.getPassword() + ", authorities=" + this.getAuthorities() + ", disabled=" + this.getDisabled() + ", defaultPassword=" + this.getDefaultPassword() + ")";
    }
}

