/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.eventbus.KylinEventException;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.job.model.SnapshotBuildFinishedEvent;
import org.apache.kylin.shaded.curator.org.apache.curator.RetryPolicy;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.kylin.shaded.curator.org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlluxioExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlluxioExtension.class);
    private static Pattern IP_PATTERN = Pattern.compile("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)");

    @Subscribe
    public void onSnapshotFinished(SnapshotBuildFinishedEvent finished) throws Exception {
        if (finished.getSelectedPartCol() == null || !finished.isIncrementalBuild()) {
            return;
        }
        try {
            this.refreshCacheIfNecessary(finished.getTableDesc().getLastSnapshotPath());
        }
        catch (Exception e) {
            log.error("refresh alluxio failed", (Throwable)e);
            throw new KylinEventException("refresh alluxio failed", (Throwable)e);
        }
    }

    private void refreshCacheIfNecessary(String snapshotPath) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.skipFreshAlluxio()) {
            return;
        }
        List<String> hosts = this.acquireAlluxioAddress();
        log.info("alluxio hosts: {}", hosts);
        String rootPath = new Path(KapConfig.wrap((KylinConfig)config).getMetadataWorkingDirectory()).toUri().getPath();
        String snapshotAbsolutePath = rootPath + "/" + snapshotPath;
        boolean success = false;
        for (String hostName : hosts) {
            if (!this.tryFreshCache(hostName, snapshotAbsolutePath)) continue;
            success = true;
            break;
        }
        if (!success) {
            throw new RuntimeException(String.format(Locale.ROOT, "try all alluxio host %s  failed", hosts));
        }
    }

    private boolean tryFreshCache(String alluxioHost, String snapshotAbsolutePath) {
        String listUrl = String.format(Locale.ROOT, "HTTP://%s:39999/api/v1/paths/%s/list-status", alluxioHost, snapshotAbsolutePath);
        log.info("list url: {}", (Object)listUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost listAlwaysPost = this.constructListPost(listUrl, "ALWAYS");
            HttpPost listOncePost = this.constructListPost(listUrl, "ONCE");
            this.chainPost(httpClient, listAlwaysPost, listOncePost);
        }
        catch (Throwable e) {
            log.warn(String.format(Locale.ROOT, "use alluxio host %s to refresh snapshot failed", alluxioHost), e);
            return false;
        }
        return true;
    }

    private void chainPost(CloseableHttpClient httpClient, HttpPost ... postRequests) throws IOException {
        for (HttpPost postRequest : postRequests) {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) continue;
            InputStream inputStream = response.getEntity().getContent();
            String responseContent = IOUtils.toString((InputStream)inputStream);
            log.warn("request to url{}, info: {}", (Object)postRequest.getURI(), (Object)responseContent);
        }
    }

    private HttpPost constructListPost(String listUrl, String type) {
        HttpPost listPost = new HttpPost(listUrl);
        listPost.addHeader("Content-Type", "application/json");
        listPost.setEntity((HttpEntity)new StringEntity(String.format(Locale.ROOT, "{\"recursive\":true,\"loadMetadataType\":\"%s\"}", type), StandardCharsets.UTF_8));
        return listPost;
    }

    private List<String> acquireAlluxioAddress() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isEmbeddedEnable()) {
            return this.acquireAlluxioAddressFromConfig();
        }
        return this.acquireAlluxioAddressFromZK();
    }

    private List<String> acquireAlluxioAddressFromConfig() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ArrayList hosts = Lists.newArrayList();
        Matcher m = IP_PATTERN.matcher(config.getParquetReadFileSystem());
        while (m.find()) {
            hosts.add(m.group());
        }
        return hosts;
    }

    private List<String> acquireAlluxioAddressFromZK() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String workSpace = this.getWorkSpace(config);
        log.info("get workspace name : {}", (Object)workSpace);
        String zkPath = String.format(Locale.ROOT, "/alluxio/%s/leader", workSpace);
        log.info("zkPath is : {}", (Object)zkPath);
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(config.getZookeeperConnectString()).sessionTimeoutMs(3000).connectionTimeoutMs(5000).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
        client.start();
        List children = (List)client.getChildren().forPath(zkPath);
        log.info("zk children : " + children.toString());
        String hostName = ((String)children.get(0)).split(":")[0];
        log.info("get alluxio host {} from zk ", (Object)hostName);
        client.close();
        return Arrays.asList(hostName);
    }

    private String getWorkSpace(KylinConfig config) {
        String workSpace = config.getMetadataUrlPrefix();
        log.info("original workspace is {}", (Object)workSpace);
        String workSpaceSuffix = "_kylin";
        if (workSpace.endsWith(workSpaceSuffix)) {
            workSpace = workSpace.substring(0, workSpace.length() - workSpaceSuffix.length());
        }
        return workSpace;
    }
}

