/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

import org.apache.kylin.common.KylinConfig;

public class MemcachedCacheConfig {
    private long timeout;
    private String hosts;
    private int maxChunkSize;
    private int maxObjectSize;
    private int readBufferSize = 16384;
    private int maxOperationQueueSize = 0;
    private boolean enableCompression;
    private boolean enableDebugLog = false;

    public MemcachedCacheConfig() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.hosts = kylinConfig.getMemcachedHosts();
        this.timeout = kylinConfig.getMemcachedOpTimeout();
        this.maxChunkSize = kylinConfig.getMaxChunkSize();
        this.maxObjectSize = kylinConfig.getMaxObjectSize();
        this.enableCompression = kylinConfig.isEnableCompression();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        this.maxObjectSize = maxObjectSize;
    }

    public int getMaxOperationQueueSize() {
        return this.maxOperationQueueSize;
    }

    public void setMaxOperationQueueSize(int maxOperationQueueSize) {
        this.maxOperationQueueSize = maxOperationQueueSize;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setEnableDebugLog() {
        this.enableDebugLog = true;
    }

    public boolean isEnableDebugLog() {
        return this.enableDebugLog;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }
}

