/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.ClientCredentialsGrant;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ImplicitGrant;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.swagger2.mappers.SecuritySchemeFactory;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

class OAuth2AuthFactory
implements SecuritySchemeFactory {
    OAuth2AuthFactory() {
    }

    @Override
    public SecuritySchemeDefinition create(SecurityScheme input) {
        OAuth oAuth = (OAuth)input;
        OAuth2Definition definition = new OAuth2Definition();
        for (GrantType grantType : oAuth.getGrantTypes()) {
            if ("authorization_code".equals(grantType.getType())) {
                definition.accessCode(((AuthorizationCodeGrant)grantType).getTokenRequestEndpoint().getUrl(), ((AuthorizationCodeGrant)grantType).getTokenEndpoint().getUrl());
                continue;
            }
            if ("implicit".equals(grantType.getType())) {
                definition.implicit(((ImplicitGrant)grantType).getLoginEndpoint().getUrl());
                continue;
            }
            if ("application".equals(grantType.getType())) {
                definition.application(((ClientCredentialsGrant)grantType).getTokenUrl());
                continue;
            }
            if ("password".equals(grantType.getType())) {
                definition.password(((ResourceOwnerPasswordCredentialsGrant)grantType).getTokenUrl());
                continue;
            }
            throw new IllegalArgumentException(String.format("Security scheme of type %s not supported", input.getClass().getSimpleName()));
        }
        for (AuthorizationScope authorizationScope : oAuth.getScopes()) {
            definition.addScope(authorizationScope.getScope(), authorizationScope.getDescription());
        }
        VendorExtensionsMapper vendorMapper = new VendorExtensionsMapper();
        definition.setVendorExtensions(vendorMapper.mapExtensions(input.getVendorExtensions()));
        return definition;
    }
}

