/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.RefModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.service.ModelNamesRegistry;

public class ModelSpecificationInheritanceDeterminer {
    private final ModelNamesRegistry namesRegistry;
    private final Map<ModelKey, RefModel> parentLookup = new HashMap<ModelKey, RefModel>();

    public ModelSpecificationInheritanceDeterminer(ModelNamesRegistry namesRegistry) {
        this.namesRegistry = namesRegistry;
        for (ModelSpecification each : namesRegistry.modelsByName().values()) {
            Collection subclasses = each.getCompound().map(CompoundModelSpecification::getSubclassReferences).orElse(new ArrayList());
            for (ReferenceModelSpecification children : subclasses) {
                this.toRefModel(each).ifPresent(rm -> this.parentLookup.put(children.getKey(), (RefModel)rm));
            }
        }
    }

    private Optional<RefModel> toRefModel(ModelSpecification each) {
        return each.key().flatMap(k -> this.namesRegistry.nameByKey((ModelKey)k).map(RefModel::new));
    }

    public Optional<RefModel> parent(ModelSpecification source) {
        return source.key().map(this.parentLookup::get);
    }
}

