/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.PathDecorator;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.PathContext;

@Component
@Order(value=-2147483588)
@Deprecated
class QueryStringUriTemplateDecorator
implements PathDecorator {
    QueryStringUriTemplateDecorator() {
    }

    @Override
    public Function<String, String> decorator(PathContext context) {
        return input -> {
            Set<String> expressions;
            StringBuilder sb = new StringBuilder((String)input);
            String prefilled = this.prefilledQueryParams(context);
            if (!StringUtils.isEmpty((Object)prefilled)) {
                sb.append(this.requiresContinuation((String)input) ? "&" : "?");
                sb.append(prefilled);
            }
            if ((expressions = this.queryParamNames(context)).size() == 0) {
                return sb.toString();
            }
            String prefix = this.queryTemplatePrefix((String)input, prefilled);
            String queryTemplate = String.join((CharSequence)",", expressions);
            sb.append(prefix).append(queryTemplate).append("}");
            return sb.toString();
        };
    }

    private String queryTemplatePrefix(String input, String prefilled) {
        String prefix = StringUtils.isEmpty((Object)prefilled) ? (this.requiresContinuation(input) ? "{&" : "{?") : "{&";
        return prefix;
    }

    private boolean requiresContinuation(String url) {
        return url.contains("?");
    }

    private Set<String> queryParamNames(PathContext context) {
        return context.getParameters().stream().filter(this.queryStringParams().and(this.onlyOneAllowableValue().negate())).map(Parameter::getName).collect(Collectors.toCollection(TreeSet::new));
    }

    private String prefilledQueryParams(PathContext context) {
        return String.join((CharSequence)"&", context.getParameters().stream().filter(this.onlyOneAllowableValue()).map(this.queryStringWithValue()).collect(Collectors.toCollection(TreeSet::new))).trim();
    }

    private Predicate<Parameter> onlyOneAllowableValue() {
        return input -> {
            AllowableValues allowableValues = input.getAllowableValues();
            return allowableValues instanceof AllowableListValues && ((AllowableListValues)allowableValues).getValues().size() == 1;
        };
    }

    private Predicate<Parameter> queryStringParams() {
        return input -> "query".equals(input.getParamType());
    }

    private Function<Parameter, String> queryStringWithValue() {
        return input -> {
            AllowableListValues allowableValues = (AllowableListValues)input.getAllowableValues();
            return String.format("%s=%s", input.getName(), allowableValues.getValues().get(0).trim());
        };
    }

    @Override
    public boolean supports(DocumentationContext delimiter) {
        return delimiter.isUriTemplatesEnabled();
    }
}

