/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.math.BigDecimal;
import java.util.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.NumericElementFacetBuilder;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class DecimalMinMaxAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DecimalMinMaxAnnotationPlugin.class);

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public void apply(ModelPropertyContext context) {
        Optional<DecimalMin> min = Validators.extractAnnotation(context, DecimalMin.class);
        Optional<DecimalMax> max = Validators.extractAnnotation(context, DecimalMax.class);
        Compatibility<AllowableValues, NumericElementFacet> values = this.facetFromDecimalMinMaxForNumbers(min, max);
        context.getBuilder().allowableValues(values.getLegacy().orElse(null));
        values.getModern().ifPresent(facet -> context.getSpecificationBuilder().numericFacet(n -> n.copyOf((ElementFacet)facet)));
    }

    private Compatibility<AllowableValues, NumericElementFacet> facetFromDecimalMinMaxForNumbers(Optional<DecimalMin> decimalMin, Optional<DecimalMax> decimalMax) {
        AllowableRangeValues myvalues = null;
        NumericElementFacet numericFacet = null;
        if (decimalMin.isPresent() && decimalMax.isPresent()) {
            LOG.debug("@DecimalMin+@DecimalMax detected: adding AllowableRangeValues to field ");
            DecimalMin min = decimalMin.get();
            DecimalMax max = decimalMax.get();
            myvalues = new AllowableRangeValues(min.value(), !min.inclusive(), max.value(), !max.inclusive());
            numericFacet = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(new BigDecimal(min.value())).exclusiveMinimum(!min.inclusive()).maximum(new BigDecimal(max.value())).exclusiveMaximum(!max.inclusive()).build();
        } else if (decimalMin.isPresent()) {
            LOG.debug("@DecimalMin detected: adding AllowableRangeValues to field ");
            DecimalMin min = decimalMin.get();
            myvalues = new AllowableRangeValues(min.value(), !min.inclusive(), null, null);
            numericFacet = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(new BigDecimal(min.value())).exclusiveMinimum(!min.inclusive()).maximum(null).exclusiveMaximum(null).build();
        } else if (decimalMax.isPresent()) {
            LOG.debug("@DecimalMax detected: adding AllowableRangeValues to field ");
            DecimalMax max = decimalMax.get();
            myvalues = new AllowableRangeValues(null, null, max.value(), !max.inclusive());
            numericFacet = new NumericElementFacetBuilder().multipleOf(NumericElementFacet.DEFAULT_MULTIPLE).minimum(null).exclusiveMinimum(null).maximum(new BigDecimal(max.value())).exclusiveMaximum(!max.inclusive()).build();
        }
        return new Compatibility<Object, Object>(myvalues, numericFacet);
    }
}

