/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.NDataSegment;

public abstract class MergePolicy {
    protected List<NDataSegment> matchSegList = new ArrayList<NDataSegment>();
    private double mergeRatio = KylinConfig.getInstanceFromEnv().getStreamingSegmentMergeRatio();

    protected int findStartIndex(List<NDataSegment> segList, Long thresholdOfSegSize) {
        for (int i = 0; i < segList.size(); ++i) {
            if (segList.get(i).getStorageBytesSize() > thresholdOfSegSize) continue;
            return i;
        }
        return -1;
    }

    public void next(AtomicInteger currLayer) {
    }

    public abstract List<NDataSegment> selectMatchedSegList(List<NDataSegment> var1, int var2, long var3, int var5);

    public abstract boolean matchMergeCondition(long var1);

    public boolean isThresholdOfSegSizeOver(long totalSegSize, long thresholdOfSegSize) {
        return (double)totalSegSize >= (double)thresholdOfSegSize * this.mergeRatio;
    }

    public List<NDataSegment> getMatchSegList() {
        return this.matchSegList;
    }
}

