/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.BlockStoreShuffleReader;
import org.apache.spark.shuffle.BlockStoreShuffleReader$;
import org.apache.spark.shuffle.ColumnarShuffleDependency;
import org.apache.spark.shuffle.GlutenShuffleUtils$;
import org.apache.spark.shuffle.GlutenShuffleWriterWrapper$;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleWriter;
import org.apache.spark.shuffle.sort.ColumnarShuffleHandle;
import org.apache.spark.shuffle.sort.ColumnarShuffleManager$;
import org.apache.spark.shuffle.sort.SerializedShuffleHandle;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.collection.OpenHashSet;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\t\u0013\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\tq\u0001A)\u0019!C\u0005s!9\u0001\t\u0001b\u0001\n\u0003\n\u0005BB#\u0001A\u0003%!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0012\u0005\u0006=\u0002!\te\u0018\u0005\u0006y\u0002!\t% \u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!\u001a\u0001\t\u0003\n9gB\u0004\u0002pIA\t!!\u001d\u0007\rE\u0011\u0002\u0012AA:\u0011\u0019\u0019T\u0002\"\u0001\u0002v!9\u0011qO\u0007\u0005\n\u0005e\u0004bBA?\u001b\u0011%\u0011q\u0010\u0002\u0017\u0007>dW/\u001c8beNCWO\u001a4mK6\u000bg.Y4fe*\u00111\u0003F\u0001\u0005g>\u0014HO\u0003\u0002\u0016-\u000591\u000f[;gM2,'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M!\u0001A\b\u0013)!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEJ\u0007\u0002)%\u0011q\u0005\u0006\u0002\u000f'\",hM\u001a7f\u001b\u0006t\u0017mZ3s!\tIC&D\u0001+\u0015\tYc#\u0001\u0005j]R,'O\\1m\u0013\ti#FA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003aEj\u0011AF\u0005\u0003eY\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t)t\u0007\u0005\u00027\u00015\t!\u0003C\u0003/\u0005\u0001\u0007q&A\rtQV4g\r\\3Fq\u0016\u001cW\u000f^8s\u0007>l\u0007o\u001c8f]R\u001cX#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\"\u0012aA1qS&\u0011q\b\u0010\u0002\u001a'\",hM\u001a7f\u000bb,7-\u001e;pe\u000e{W\u000e]8oK:$8/\u0001\u000btQV4g\r\\3CY>\u001c7NU3t_24XM]\u000b\u0002\u0005B\u0011QeQ\u0005\u0003\tR\u0011\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<fe\u0006)2\u000f[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\u0013\u0001\u0006;bg.LE-T1qg\u001a{'o\u00155vM\u001adW\r\u0005\u0003I\u001fF#V\"A%\u000b\u0005)[\u0015AC2p]\u000e,(O]3oi*\u0011A*T\u0001\u0005kRLGNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005AK%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011qDU\u0005\u0003'\u0002\u00121!\u00138u!\r)\u0016lW\u0007\u0002-*\u0011q\u000bW\u0001\u000bG>dG.Z2uS>t'B\u0001'\u0017\u0013\tQfKA\u0006Pa\u0016t\u0007*Y:i'\u0016$\bCA\u0010]\u0013\ti\u0006E\u0001\u0003M_:<\u0017a\u0004:fO&\u001cH/\u001a:TQV4g\r\\3\u0016\t\u0001lwO\u001f\u000b\u0004C\u00124\u0007CA\u0013c\u0013\t\u0019GCA\u0007TQV4g\r\\3IC:$G.\u001a\u0005\u0006K\u001e\u0001\r!U\u0001\ng\",hM\u001a7f\u0013\u0012DQaZ\u0004A\u0002!\f!\u0002Z3qK:$WM\\2z!\u0015\u0001\u0014n\u001b<z\u0013\tQgCA\tTQV4g\r\\3EKB,g\u000eZ3oGf\u0004\"\u0001\\7\r\u0001\u0011)an\u0002b\u0001_\n\t1*\u0005\u0002qgB\u0011q$]\u0005\u0003e\u0002\u0012qAT8uQ&tw\r\u0005\u0002 i&\u0011Q\u000f\t\u0002\u0004\u0003:L\bC\u00017x\t\u0015AxA1\u0001p\u0005\u00051\u0006C\u00017{\t\u0015YxA1\u0001p\u0005\u0005\u0019\u0015!C4fi^\u0013\u0018\u000e^3s+\u0015q\u0018qAA\u0006)%y\u0018QBA\t\u0003+\ty\u0002E\u0004&\u0003\u0003\t)!!\u0003\n\u0007\u0005\rACA\u0007TQV4g\r\\3Xe&$XM\u001d\t\u0004Y\u0006\u001dA!\u00028\t\u0005\u0004y\u0007c\u00017\u0002\f\u0011)\u0001\u0010\u0003b\u0001_\"1\u0011q\u0002\u0005A\u0002\u0005\fa\u0001[1oI2,\u0007BBA\n\u0011\u0001\u00071,A\u0003nCBLE\rC\u0004\u0002\u0018!\u0001\r!!\u0007\u0002\u000f\r|g\u000e^3yiB\u0019\u0001'a\u0007\n\u0007\u0005uaCA\u0006UCN\\7i\u001c8uKb$\bbBA\u0011\u0011\u0001\u0007\u00111E\u0001\b[\u0016$(/[2t!\r)\u0013QE\u0005\u0004\u0003O!\"aG*ik\u001a4G.Z,sSR,W*\u001a;sS\u000e\u001c(+\u001a9peR,'/A\u0005hKR\u0014V-\u00193feV1\u0011QFA\u001c\u0003w!\u0002#a\f\u0002>\u0005}\u00121IA$\u0003\u0017\ny%!\u0015\u0011\u000f\u0015\n\t$!\u000e\u0002:%\u0019\u00111\u0007\u000b\u0003\u001bMCWO\u001a4mKJ+\u0017\rZ3s!\ra\u0017q\u0007\u0003\u0006]&\u0011\ra\u001c\t\u0004Y\u0006mB!B>\n\u0005\u0004y\u0007BBA\b\u0013\u0001\u0007\u0011\r\u0003\u0004\u0002B%\u0001\r!U\u0001\u000egR\f'\u000f^'ba&sG-\u001a=\t\r\u0005\u0015\u0013\u00021\u0001R\u0003-)g\u000eZ'ba&sG-\u001a=\t\r\u0005%\u0013\u00021\u0001R\u00039\u0019H/\u0019:u!\u0006\u0014H/\u001b;j_:Da!!\u0014\n\u0001\u0004\t\u0016\u0001D3oIB\u000b'\u000f^5uS>t\u0007bBA\f\u0013\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003CI\u0001\u0019AA*!\r)\u0013QK\u0005\u0004\u0003/\"\"AG*ik\u001a4G.\u001a*fC\u0012lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018!E;oe\u0016<\u0017n\u001d;feNCWO\u001a4mKR!\u0011QLA2!\ry\u0012qL\u0005\u0004\u0003C\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u0006K*\u0001\r!U\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002jA\u0019q$a\u001b\n\u0007\u00055\u0004E\u0001\u0003V]&$\u0018AF\"pYVlg.\u0019:TQV4g\r\\3NC:\fw-\u001a:\u0011\u0005Yj1cA\u0007\u001fQQ\u0011\u0011\u0011O\u0001\u001eY>\fGm\u00155vM\u001adW-\u0012=fGV$xN]\"p[B|g.\u001a8ugR\u0019!(a\u001f\t\u000b9z\u0001\u0019A\u0018\u0002G\tL\b/Y:t\t\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8TKJL\u0017\r\\5{KJl\u0015M\\4feV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\f\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002\f\u0006\u0015%!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\u0002")
public class ColumnarShuffleManager
implements ShuffleManager,
Logging {
    private ShuffleExecutorComponents shuffleExecutorComponents;
    private final SparkConf conf;
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private final ConcurrentHashMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return ShuffleManager.getReader$((ShuffleManager)this, (ShuffleHandle)handle, (int)startPartition, (int)endPartition, (TaskContext)context, (ShuffleReadMetricsReporter)metrics);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleExecutorComponents shuffleExecutorComponents$lzycompute() {
        ColumnarShuffleManager columnarShuffleManager = this;
        synchronized (columnarShuffleManager) {
            if (!this.bitmap$0) {
                this.shuffleExecutorComponents = ColumnarShuffleManager$.MODULE$.org$apache$spark$shuffle$sort$ColumnarShuffleManager$$loadShuffleExecutorComponents(this.conf);
                this.bitmap$0 = true;
            }
        }
        return this.shuffleExecutorComponents;
    }

    private ShuffleExecutorComponents shuffleExecutorComponents() {
        return !this.bitmap$0 ? this.shuffleExecutorComponents$lzycompute() : this.shuffleExecutorComponents;
    }

    public IndexShuffleBlockResolver shuffleBlockResolver() {
        return this.shuffleBlockResolver;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        Object object;
        if (dependency instanceof ColumnarShuffleDependency) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Registering ColumnarShuffle shuffleId: ").append(shuffleId).toString());
            object = new ColumnarShuffleHandle(shuffleId, (ColumnarShuffleDependency)dependency);
        } else {
            object = SortShuffleWriter$.MODULE$.shouldBypassMergeSort(this.conf, dependency) ? new BypassMergeSortShuffleHandle(shuffleId, dependency) : (SortShuffleManager$.MODULE$.canUseSerializedShuffle(dependency) ? new SerializedShuffleHandle(shuffleId, dependency) : new BaseShuffleHandle(shuffleId, dependency));
        }
        return object;
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        ShuffleWriter shuffleWriter;
        OpenHashSet mapTaskIds;
        OpenHashSet openHashSet = mapTaskIds = this.taskIdMapsForShuffle.computeIfAbsent(BoxesRunTime.boxToInteger((int)handle.shuffleId()), x$1 -> ColumnarShuffleManager.$anonfun$getWriter$1(BoxesRunTime.unboxToInt((Object)x$1)));
        synchronized (openHashSet) {
            mapTaskIds.add$mcJ$sp(context.taskAttemptId());
        }
        SparkEnv env = SparkEnv$.MODULE$.get();
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof ColumnarShuffleHandle) {
            ColumnarShuffleHandle columnarShuffleHandle = (ColumnarShuffleHandle)shuffleHandle;
            shuffleWriter = GlutenShuffleWriterWrapper$.MODULE$.genColumnarShuffleWriter(this.shuffleBlockResolver(), columnarShuffleHandle, mapId, metrics);
        } else if (shuffleHandle instanceof SerializedShuffleHandle) {
            SerializedShuffleHandle serializedShuffleHandle = (SerializedShuffleHandle)shuffleHandle;
            shuffleWriter = new ShuffleWriter(env.blockManager(), context.taskMemoryManager(), serializedShuffleHandle, mapId, context, env.conf(), metrics, this.shuffleExecutorComponents());
        } else if (shuffleHandle instanceof BypassMergeSortShuffleHandle) {
            BypassMergeSortShuffleHandle bypassMergeSortShuffleHandle = (BypassMergeSortShuffleHandle)shuffleHandle;
            shuffleWriter = new BypassMergeSortShuffleWriter(env.blockManager(), bypassMergeSortShuffleHandle, mapId, env.conf(), metrics, this.shuffleExecutorComponents());
        } else if (shuffleHandle instanceof BaseShuffleHandle) {
            BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)shuffleHandle;
            shuffleWriter = GlutenShuffleUtils$.MODULE$.getSortShuffleWriter((ShuffleHandle)baseShuffleHandle, mapId, context, metrics, this.shuffleExecutorComponents());
        } else {
            throw new MatchError((Object)shuffleHandle);
        }
        return shuffleWriter;
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        BlockStoreShuffleReader blockStoreShuffleReader;
        boolean shouldBatchFetch;
        Tuple2<Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>, Object> tuple2 = GlutenShuffleUtils$.MODULE$.getReaderParam(handle, startMapIndex, endMapIndex, startPartition, endPartition);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator blocksByAddress = (Iterator)tuple2._1();
        boolean canEnableBatchFetch = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)blocksByAddress, (Object)BoxesRunTime.boxToBoolean((boolean)canEnableBatchFetch));
        Tuple2 tuple23 = tuple22;
        Iterator blocksByAddress2 = (Iterator)tuple23._1();
        boolean canEnableBatchFetch2 = tuple23._2$mcZ$sp();
        boolean bl = shouldBatchFetch = canEnableBatchFetch2 && SortShuffleManager$.MODULE$.canUseBatchFetch(startPartition, endPartition, context);
        if (handle instanceof ColumnarShuffleHandle) {
            BaseShuffleHandle x$1 = (BaseShuffleHandle)handle;
            Iterator x$2 = blocksByAddress2;
            TaskContext x$3 = context;
            ShuffleReadMetricsReporter x$4 = metrics;
            SerializerManager x$5 = ColumnarShuffleManager$.MODULE$.org$apache$spark$shuffle$sort$ColumnarShuffleManager$$bypassDecompressionSerializerManger();
            boolean x$6 = shouldBatchFetch;
            BlockManager x$7 = BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6();
            MapOutputTracker x$8 = BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7();
            blockStoreShuffleReader = new BlockStoreShuffleReader(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        } else {
            BaseShuffleHandle x$9 = (BaseShuffleHandle)handle;
            Iterator x$10 = blocksByAddress2;
            TaskContext x$11 = context;
            ShuffleReadMetricsReporter x$12 = metrics;
            boolean x$13 = shouldBatchFetch;
            SerializerManager x$14 = BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$5();
            BlockManager x$15 = BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6();
            MapOutputTracker x$16 = BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7();
            blockStoreShuffleReader = new BlockStoreShuffleReader(x$9, x$10, x$11, x$12, x$14, x$15, x$16, x$13);
        }
        return blockStoreShuffleReader;
    }

    public boolean unregisterShuffle(int shuffleId) {
        Option$.MODULE$.apply(this.taskIdMapsForShuffle.remove(BoxesRunTime.boxToInteger((int)shuffleId))).foreach((Function1 & Serializable & scala.Serializable)mapTaskIds -> {
            ColumnarShuffleManager.$anonfun$unregisterShuffle$1(this, shuffleId, mapTaskIds);
            return BoxedUnit.UNIT;
        });
        return true;
    }

    public void stop() {
        this.shuffleBlockResolver().stop();
    }

    public static final /* synthetic */ OpenHashSet $anonfun$getWriter$1(int x$1) {
        return new OpenHashSet.mcJ.sp(16, ClassTag$.MODULE$.Long());
    }

    public static final /* synthetic */ void $anonfun$unregisterShuffle$1(ColumnarShuffleManager $this, int shuffleId$2, OpenHashSet mapTaskIds) {
        mapTaskIds.iterator().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)mapId -> $this.shuffleBlockResolver().removeDataByMap(shuffleId$2, mapId));
    }

    public ColumnarShuffleManager(SparkConf conf) {
        this.conf = conf;
        ShuffleManager.$init$((ShuffleManager)this);
        Logging.$init$((Logging)this);
        this.shuffleBlockResolver = new IndexShuffleBlockResolver(conf, IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2());
        this.taskIdMapsForShuffle = new ConcurrentHashMap();
    }
}

