/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;

public class IfThenNode
implements ExpressionNode,
Serializable {
    private final List<ExpressionNode> ifNodes = new ArrayList<ExpressionNode>();
    private final List<ExpressionNode> thenNodes = new ArrayList<ExpressionNode>();
    private final ExpressionNode elseValue;

    public IfThenNode(List<ExpressionNode> ifNodes, List<ExpressionNode> thenNodes, ExpressionNode elseValue) {
        this.ifNodes.addAll(ifNodes);
        this.thenNodes.addAll(thenNodes);
        this.elseValue = elseValue;
    }

    @Override
    public Expression toProtobuf() {
        if (this.ifNodes.size() != this.thenNodes.size()) {
            throw new RuntimeException("The length of if nodes and then nodes is different.");
        }
        Expression.IfThen.Builder ifThenBuilder = Expression.IfThen.newBuilder();
        int ifNodesLen = this.ifNodes.size();
        for (int i = 0; i < ifNodesLen; ++i) {
            Expression.IfThen.IfClause.Builder ifClauseBuilder = Expression.IfThen.IfClause.newBuilder();
            ifClauseBuilder.setIf(this.ifNodes.get(i).toProtobuf());
            ifClauseBuilder.setThen(this.thenNodes.get(i).toProtobuf());
            ifThenBuilder.addIfs(ifClauseBuilder.build());
        }
        if (this.elseValue != null) {
            ifThenBuilder.setElse(this.elseValue.toProtobuf());
        }
        Expression.Builder builder = Expression.newBuilder();
        builder.setIfThen(ifThenBuilder.build());
        return builder.build();
    }
}

