/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.expression;

import com.google.protobuf.CodedInputStream;
import io.substrait.proto.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ConverterUtils$FunctionConfig$;
import org.apache.gluten.expression.ExpressionType;
import org.apache.gluten.substrait.type.TypeBuilder;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ConverterUtils$
implements Logging {
    public static ConverterUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ConverterUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Attribute getAttrFromExpr(Expression expr) {
        return (Attribute)((Expression)expr.transformDown((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    object = alias.toAttribute();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof Alias;
                return bl;
            }
        })).references().head();
    }

    public String normalizeColName(String name) {
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        return caseSensitive ? name : name.toLowerCase(Locale.ROOT);
    }

    public String normalizeStructFieldName(String name) {
        return BackendsApiManager$.MODULE$.getSettings().structFieldToLowerCase() ? this.normalizeColName(name) : name;
    }

    /*
     * WARNING - void declaration
     */
    public String getShortAttributeName(Attribute attr) {
        void var2_2;
        String name = this.normalizeColName(attr.name());
        int subIndex = name.indexOf("(");
        return subIndex != -1 ? name.substring(0, subIndex) : var2_2;
    }

    public String genColumnNameWithoutExprId(Attribute attr) {
        return this.getShortAttributeName(attr);
    }

    public String genColumnNameWithExprId(Attribute attr) {
        return new StringBuilder(1).append(this.getShortAttributeName(attr)).append("#").append(attr.exprId().id()).toString();
    }

    public List<TypeNode> collectAttributeTypeNodes(List<Attribute> attributes) {
        return this.collectAttributeTypeNodes((Seq<Attribute>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(attributes).asScala()).toSeq());
    }

    public List<TypeNode> collectAttributeTypeNodes(Seq<Attribute> attributes) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)attributes.map((Function1 & Serializable & scala.Serializable)attr -> MODULE$.getTypeNode(attr.dataType(), attr.nullable()), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    public List<TypeNode> collectAttributeTypeNodes(StructType structType) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.getTypeNode(f.dataType(), f.nullable()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeNode.class))))).toList()).asJava();
    }

    public List<String> collectAttributeNamesWithExprId(List<Attribute> attributes) {
        return this.collectAttributeNamesWithExprId((Seq<Attribute>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(attributes).asScala()).toSeq());
    }

    public List<String> collectAttributeNamesWithExprId(Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable & scala.Serializable)attr -> MODULE$.genColumnNameWithExprId((Attribute)attr));
    }

    public List<String> collectAttributeNamesWithoutExprId(Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable & scala.Serializable)attr -> MODULE$.normalizeColName(attr.name()));
    }

    public List<String> collectAttributeNames(Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.name());
    }

    /*
     * WARNING - void declaration
     */
    private List<String> collectAttributeNamesDFS(Seq<Attribute> attributes, Function1<Attribute, String> f) {
        void var3_3;
        ArrayList nameList = new ArrayList();
        attributes.foreach((Function1 & Serializable & scala.Serializable)attr -> {
            BoxedUnit boxedUnit;
            nameList.add(f.apply(attr));
            if (BackendsApiManager$.MODULE$.getSettings().supportStructType()) {
                Object object;
                DataType dataType = attr.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    List<String> nestedNames = MODULE$.collectStructFieldNames((DataType)structType);
                    object = BoxesRunTime.boxToBoolean((boolean)nameList.addAll(nestedNames));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = object;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> collectStructFieldNames(DataType dataType) {
        void var3_2;
        ArrayList nameList = new ArrayList();
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ConverterUtils$.$anonfun$collectStructFieldNames$1(nameList, field)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public boolean isNullable(Type.Nullability nullability) {
        Type.Nullability nullability2 = nullability;
        Type.Nullability nullability3 = Type.Nullability.NULLABILITY_NULLABLE;
        return !(nullability2 != null ? !((Object)((Object)nullability2)).equals((Object)nullability3) : nullability3 != null);
    }

    public Tuple2<DataType, Object> parseFromSubstraitType(Type substraitType) {
        Tuple2 tuple2;
        Type.KindCase kindCase = substraitType.getKindCase();
        if (((Object)((Object)Type.KindCase.BOOL)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)BooleanType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getBool().getNullability())));
        } else if (((Object)((Object)Type.KindCase.I8)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)ByteType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI8().getNullability())));
        } else if (((Object)((Object)Type.KindCase.I16)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)ShortType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI16().getNullability())));
        } else if (((Object)((Object)Type.KindCase.I32)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI32().getNullability())));
        } else if (((Object)((Object)Type.KindCase.I64)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)LongType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI64().getNullability())));
        } else if (((Object)((Object)Type.KindCase.FP32)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)FloatType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getFp32().getNullability())));
        } else if (((Object)((Object)Type.KindCase.FP64)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getFp64().getNullability())));
        } else if (((Object)((Object)Type.KindCase.STRING)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)StringType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getString().getNullability())));
        } else if (((Object)((Object)Type.KindCase.BINARY)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)BinaryType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getBinary().getNullability())));
        } else if (((Object)((Object)Type.KindCase.TIMESTAMP)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)TimestampType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getTimestamp().getNullability())));
        } else if (((Object)((Object)Type.KindCase.DATE)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)DateType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getDate().getNullability())));
        } else if (((Object)((Object)Type.KindCase.DECIMAL)).equals((Object)kindCase)) {
            Type.Decimal decimal = substraitType.getDecimal();
            int precision = decimal.getPrecision();
            int scale = decimal.getScale();
            tuple2 = new Tuple2((Object)new DecimalType(precision, scale), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(decimal.getNullability())));
        } else if (((Object)((Object)Type.KindCase.STRUCT)).equals((Object)kindCase)) {
            Type.Struct struct_ = substraitType.getStruct();
            Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(struct_.getTypesList()).asScala()).map((Function1 & Serializable & scala.Serializable)typ -> {
                Tuple2<DataType, Object> tuple2 = MODULE$.parseFromSubstraitType((Type)typ);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DataType field = (DataType)tuple2._1();
                boolean nullable = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)field, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
                Tuple2 tuple23 = tuple22;
                DataType field2 = (DataType)tuple23._1();
                boolean nullable2 = tuple23._2$mcZ$sp();
                return new StructField("", field2, nullable2, StructField$.MODULE$.apply$default$4());
            }, Buffer$.MODULE$.canBuildFrom());
            tuple2 = new Tuple2((Object)StructType$.MODULE$.apply(fields.toSeq()), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getStruct().getNullability())));
        } else if (((Object)((Object)Type.KindCase.LIST)).equals((Object)kindCase)) {
            Type.List list = substraitType.getList();
            Tuple2<DataType, Object> tuple22 = this.parseFromSubstraitType(list.getType());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            DataType elementType = (DataType)tuple22._1();
            boolean containsNull = tuple22._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
            Tuple2 tuple24 = tuple23;
            DataType elementType2 = (DataType)tuple24._1();
            boolean containsNull2 = tuple24._2$mcZ$sp();
            tuple2 = new Tuple2((Object)new ArrayType(elementType2, containsNull2), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getList().getNullability())));
        } else if (((Object)((Object)Type.KindCase.MAP)).equals((Object)kindCase)) {
            DataType keyType;
            Type.Map map = substraitType.getMap();
            Tuple2<DataType, Object> tuple25 = this.parseFromSubstraitType(map.getKey());
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            DataType dataType = keyType = (DataType)tuple25._1();
            DataType keyType2 = dataType;
            Tuple2<DataType, Object> tuple26 = this.parseFromSubstraitType(map.getValue());
            if (tuple26 == null) {
                throw new MatchError(tuple26);
            }
            DataType valueType = (DataType)tuple26._1();
            boolean valueContainsNull = tuple26._2$mcZ$sp();
            Tuple2 tuple27 = new Tuple2((Object)valueType, (Object)BoxesRunTime.boxToBoolean((boolean)valueContainsNull));
            Tuple2 tuple28 = tuple27;
            DataType valueType2 = (DataType)tuple28._1();
            boolean valueContainsNull2 = tuple28._2$mcZ$sp();
            tuple2 = new Tuple2((Object)new MapType(keyType2, valueType2, valueContainsNull2), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getMap().getNullability())));
        } else if (((Object)((Object)Type.KindCase.NOTHING)).equals((Object)kindCase)) {
            tuple2 = new Tuple2((Object)NullType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            throw new GlutenNotSupportException(new StringBuilder(20).append("Type ").append((Object)kindCase).append(" not supported.").toString());
        }
        return tuple2;
    }

    public TypeNode getTypeNode(DataType datatype, boolean nullable) {
        TypeNode typeNode;
        DataType dataType = datatype;
        if (BooleanType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeBoolean(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeFP32(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeFP64(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (LongType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeI64(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeI32(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeI16(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeI8(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (StringType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeString(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeBinary(Predef$.MODULE$.boolean2Boolean(nullable));
        } else if (DateType$.MODULE$.equals(dataType)) {
            typeNode = TypeBuilder.makeDate(Predef$.MODULE$.boolean2Boolean(nullable));
        } else {
            YearMonthIntervalType yearMonthIntervalType = YearMonthIntervalType$.MODULE$.DEFAULT();
            DataType dataType2 = dataType;
            if (!(yearMonthIntervalType != null ? !yearMonthIntervalType.equals(dataType2) : dataType2 != null)) {
                typeNode = TypeBuilder.makeIntervalYear(Predef$.MODULE$.boolean2Boolean(nullable));
            } else if (DecimalType$.MODULE$.unapply(dataType)) {
                DecimalType decimalType = (DecimalType)datatype;
                int precision = decimalType.precision();
                int scale = decimalType.scale();
                typeNode = TypeBuilder.makeDecimal(Predef$.MODULE$.boolean2Boolean(nullable), Predef$.MODULE$.int2Integer(precision), Predef$.MODULE$.int2Integer(scale));
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                typeNode = TypeBuilder.makeTimestamp(Predef$.MODULE$.boolean2Boolean(nullable));
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                typeNode = TypeBuilder.makeMap(Predef$.MODULE$.boolean2Boolean(nullable), this.getTypeNode(mapType.keyType(), false), this.getTypeNode(mapType.valueType(), mapType.valueContainsNull()));
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                typeNode = TypeBuilder.makeList(Predef$.MODULE$.boolean2Boolean(nullable), this.getTypeNode(arrayType.elementType(), arrayType.containsNull()));
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                ArrayList<TypeNode> fieldNodes = new ArrayList<TypeNode>();
                ArrayList<String> fieldNames = new ArrayList<String>();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)structField -> BoxesRunTime.boxToBoolean((boolean)ConverterUtils$.$anonfun$getTypeNode$1(fieldNodes, fieldNames, structField)));
                typeNode = TypeBuilder.makeStruct(Predef$.MODULE$.boolean2Boolean(nullable), fieldNodes, fieldNames);
            } else if (dataType instanceof NullType) {
                typeNode = TypeBuilder.makeNothing();
            } else {
                throw new GlutenNotSupportException(new StringBuilder(20).append("Type ").append(dataType).append(" not supported.").toString());
            }
        }
        return typeNode;
    }

    public ExpressionType parseFromBytes(byte[] bytes) {
        CodedInputStream input = CodedInputStream.newInstance((byte[])bytes);
        Type parsed = Type.parseFrom(input);
        Tuple2<DataType, Object> tuple2 = this.parseFromSubstraitType(parsed);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DataType dataType = (DataType)tuple2._1();
        boolean nullable = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
        Tuple2 tuple23 = tuple22;
        DataType dataType2 = (DataType)tuple23._1();
        boolean nullable2 = tuple23._2$mcZ$sp();
        return new ExpressionType(dataType2, nullable2);
    }

    public void printBatch(ColumnarBatch cb) {
        ObjectRef batch = ObjectRef.create((Object)"");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cb.numRows()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rowId -> {
            ObjectRef row = ObjectRef.create((Object)"");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cb.numCols()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)colId -> {
                row$1.elem = new StringBuilder(0).append((String)row$1.elem).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)cb.column(colId).getUTF8String(rowId)), " ")).toString();
            });
            batch$1.elem = new StringBuilder(1).append((String)batch$1.elem).append((String)row.elem).append("\n").toString();
        });
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("batch:\n").append((String)batch$1.elem).toString());
    }

    public boolean ifEquals(Seq<AttributeReference> left, Seq<NamedExpression> right) {
        boolean bl;
        Object object = new Object();
        try {
            if (left.size() != right.size()) {
                return false;
            }
            left.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ExprId exprId = ((AttributeReference)left.apply(i)).exprId();
                ExprId exprId2 = ((NamedExpression)right.apply(i)).exprId();
                if (exprId == null ? exprId2 != null : !exprId.equals(exprId2)) {
                    throw new NonLocalReturnControl.mcZ.sp(object, false);
                }
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public String toString() {
        return "ConverterUtils";
    }

    public Tuple3<String, Object, Object> powerOfTen(int pow) {
        Tuple3[] POWERS_OF_10 = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000", (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000", (Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000", (Object)BoxesRunTime.boxToInteger((int)14), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000", (Object)BoxesRunTime.boxToInteger((int)15), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000", (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000", (Object)BoxesRunTime.boxToInteger((int)18), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000", (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000", (Object)BoxesRunTime.boxToInteger((int)21), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)23), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)24), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)26), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)27), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)28), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)29), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)31), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)32), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)33), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)34), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)35), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)36), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)37), (Object)BoxesRunTime.boxToInteger((int)0))});
        return POWERS_OF_10[pow];
    }

    public String getTypeSigName(DataType dataType) {
        String string;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            string = "bool";
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            string = "i8";
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            string = "i16";
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            string = "i32";
        } else if (LongType$.MODULE$.equals(dataType2)) {
            string = "i64";
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            string = "fp32";
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            string = "fp64";
        } else if (DateType$.MODULE$.equals(dataType2)) {
            string = "date";
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            string = "ts";
        } else if (StringType$.MODULE$.equals(dataType2)) {
            string = "str";
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            string = "vbin";
        } else if (DecimalType$.MODULE$.unapply(dataType2)) {
            DecimalType decimalType = (DecimalType)dataType;
            int precision = decimalType.precision();
            int scale = decimalType.scale();
            string = new StringBuilder(6).append("dec<").append(precision).append(",").append(scale).append(">").toString();
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            string = new StringBuilder(6).append("list<").append(this.getTypeSigName(elementType)).append(">").toString();
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            ObjectRef sigName = ObjectRef.create((Object)"struct<");
            IntRef index = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foreach((Function1 & Serializable & scala.Serializable)field -> {
                ConverterUtils$.$anonfun$getTypeSigName$1(sigName, index, fields, field);
                return BoxedUnit.UNIT;
            });
            sigName.elem = ((String)sigName.elem).concat(">");
            string = (String)sigName.elem;
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            String sigName = "map<";
            sigName = sigName.concat(this.getTypeSigName(keyType));
            sigName = sigName.concat(",");
            sigName = sigName.concat(this.getTypeSigName(valueType));
            string = sigName = sigName.concat(">");
        } else if (dataType2 instanceof CharType) {
            string = "fchar";
        } else if (NullType$.MODULE$.equals(dataType2)) {
            string = "nothing";
        } else {
            throw new GlutenNotSupportException(new StringBuilder(20).append("Type ").append(dataType2).append(" not supported.").toString());
        }
        return string;
    }

    public String makeFuncName(String funcName, Seq<DataType> datatypes, Enumeration.Value config) {
        String string;
        Enumeration.Value value = config;
        Enumeration.Value value2 = ConverterUtils$FunctionConfig$.MODULE$.REQ();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = funcName.concat(":req_");
        } else {
            Enumeration.Value value4 = ConverterUtils$FunctionConfig$.MODULE$.OPT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = funcName.concat(":opt_");
            } else {
                Enumeration.Value value6 = ConverterUtils$FunctionConfig$.MODULE$.NON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    string = funcName.concat(":");
                } else {
                    throw new GlutenNotSupportException(new StringBuilder(18).append(value).append(" is not supported.").toString());
                }
            }
        }
        ObjectRef typedFuncName = ObjectRef.create((Object)string);
        datatypes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            block0: {
                typedFuncName$1.elem = ((String)typedFuncName$1.elem).concat(MODULE$.getTypeSigName((DataType)datatypes.apply(idx)));
                if (idx >= datatypes.size() - 1) break block0;
                typedFuncName$1.elem = ((String)typedFuncName$1.elem).concat("_");
            }
        });
        return (String)typedFuncName.elem;
    }

    public Enumeration.Value makeFuncName$default$3() {
        return ConverterUtils$FunctionConfig$.MODULE$.NON();
    }

    public String convertJoinType(JoinType joinType) {
        String string;
        JoinType joinType2 = joinType;
        if (Inner$.MODULE$.equals(joinType2)) {
            string = "Inner";
        } else if (FullOuter$.MODULE$.equals(joinType2)) {
            string = "Outer";
        } else {
            boolean bl = LeftOuter$.MODULE$.equals(joinType2) ? true : RightOuter$.MODULE$.equals(joinType2);
            if (bl) {
                string = "Left";
            } else if (LeftSemi$.MODULE$.equals(joinType2)) {
                string = "Semi";
            } else if (LeftAnti$.MODULE$.equals(joinType2)) {
                string = "Anti";
            } else {
                throw new GlutenNotSupportException(new StringBuilder(23).append("Unsupported join type: ").append(joinType2).toString());
            }
        }
        return string;
    }

    public final String ITERATOR_PREFIX() {
        return "iterator:";
    }

    public static final /* synthetic */ boolean $anonfun$collectStructFieldNames$1(ArrayList nameList$2, StructField field) {
        nameList$2.add(MODULE$.normalizeColName(field.name()));
        List<String> nestedNames = MODULE$.collectStructFieldNames(field.dataType());
        return nameList$2.addAll(nestedNames);
    }

    public static final /* synthetic */ boolean $anonfun$getTypeNode$1(ArrayList fieldNodes$1, ArrayList fieldNames$1, StructField structField) {
        fieldNodes$1.add(MODULE$.getTypeNode(structField.dataType(), structField.nullable()));
        return fieldNames$1.add(MODULE$.normalizeStructFieldName(structField.name()));
    }

    public static final /* synthetic */ void $anonfun$getTypeSigName$1(ObjectRef sigName$1, IntRef index$1, StructField[] fields$1, StructField field) {
        sigName$1.elem = ((String)sigName$1.elem).concat(MODULE$.getTypeSigName(field.dataType()));
        sigName$1.elem = ((String)sigName$1.elem).concat(index$1.elem < fields$1.length - 1 ? "," : "");
        ++index$1.elem;
    }

    private ConverterUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

