/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.FakeRow;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriterBucketSpec;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md!\u0002\u000e\u001c\u0003\u0003A\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011E\u0002!\u0011!Q\u0001\nIB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")!\f\u0001C\u00017\"9\u0011\r\u0001b\u0001\n#\u0011\u0007BB4\u0001A\u0003%1\rC\u0004i\u0001\t\u0007I\u0011\u00032\t\r%\u0004\u0001\u0015!\u0003d\u0011%Q\u0007\u00011AA\u0002\u0013E1\u000eC\u0005p\u0001\u0001\u0007\t\u0019!C\ta\"Ia\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\no\u0002\u0001\r\u00111A\u0005\u0012aD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011C?\t\u0013}\u0004\u0001\u0019!A!B\u0013I\bBCA\u0001\u0001!\u0015\r\u0011\"\u0005\u0002\u0004!Q\u00111\u0005\u0001\t\u0006\u0004%I!!\n\t\u0015\u00055\u0002\u0001#b\u0001\n\u0013\ty\u0003\u0003\u0006\u00024\u0001A)\u0019!C\t\u0003kA\u0011\"!\u000f\u0001\u0005\u0004%\t\"a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{Aq!!\u0012\u0001\t#\t9\u0005C\u0004\u0002^\u0001!\t\"a\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0005\u0002h!9\u0011Q\u000e\u0001\u0005\u0012\u0005=$A\b\"bg\u0016$\u0015P\\1nS\u000e\u0004\u0016M\u001d;ji&|g\u000eR1uC^\u0013\u0018\u000e^3s\u0015\taR$A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001SA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0015\r&dWMR8s[\u0006$H)\u0019;b/JLG/\u001a:\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\t\u0003U=J!\u0001M\u000e\u0003']\u0013\u0018\u000e^3K_\n$Um]2sSB$\u0018n\u001c8\u0002%Q\f7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n\u0011\"\\1qe\u0016$WoY3\u000b\u0005]\u001a\u0013A\u00025bI>|\u0007/\u0003\u0002:i\t\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003%\u0019w.\\7jiR,'\u000f\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005\u0011\u0011n\u001c\u0006\u0003\u0001\u0006\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0005v\u0012!CR5mK\u000e{W.\\5u!J|Go\\2pY\u0006i1-^:u_6lU\r\u001e:jGN\u0004B!\u0012(R):\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u001e\na\u0001\u0010:p_Rt$\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S\u0015A\u0002)sK\u0012,g-\u0003\u0002P!\n\u0019Q*\u00199\u000b\u00055S\u0005CA#S\u0013\t\u0019\u0006K\u0001\u0004TiJLgn\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/v\ta!\\3ue&\u001c\u0017BA-W\u0005%\u0019\u0016\u000bT'fiJL7-\u0001\u0004=S:LGO\u0010\u000b\u00069vsv\f\u0019\t\u0003U\u0001AQ!L\u0003A\u00029BQ!M\u0003A\u0002IBQAO\u0003A\u0002mBQaQ\u0003A\u0002\u0011\u000bQ\"[:QCJ$\u0018\u000e^5p]\u0016$W#A2\u0011\u0005\u0011,W\"\u0001&\n\u0005\u0019T%a\u0002\"p_2,\u0017M\\\u0001\u000fSN\u0004\u0016M\u001d;ji&|g.\u001a3!\u0003)I7OQ;dW\u0016$X\rZ\u0001\fSN\u0014UoY6fi\u0016$\u0007%A\u0007sK\u000e|'\u000fZ:J]\u001aKG.Z\u000b\u0002YB\u0011A-\\\u0005\u0003]*\u0013A\u0001T8oO\u0006\t\"/Z2pe\u0012\u001c\u0018J\u001c$jY\u0016|F%Z9\u0015\u0005E$\bC\u00013s\u0013\t\u0019(J\u0001\u0003V]&$\bbB;\f\u0003\u0003\u0005\r\u0001\\\u0001\u0004q\u0012\n\u0014A\u0004:fG>\u0014Hm]%o\r&dW\rI\u0001\fM&dWmQ8v]R,'/F\u0001z!\t!'0\u0003\u0002|\u0015\n\u0019\u0011J\u001c;\u0002\u001f\u0019LG.Z\"pk:$XM]0%KF$\"!\u001d@\t\u000fUt\u0011\u0011!a\u0001s\u0006aa-\u001b7f\u0007>,h\u000e^3sA\u0005\u0011r-\u001a;QCJ$\u0018\u000e^5p]Z\u000bG.^3t+\t\t)\u0001E\u0004e\u0003\u000f\tY!a\u0006\n\u0007\u0005%!JA\u0005Gk:\u001cG/[8ocA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012}\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003+\tyAA\u0006J]R,'O\\1m%><\b\u0003BA\r\u0003?i!!a\u0007\u000b\t\u0005u\u0011qB\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\"\u0005m!!C+og\u00064WMU8x\u0003]\u0001\u0018M\u001d;ji&|g\u000eU1uQ\u0016C\bO]3tg&|g.\u0006\u0002\u0002(A!\u0011\u0011DA\u0015\u0013\u0011\tY#a\u0007\u0003\u0015\u0015C\bO]3tg&|g.\u0001\thKR\u0004\u0016M\u001d;ji&|g\u000eU1uQV\u0011\u0011\u0011\u0007\t\u0007I\u0006\u001d\u00111B)\u0002\u0017\u001d,GOQ;dW\u0016$\u0018\nZ\u000b\u0003\u0003o\u0001b\u0001ZA\u0004\u0003\u0017I\u0018\u0001D4fi>+H\u000f];u%><XCAA\u001f!\u0011\tI\"a\u0010\n\t\u0005\u0005\u00131\u0004\u0002\u0011+:\u001c\u0018MZ3Qe>TWm\u0019;j_:\fQbZ3u\u001fV$\b/\u001e;S_^\u0004\u0013A\u0005:f]\u0016<8)\u001e:sK:$xK]5uKJ$r!]A%\u0003'\nI\u0006C\u0004\u0002LY\u0001\r!!\u0014\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKN\u0004R\u0001ZA(\u0003\u0017I1!!\u0015K\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\u000b\fA\u0002\u0005]\u0013\u0001\u00032vG.,G/\u00133\u0011\t\u0011\fy%\u001f\u0005\u0007\u000372\u0002\u0019A2\u0002%\rdwn]3DkJ\u0014XM\u001c;Xe&$XM]\u0001#e\u0016tWm^\"veJ,g\u000e^,sSR,'/\u00134U_>l\u0015M\\=SK\u000e|'\u000fZ:\u0015\u000bE\f\t'a\u0019\t\u000f\u0005-s\u00031\u0001\u0002N!9\u0011QK\fA\u0002\u0005]\u0013aE;qI\u0006$XMU3d_J$7/\u00138GS2,GcA9\u0002j!9\u00111\u000e\rA\u0002\u0005-\u0011A\u0002:fG>\u0014H-A\u0006xe&$XMU3d_J$GcA9\u0002r!9\u00111N\rA\u0002\u0005-\u0001")
public abstract class BaseDynamicPartitionDataWriter
extends FileFormatDataWriter {
    private Function1<InternalRow, UnsafeRow> getPartitionValues;
    private Expression partitionPathExpression;
    private Function1<InternalRow, String> getPartitionPath;
    private Function1<InternalRow, Object> getBucketId;
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private final boolean isPartitioned;
    private final boolean isBucketed;
    private long recordsInFile;
    private int fileCounter;
    private final UnsafeProjection getOutputRow;
    private volatile byte bitmap$0;

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public boolean isBucketed() {
        return this.isBucketed;
    }

    public long recordsInFile() {
        return this.recordsInFile;
    }

    public void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    public int fileCounter() {
        return this.fileCounter;
    }

    public void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private Function1<InternalRow, UnsafeRow> getPartitionValues$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create(this.description.partitionColumns(), this.description.allColumns());
                this.getPartitionValues = (Function1 & Serializable & scala.Serializable)row -> proj.apply(row);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.getPartitionValues;
    }

    public Function1<InternalRow, UnsafeRow> getPartitionValues() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.getPartitionValues$lzycompute() : this.getPartitionValues;
    }

    private Expression partitionPathExpression$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionPathExpression = new Concat((Seq)((TraversableLike)this.description.partitionColumns().zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Attribute c = (Attribute)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ScalaUDF partitionName = new ScalaUDF((Function2 & Serializable & scala.Serializable)(col, value) -> ExternalCatalogUtils$.MODULE$.getPartitionPathString(col, value), (DataType)StringType$.MODULE$, (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)c.name()), (List)new .colon.colon((Object)new Cast((Expression)c, (DataType)StringType$.MODULE$, Option$.MODULE$.apply((Object)$this.description.timeZoneId()), Cast$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), ScalaUDF$.MODULE$.apply$default$4(), ScalaUDF$.MODULE$.apply$default$5(), ScalaUDF$.MODULE$.apply$default$6(), ScalaUDF$.MODULE$.apply$default$7(), ScalaUDF$.MODULE$.apply$default$8());
                    Seq seq = i == 0 ? (Seq)new .colon.colon((Object)partitionName, (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"/"), (List)new .colon.colon((Object)partitionName, (List)Nil$.MODULE$));
                    return seq;
                }, Seq$.MODULE$.canBuildFrom()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionPathExpression;
    }

    private Expression partitionPathExpression() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionPathExpression$lzycompute() : this.partitionPathExpression;
    }

    private Function1<InternalRow, String> getPartitionPath$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)this.partitionPathExpression(), (List)Nil$.MODULE$), this.description.partitionColumns());
                this.getPartitionPath = (Function1 & Serializable & scala.Serializable)row -> proj.apply(row).getString(0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.getPartitionPath;
    }

    private Function1<InternalRow, String> getPartitionPath() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.getPartitionPath$lzycompute() : this.getPartitionPath;
    }

    private Function1<InternalRow, Object> getBucketId$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)((WriterBucketSpec)this.description.bucketSpec().get()).bucketIdExpression(), (List)Nil$.MODULE$), this.description.allColumns());
                this.getBucketId = (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)BaseDynamicPartitionDataWriter.$anonfun$getBucketId$1(proj, row));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.getBucketId;
    }

    public Function1<InternalRow, Object> getBucketId() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.getBucketId$lzycompute() : this.getBucketId;
    }

    public UnsafeProjection getOutputRow() {
        return this.getOutputRow;
    }

    public void renewCurrentWriter(Option<InternalRow> partitionValues, Option<Object> bucketId, boolean closeCurrentWriter) {
        String string;
        this.recordsInFile_$eq(0L);
        if (closeCurrentWriter) {
            this.releaseCurrentWriter();
        }
        Option partDir = partitionValues.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)this.getPartitionPath().apply(x$7));
        partDir.foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)BaseDynamicPartitionDataWriter.$anonfun$renewCurrentWriter$2(this, elem)));
        String bucketIdStr = (String)bucketId.map((Function1 & Serializable & scala.Serializable)id -> BucketingUtils$.MODULE$.bucketIdToString(BoxesRunTime.unboxToInt((Object)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option<Object> option = bucketId;
        if (option instanceof Some) {
            Some some = (Some)option;
            int id2 = BoxesRunTime.unboxToInt((Object)some.value());
            string = (String)((WriterBucketSpec)this.description.bucketSpec().get()).bucketFileNamePrefix().apply((Object)BoxesRunTime.boxToInteger((int)id2));
        } else {
            string = "";
        }
        String prefix = string;
        String arg$macro$1 = bucketIdStr;
        int arg$macro$2 = this.fileCounter();
        String suffix = new StringBuilder(0).append(new StringOps("%s.c%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToInteger((int)arg$macro$2)}))).append(this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext)).toString();
        FileNameSpec fileNameSpec = new FileNameSpec(prefix, suffix);
        Option customPath = partDir.flatMap((Function1 & Serializable & scala.Serializable)dir -> $this.description.customPartitionLocations().get((Object)PartitioningUtils$.MODULE$.parsePathFragment(dir)));
        String currentPath = customPath.isDefined() ? this.committer.newTaskTempFileAbsPath(this.taskAttemptContext, (String)customPath.get(), fileNameSpec) : this.committer.newTaskTempFile(this.taskAttemptContext, partDir, fileNameSpec);
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    public void renewCurrentWriterIfTooManyRecords(Option<InternalRow> partitionValues, Option<Object> bucketId) {
        this.fileCounter_$eq(this.fileCounter() + 1);
        Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
        this.renewCurrentWriter(partitionValues, bucketId, true);
    }

    public void updateRecordsInFile(InternalRow record) {
        InternalRow internalRow = record;
        if (internalRow instanceof FakeRow) {
            FakeRow fakeRow = (FakeRow)internalRow;
            this.recordsInFile_$eq(this.recordsInFile() + (long)fakeRow.batch().numRows());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.recordsInFile_$eq(this.recordsInFile() + 1L);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void writeRecord(InternalRow record) {
        UnsafeRow outputRow = this.getOutputRow().apply(record);
        this.currentWriter().write((InternalRow)outputRow);
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.newRow(this.currentWriter().path(), (InternalRow)outputRow);
            return BoxedUnit.UNIT;
        });
        this.recordsInFile_$eq(this.recordsInFile() + 1L);
    }

    public static final /* synthetic */ int $anonfun$getBucketId$1(UnsafeProjection proj$3, InternalRow row) {
        return proj$3.apply(row).getInt(0);
    }

    public static final /* synthetic */ boolean $anonfun$renewCurrentWriter$2(BaseDynamicPartitionDataWriter $this, String elem) {
        return $this.updatedPartitions().add((Object)elem);
    }

    public BaseDynamicPartitionDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer, customMetrics);
        this.isPartitioned = description.partitionColumns().nonEmpty();
        this.isBucketed = description.bucketSpec().isDefined();
        Predef$.MODULE$.assert(this.isPartitioned() || this.isBucketed(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(176).append("DynamicPartitionWriteTask should be used for writing out data that's either\n       |partitioned or bucketed. In this case neither is true.\n       |WriteJobDescription: ").append($this.description).append("\n       ").toString())).stripMargin());
        this.getOutputRow = UnsafeProjection$.MODULE$.create(description.dataColumns(), description.allColumns());
    }
}

