/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlutenCacheRequestLimits
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlutenCacheRequestLimits.class);
    private static final AtomicInteger RUNNING_STATS = new AtomicInteger(0);
    private final int maxConcurrentQuery = KylinConfig.getInstanceFromEnv().getConcurrentRunningThresholdForGlutenCache();

    static boolean openQueryRequest(int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return true;
        }
        try {
            int running;
            while ((running = RUNNING_STATS.get()) < maxConcurrentQuery) {
                if (!RUNNING_STATS.compareAndSet(running, running + 1)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getGlutenCacheTooManyRunning());
        }
    }

    static void closeQueryRequest(int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return;
        }
        if (RUNNING_STATS.get() != 0) {
            RUNNING_STATS.decrementAndGet();
        }
    }

    public GlutenCacheRequestLimits() {
        boolean ok = GlutenCacheRequestLimits.openQueryRequest(this.maxConcurrentQuery);
        GlutenCacheRequestLimits.checkRequest(ok);
    }

    private static void checkRequest(boolean ok) {
        if (!ok) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getGlutenCacheTooManyRunning());
        }
    }

    @Override
    public void close() {
        GlutenCacheRequestLimits.closeQueryRequest(this.maxConcurrentQuery);
    }
}

