/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;

public final class OrderedProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, String> properties;

    public OrderedProperties() {
        this(new LinkedHashMap<String, String>());
    }

    public OrderedProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static OrderedProperties copyOf(OrderedProperties source) {
        OrderedPropertiesBuilder builder = new OrderedPropertiesBuilder();
        if (source.properties instanceof TreeMap) {
            builder.withOrdering(((TreeMap)source.properties).comparator());
        }
        OrderedProperties result = builder.build();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static OrderedProperties copyAndTrim(@Nonnull OrderedProperties source) {
        Preconditions.checkNotNull((Object)source, (Object)"source cannot be null");
        OrderedPropertiesBuilder builder = new OrderedPropertiesBuilder();
        if (source.properties instanceof TreeMap) {
            builder.withOrdering(((TreeMap)source.properties).comparator());
        }
        OrderedProperties result = builder.build();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            result.setProperty(StringUtils.trim((String)entry.getKey()), StringUtils.trim((String)entry.getValue()));
        }
        return result;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value == null ? defaultValue : value;
    }

    public String setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Enumeration<String> propertyNames() {
        return new Vector<String>(this.properties.keySet()).elements();
    }

    public Set<String> stringPropertyNames() {
        return new LinkedHashSet<String>(this.properties.keySet());
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return new LinkedHashSet<Map.Entry<String, String>>(this.properties.entrySet());
    }

    public void putAll(OrderedProperties others) {
        for (Map.Entry<String, String> each : others.entrySet()) {
            this.properties.put(each.getKey(), each.getValue());
        }
    }

    public void load(InputStream stream) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.load(stream);
    }

    public void load(Reader reader) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.load(reader);
    }

    public void loadFromXML(InputStream stream) throws IOException, InvalidPropertiesFormatException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.loadFromXML(stream);
    }

    public void store(OutputStream stream, String comments) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.store(stream, comments);
    }

    public void store(Writer writer, String comments) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.store(writer, comments);
    }

    public void storeToXML(OutputStream stream, String comment) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.storeToXML(stream, comment);
    }

    public void storeToXML(OutputStream stream, String comment, String encoding) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.storeToXML(stream, comment, encoding);
    }

    public void list(PrintStream stream) {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.list(stream);
    }

    public void list(PrintWriter writer) {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.list(writer);
    }

    public Properties toJdkProperties() {
        Properties jdkProperties = new Properties();
        for (Map.Entry<String, String> entry : this.entrySet()) {
            jdkProperties.put(entry.getKey(), entry.getValue());
        }
        return jdkProperties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OrderedProperties that = (OrderedProperties)other;
        return Arrays.equals(this.properties.entrySet().toArray(), that.properties.entrySet().toArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.properties.entrySet().toArray());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.properties);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.properties = (Map)stream.readObject();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public String toString() {
        return this.properties.toString();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    private static final class CustomProperties
    extends Properties {
        private final Map<String, String> targetProperties;

        private CustomProperties(Map<String, String> targetProperties) {
            this.targetProperties = targetProperties;
        }

        @Override
        public Object get(Object key) {
            return this.targetProperties.get(key);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.targetProperties.put((String)key, (String)value);
        }

        @Override
        public String getProperty(String key) {
            return this.targetProperties.get(key);
        }

        @Override
        public Enumeration<Object> keys() {
            return new Vector<String>(this.targetProperties.keySet()).elements();
        }

        @Override
        public Set<Object> keySet() {
            return new LinkedHashSet<Object>(this.targetProperties.keySet());
        }
    }

    public static final class OrderedPropertiesBuilder {
        private Comparator<? super String> comparator;

        public OrderedPropertiesBuilder withOrdering(Comparator<? super String> comparator) {
            this.comparator = comparator;
            return this;
        }

        public OrderedProperties build() {
            TreeMap<String, String> properties = this.comparator != null ? new TreeMap(this.comparator) : new LinkedHashMap();
            return new OrderedProperties(properties);
        }
    }
}

