/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckUtil {
    public static final Logger logger = LoggerFactory.getLogger(CheckUtil.class);

    public static boolean checkCondition(boolean condition, String message, Object ... args) {
        if (condition) {
            return true;
        }
        logger.debug(message, args);
        return false;
    }

    public static int randomAvailablePort(int minPort, int maxPort) {
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            int p = minPort + rand.nextInt(maxPort - minPort);
            if (!CheckUtil.checkPortAvailable(p)) continue;
            return p;
        }
        throw new RuntimeException("Failed to get random available port between [" + minPort + "," + maxPort + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPortAvailable(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

