/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.storage;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.kylin.common.storage.IStorageProvider;

public class DefaultStorageProvider
implements IStorageProvider {
    @Override
    public ContentSummary getContentSummary(FileSystem fileSystem, Path path) throws IOException {
        try {
            return fileSystem.getContentSummary(path);
        }
        catch (AccessControlException ae) {
            ContentSummaryBean bean = this.recursive(fileSystem, path);
            ContentSummary.Builder builder = new ContentSummary.Builder();
            return builder.fileCount(bean.getFileCount()).length(bean.getLength()).build();
        }
    }

    public ContentSummaryBean recursive(FileSystem fs, Path path) throws IOException {
        ContentSummaryBean result = new ContentSummaryBean();
        for (FileStatus fileStatus : fs.listStatus(path)) {
            if (fileStatus.isDirectory()) {
                ContentSummaryBean bean = this.recursive(fs, fileStatus.getPath());
                result.setFileCount(result.getFileCount() + bean.getFileCount());
                result.setLength(result.getLength() + bean.getLength());
                continue;
            }
            result.setFileCount(result.getFileCount() + 1L);
            result.setLength(result.getLength() + fileStatus.getLen());
        }
        return result;
    }

    class ContentSummaryBean {
        long fileCount = 0L;
        long length = 0L;

        @Generated
        public ContentSummaryBean() {
        }

        @Generated
        public long getFileCount() {
            return this.fileCount;
        }

        @Generated
        public long getLength() {
            return this.length;
        }

        @Generated
        public void setFileCount(long fileCount) {
            this.fileCount = fileCount;
        }

        @Generated
        public void setLength(long length) {
            this.length = length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentSummaryBean)) {
                return false;
            }
            ContentSummaryBean other = (ContentSummaryBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileCount() != other.getFileCount()) {
                return false;
            }
            return this.getLength() == other.getLength();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContentSummaryBean;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileCount = this.getFileCount();
            result = result * 59 + (int)($fileCount >>> 32 ^ $fileCount);
            long $length = this.getLength();
            result = result * 59 + (int)($length >>> 32 ^ $length);
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultStorageProvider.ContentSummaryBean(fileCount=" + this.getFileCount() + ", length=" + this.getLength() + ")";
        }
    }
}

