/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceCompressProxy;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.VersionedRawResource;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.JdbcTransactionHelper;
import org.apache.kylin.common.persistence.metadata.MetadataMapperFactory;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.metadata.mapper.BasicMapper;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectDSLCompleter;
import org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.security.util.InMemoryResource;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class JdbcMetadataStore
extends MetadataStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcMetadataStore.class);
    @VisibleForTesting
    private final SqlSessionFactory sqlSessionFactory;
    @VisibleForTesting
    protected final DataSourceTransactionManager transactionManager;
    private final JdbcTemplate jdbcTemplate;
    private final boolean isUT;
    private final JdbcTransactionHelper helper;

    public JdbcMetadataStore(KylinConfig config) throws Exception {
        super(config);
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters(url);
        DataSource dataSource = JdbcDataSource.getDataSource(props);
        this.transactionManager = JdbcDataSource.getTransactionManager(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        String table = url.getIdentifier();
        this.isUT = config.isUTEnv();
        this.auditLogStore = new JdbcAuditLogStore(config, this.jdbcTemplate, this.transactionManager, table + "_audit_log_v2");
        this.sqlSessionFactory = MetadataMapperFactory.getSqlSessionFactory(dataSource);
        this.createIfNotExist(table);
        if (this.isUT) {
            MetadataMapperFactory.resetMapperTableNameIfNeed(url, this.sqlSessionFactory);
        }
        this.helper = new JdbcTransactionHelper(this.transactionManager);
    }

    @Override
    public <T extends RawResource> List<T> get(MetadataType type, RawResourceFilter filter, boolean needLock, boolean needContent) {
        return this.get(type, filter, needLock, needContent, null);
    }

    @VisibleForTesting
    protected <T extends RawResource> List<T> get(MetadataType type, RawResourceFilter filter, boolean needLock, boolean needContent, List<String> provideSelections) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            BasicMapper mapper = MetadataMapperFactory.createFor(type, session);
            BasicColumn[] selectList = mapper.getSelectList();
            if (provideSelections != null && !provideSelections.isEmpty()) {
                Map<String, BasicColumn> selectColumnMap = mapper.getSelectColumnMap();
                if (needContent && !provideSelections.contains("content")) {
                    provideSelections.add("content");
                }
                selectList = (BasicColumn[])provideSelections.stream().map(selectColumnMap::get).filter(Objects::nonNull).toArray(BasicColumn[]::new);
            }
            if (!needContent) {
                ArrayList<BasicColumn> resultList = new ArrayList<BasicColumn>();
                for (BasicColumn column : selectList) {
                    if ("content".equals(((SqlColumn)column).name())) continue;
                    resultList.add(column);
                }
                selectList = resultList.toArray(new BasicColumn[0]);
            }
            SelectDSLCompleter dsl = MetadataMapperFactory.convertConditionsToDSLCompleter(filter, mapper.getSelectColumnMap());
            List list = needLock ? MyBatis3Utils.selectList(mapper::selectManyWithRecordLock, (BasicColumn[])selectList, mapper.getSqlTable(), (SelectDSLCompleter)dsl) : MyBatis3Utils.selectList(mapper::selectMany, (BasicColumn[])selectList, mapper.getSqlTable(), (SelectDSLCompleter)dsl);
            return list;
        }
    }

    @Override
    public int save(MetadataType type, RawResource rawResource) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            int affectedRow;
            BasicMapper mapper = MetadataMapperFactory.createFor(type, session);
            long mvcc = rawResource.getMvcc();
            BindableColumn metaKeyCol = (BindableColumn)mapper.getSqlColumn("metaKey");
            BindableColumn mvccCol = (BindableColumn)mapper.getSqlColumn("mvcc");
            if (rawResource.getContent() != null) {
                RawResource proxy = RawResourceCompressProxy.createProxy(rawResource);
                Optional record = mapper.selectOneWithColumnsAndRecordLock(c -> (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)c.where(metaKeyCol, (VisitableCondition)SqlBuilder.isEqualTo(proxy::getMetaKey), new AndOrCriteriaGroup[0])).and(mvccCol, (VisitableCondition)SqlBuilder.isEqualTo((Object)(proxy.getMvcc() - 1L)), new AndOrCriteriaGroup[0]), new BasicColumn[]{mapper.getSqlColumn("uuid")});
                if (record.isPresent()) {
                    affectedRow = mapper.updateByPrimaryKeyAndMvcc(proxy);
                } else {
                    assert (this.isUT || mvcc == 0L);
                    affectedRow = mapper.insertOne(proxy);
                }
            } else {
                Optional record = mapper.selectOneWithColumnsAndRecordLock(c -> (QueryExpressionDSL.QueryExpressionWhereBuilder)c.where(metaKeyCol, (VisitableCondition)SqlBuilder.isEqualTo(rawResource::getMetaKey), new AndOrCriteriaGroup[0]), new BasicColumn[]{mapper.getSqlColumn("uuid")});
                if (!record.isPresent()) {
                    int n = -1;
                    return n;
                }
                affectedRow = mapper.delete(c -> (DeleteDSL.DeleteWhereBuilder)c.where(metaKeyCol, (VisitableCondition)SqlBuilder.isEqualTo(rawResource::getMetaKey), new AndOrCriteriaGroup[0]));
            }
            if (affectedRow == 0) {
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update or insert meta key: %s, mvcc: %s", rawResource.getMetaKey(), mvcc));
            }
            int n = affectedRow;
            return n;
        }
    }

    @Override
    public NavigableSet<String> listAll() {
        throw new NotImplementedException("JdbcMetadataStore doesn't support listAll.");
    }

    @Override
    public void dump(ResourceStore store) {
        JdbcUtil.withTransaction(this.transactionManager, () -> {
            NavigableSet<String> resources = store.listResourcesRecursively(MetadataType.ALL.name());
            if (resources == null || resources.isEmpty()) {
                log.info("there is no resources in rootPath ({}),please check the rootPath.", (Object)MetadataType.ALL.name());
                return null;
            }
            for (String resPath : resources) {
                RawResource raw = store.getResource(resPath);
                this.save(raw.getMetaType(), raw);
            }
            return null;
        });
    }

    @Override
    public void uploadFromFile(File folder) {
        JdbcUtil.withTransaction(this.transactionManager, () -> {
            super.uploadFromFile(folder);
            return null;
        });
    }

    @VisibleForTesting
    public void createIfNotExist(String table) throws Exception {
        String fileName = "metadata-jdbc-default.properties";
        if (((BasicDataSource)this.jdbcTemplate.getDataSource()).getDriverClassName().equals("org.postgresql.Driver")) {
            fileName = "metadata-jdbc-postgresql.properties";
        } else if (((BasicDataSource)this.jdbcTemplate.getDataSource()).getDriverClassName().equals("com.mysql.jdbc.Driver")) {
            fileName = "metadata-jdbc-mysql.properties";
        } else if (((BasicDataSource)this.jdbcTemplate.getDataSource()).getDriverClassName().equals("org.h2.Driver")) {
            fileName = "metadata-jdbc-h2.properties";
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        Properties properties = new Properties();
        properties.load(is);
        String sql = properties.getProperty("create.metadata.store.table");
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        sql = sql.replace("%s_", table + "_");
        populator.addScript((Resource)new InMemoryResource(sql));
        populator.setContinueOnError(false);
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.jdbcTemplate.getDataSource());
        log.info("Succeed to create table. Prefix is: {}", (Object)(table + "_"));
    }

    @Override
    public MetadataStore.MemoryMetaData reloadAll() {
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        return JdbcUtil.withTransaction(this.transactionManager, () -> {
            log.info("Start jdbc reloadAll");
            data.getData().keySet().parallelStream().forEach(type -> {
                if (type != MetadataType.TMP_REC) {
                    Map<String, VersionedRawResource> rawResourceMap = data.getData().get(type);
                    this.get((MetadataType)((Object)((Object)type)), new RawResourceFilter(), false, true).forEach(res -> rawResourceMap.put(res.getMetaKey(), new VersionedRawResource((RawResource)res)));
                }
            });
            long offset = this.getAuditLogStore().getMaxId();
            log.info("end reloadAll offset is {}", (Object)offset);
            data.setOffset(offset);
            return data;
        });
    }

    @Generated
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    @Generated
    public TransactionStatus getTransaction() throws TransactionException {
        return this.helper.getTransaction();
    }

    @Override
    @Generated
    public void commit(TransactionStatus status) throws TransactionException {
        this.helper.commit(status);
    }

    @Override
    @Generated
    public void rollback(TransactionStatus status) throws TransactionException {
        this.helper.rollback(status);
    }
}

