/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.kylin.common.ICachedExternalConfigLoader;
import org.apache.kylin.common.util.CompositeMapView;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public class PropertiesDelegate
extends Properties {
    private final transient ConcurrentMap<Object, Object> properties = Maps.newConcurrentMap();
    private final transient IExternalConfigLoader configLoader;
    private final transient Map<Object, Object> delegation;

    public PropertiesDelegate(Properties properties, IExternalConfigLoader configLoader) {
        this.properties.putAll(properties);
        this.configLoader = configLoader;
        this.delegation = configLoader == null ? this.properties : (configLoader instanceof ICachedExternalConfigLoader ? new CompositeMapView<Object, Object>(new Map[]{((ICachedExternalConfigLoader)this.configLoader).getPropertyEntries(), this.properties}) : new CompositeMapView<Object, Object>(this.configLoader.getProperties(), this.properties));
    }

    public void reloadProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public String getProperty(String key) {
        return (String)this.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return (String)this.getOrDefault((Object)key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.delegation.keySet());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.delegation.values());
    }

    @Override
    public boolean contains(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegation.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegation.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegation.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegation.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.delegation.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<?, ?> t) {
        this.properties.putAll(t);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        return this.delegation.keySet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.delegation.entrySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegation.values();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.delegation.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertiesDelegate)) {
            return false;
        }
        PropertiesDelegate other = (PropertiesDelegate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentMap<Object, Object> this$properties = this.properties;
        ConcurrentMap<Object, Object> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        IExternalConfigLoader this$configLoader = this.configLoader;
        IExternalConfigLoader other$configLoader = other.configLoader;
        return !(this$configLoader == null ? other$configLoader != null : !this$configLoader.equals(other$configLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertiesDelegate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<Object, Object> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        IExternalConfigLoader $configLoader = this.configLoader;
        result = result * 59 + ($configLoader == null ? 43 : $configLoader.hashCode());
        return result;
    }
}

