/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.ShellKylinExternalConfigLoaderFactory;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.annotation.ThirdPartyDependencies;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfig
extends KylinConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    private static IExternalConfigLoader configLoader = null;
    final transient ReentrantLock lock = new ReentrantLock();
    public static final String KYLIN_CONF = "KYLIN_CONF";
    private static volatile KylinConfig SYS_ENV_INSTANCE = null;
    private static transient ThreadLocal<KylinConfig> THREAD_ENV_INSTANCE = new ThreadLocal();
    public static final String MODEL_OFFLINE_FLAG = "kylin.model.offline";
    public static final String USE_LEGACY_CONFIG = "KYLIN_LEGACY_CONFIG";
    private final Singletons singletons = new Singletons();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider", "StaticUserGroupService"})})
    public static KylinConfig getInstanceFromEnv() {
        KylinConfig config = THREAD_ENV_INSTANCE.get();
        if (config != null) {
            logger.trace("Using thread local KylinConfig");
            return config;
        }
        if (SYS_ENV_INSTANCE != null) {
            return SYS_ENV_INSTANCE;
        }
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (SYS_ENV_INSTANCE == null) {
                SYS_ENV_INSTANCE = KylinConfig.newKylinConfig(configLoader != null && !KylinConfig.useLegacyConfig() ? configLoader : ShellKylinExternalConfigLoaderFactory.getConfigLoader());
                logger.trace("Created a new KylinConfig by getInstanceFromEnv, KylinConfig Id: {}", (Object)System.identityHashCode(SYS_ENV_INSTANCE));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SYS_ENV_INSTANCE;
        }
    }

    public static KylinConfig readSystemKylinConfig() {
        if (SYS_ENV_INSTANCE == null) {
            return KylinConfig.getInstanceFromEnv();
        }
        return SYS_ENV_INSTANCE;
    }

    public static KylinConfig newKylinConfig() {
        return KylinConfig.newKylinConfig(ShellKylinExternalConfigLoaderFactory.getConfigLoader());
    }

    public static KylinConfig newKylinConfig(IExternalConfigLoader configLoader) {
        try {
            KylinConfig config = new KylinConfig(configLoader);
            config.reloadKylinConfig(new Properties());
            logger.trace("Created a new KylinConfig by newKylinConfig, KylinConfig Id: {}", (Object)System.identityHashCode(config));
            return config;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Failed to find KylinConfig ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigForLocalTest(String localMetaDir) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (!new File(localMetaDir, "kylin.properties").exists()) {
                throw new IllegalArgumentException(localMetaDir + " is not a valid local meta dir");
            }
            KylinConfig.destroyInstance();
            logger.info("Setting KylinConfig to " + localMetaDir);
            Unsafe.setProperty(KYLIN_CONF, localMetaDir);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl(localMetaDir + "/metadata");
            File workingDir = new File(localMetaDir, "working-dir");
            workingDir.mkdirs();
            String path = workingDir.getAbsolutePath();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path.replace("\\", "/");
            config.setProperty("kylin.env.hdfs-working-dir", "file:" + path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void destroyInstance() {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            logger.info("Destroy KylinConfig");
            SYS_ENV_INSTANCE = null;
            THREAD_ENV_INSTANCE = new ThreadLocal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static UriType decideUriType(String metaUri) {
        try {
            File file = new File(metaUri);
            if (file.exists() || metaUri.contains("/")) {
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    return UriType.LOCAL_FOLDER;
                }
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase("kylin.properties")) {
                        return UriType.PROPERTIES_FILE;
                    }
                    throw new IllegalStateException("Metadata uri : " + metaUri + " is a local file but not kylin.properties");
                }
                throw new IllegalStateException("Metadata uri : " + metaUri + " looks like a file but it's neither a file nor a directory");
            }
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not recognized");
        }
        catch (Exception e) {
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not recognized", e);
        }
    }

    public static KylinConfig createInstanceFromUri(String uri) {
        UriType uriType = KylinConfig.decideUriType(uri);
        if (uriType == UriType.LOCAL_FOLDER) {
            KylinConfig config = new KylinConfig();
            config.setMetadataUrl(uri);
            return config;
        }
        if (uriType == UriType.PROPERTIES_FILE) {
            KylinConfig config;
            try {
                config = new KylinConfig();
                FileInputStream is = new FileInputStream(uri);
                Properties prop = KylinConfig.streamToTrimProps(is);
                config.reloadKylinConfig(prop);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return config;
        }
        throw new RuntimeException("not implement");
    }

    public static Properties streamToTrimProps(InputStream is) throws IOException {
        Properties originProps = KylinConfig.streamToProps(is);
        Properties trimProps = new Properties();
        originProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> trimProps.put(StringUtils.trim((String)String.valueOf(k)), StringUtils.trim((String)String.valueOf(v)))));
        return originProps;
    }

    public static Properties streamToProps(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        IOUtils.closeQuietly((InputStream)is);
        return prop;
    }

    public static LinkedHashMap<String, String> trimKVFromMap(@Nullable Map<String, String> originMap) {
        LinkedHashMap newMap = Maps.newLinkedHashMap();
        if (MapUtils.isEmpty(originMap) || originMap == null) {
            return newMap;
        }
        originMap.forEach((k, v) -> newMap.put(StringUtils.trim((String)k), StringUtils.trim((String)v)));
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigInEnvIfMissing(Properties prop) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (SYS_ENV_INSTANCE == null) {
                try {
                    KylinConfig config = new KylinConfig();
                    config.reloadKylinConfig(prop);
                    logger.info("Resetting SYS_ENV_INSTANCE by a input stream: " + System.identityHashCode(config));
                    SYS_ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void setKylinConfigInEnvIfMissing(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        KylinConfig.setKylinConfigInEnvIfMissing(props);
    }

    @Deprecated
    public static void setKylinConfigThreadLocal(KylinConfig config) {
        if (THREAD_ENV_INSTANCE.get() != null) {
            logger.warn("current thread already has a thread local KylinConfig, existing: {}, new: {}", (Object)THREAD_ENV_INSTANCE.get(), (Object)config);
        } else {
            logger.info("current thread local KylinConfig is set to: {}", (Object)config);
        }
        THREAD_ENV_INSTANCE.set(config);
    }

    public static boolean isKylinConfigThreadLocal() {
        return THREAD_ENV_INSTANCE.get() != null;
    }

    public static KylinConfig createKylinConfig(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        return KylinConfig.createKylinConfig(props);
    }

    public static KylinConfig createKylinConfig(KylinConfig another) {
        return KylinConfig.createKylinConfig(another.getRawAllProperties());
    }

    public static KylinConfig createKylinConfig(Properties prop) {
        KylinConfig kylinConfig = new KylinConfig();
        kylinConfig.reloadKylinConfig(prop);
        return kylinConfig;
    }

    public static File getKylinConfDir() {
        return KylinConfig.getSitePropertiesFile().getParentFile();
    }

    static File getSitePropertiesFile() {
        String kylinConfHome = KylinConfig.getKylinConfHome();
        if (!StringUtils.isEmpty((CharSequence)kylinConfHome)) {
            logger.info("Use KYLIN_CONF=" + kylinConfHome);
            return KylinConfig.existFile(kylinConfHome);
        }
        logger.debug("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            throw new KylinConfigCannotInitException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        String path = kylinHome + File.separator + "conf";
        return KylinConfig.existFile(path);
    }

    private static File existFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, "kylin.properties");
    }

    public static Properties buildSiteProperties() {
        Properties conf = new Properties();
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (Map.Entry<String, String> each : orderedProperties.entrySet()) {
            conf.put(each.getKey(), each.getValue());
        }
        return conf;
    }

    private static OrderedProperties buildSiteOrderedProps() {
        String config = configLoader == null ? ShellKylinExternalConfigLoaderFactory.getConfigLoader().getConfig() : configLoader.getConfig();
        StringReader reader = new StringReader(config);
        OrderedProperties orderedProperties = new OrderedProperties();
        try {
            orderedProperties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return orderedProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KylinConfig loadKylinConfigFromHdfs(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("StorageUrl should not be null");
        }
        if (!uri.contains("@hdfs")) {
            throw new IllegalArgumentException("StorageUrl should like @hdfs schema");
        }
        logger.info("Ready to load KylinConfig from uri: {}", (Object)uri);
        StorageURL url = StorageURL.valueOf(uri);
        String metaDir = url.getParameter("path") + "/" + "kylin.properties";
        Path path = new Path(metaDir);
        try (FSDataInputStream is = path.getFileSystem(HadoopUtil.getCurrentConfiguration()).open(new Path(metaDir));){
            Properties prop = KylinConfig.streamToProps((InputStream)is);
            KylinConfig kylinConfig = KylinConfig.createKylinConfig(prop);
            return kylinConfig;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private KylinConfig() {
        this(null);
    }

    private KylinConfig(IExternalConfigLoader configLoader) {
        super(configLoader);
        logger.trace("a new KylinConfig is created with id: {}", (Object)System.identityHashCode(this));
    }

    protected KylinConfig(Properties props, boolean force) {
        super(props, force, null);
        logger.trace("a new KylinConfig is created with id: {}", (Object)System.identityHashCode(this));
    }

    public <T> T getManager(Class<T> clz) {
        return this.getManager(null, clz, null);
    }

    public <T1, T2> T1 getManager(Class<T1> managerClass, Class<T2> entityClass) {
        return this.getManager(null, managerClass, entityClass);
    }

    public <T> T getManager(String project, Class<T> clz) {
        return this.getManager(project, clz, null);
    }

    public <T1, T2> T1 getManager(@Nullable String project, Class<T1> managerClass, @Nullable Class<T2> entityClass) {
        KylinConfig base = this.base();
        if (base != this) {
            return base.getManager(project, managerClass, entityClass);
        }
        Singletons.Creator<Object> creator = clazz -> {
            if (entityClass == null) {
                if (StringUtils.isEmpty((CharSequence)project)) {
                    Method method = clazz.getDeclaredMethod("newInstance", KylinConfig.class);
                    Unsafe.changeAccessibleObject(method, true);
                    return method.invoke(null, this);
                }
                Method method = clazz.getDeclaredMethod("newInstance", KylinConfig.class, String.class);
                Unsafe.changeAccessibleObject(method, true);
                return method.invoke(null, this, project);
            }
            Method method = clazz.getDeclaredMethod("newInstance", Class.class, KylinConfig.class, String.class);
            Unsafe.changeAccessibleObject(method, true);
            return method.invoke(null, entityClass, this, project);
        };
        if (StringUtils.isEmpty((CharSequence)project)) {
            return (T1)this.singletons.getInstance0(managerClass, entityClass, creator);
        }
        return (T1)this.singletons.getInstance0(project, managerClass, entityClass, creator);
    }

    public void clearManagers() {
        KylinConfig base = this.base();
        if (base != this) {
            base.clearManagers();
            return;
        }
        this.singletons.clear();
    }

    public void clearManagersByProject(String project) {
        KylinConfig base = this.base();
        if (base != this) {
            base.clearManagersByProject(project);
            return;
        }
        this.singletons.clearByProject(project);
    }

    public void clearManagersByClz(Class clz) {
        KylinConfig base = this.base();
        if (base != this) {
            base.clearManagersByClz(clz);
            return;
        }
        this.singletons.clearByType(clz);
    }

    public Properties exportToProperties() {
        Properties all = this.getAllProperties();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)all);
        return copy;
    }

    public String exportAllToString() throws IOException {
        Properties allProps = this.getProperties(null);
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (Map.Entry<Object, Object> entry : allProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!orderedProperties.containsProperty(key)) {
                orderedProperties.setProperty(key, value);
                continue;
            }
            if (orderedProperties.getProperty(key).equalsIgnoreCase(value)) continue;
            orderedProperties.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : orderedProperties.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public String exportToString() throws IOException {
        return this.exportToString(null);
    }

    public String exportToString(Collection<String> propertyKeys) throws IOException {
        Properties filteredProps = this.getProperties(propertyKeys);
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        if (propertyKeys != null) {
            for (String key : propertyKeys) {
                if (filteredProps.containsKey(key)) continue;
                filteredProps.put(key, orderedProperties.getProperty(key, ""));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : filteredProps.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void exportToFile(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.getAllProperties().store(fos, file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public boolean isSystemConfig() {
        return SYS_ENV_INSTANCE == this;
    }

    public void reloadKylinConfigPropertiesFromSiteProperties() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Properties newProperties = this.reloadKylinConfig2Properties(KylinConfig.buildSiteProperties());
            this.cachedHdfsWorkingDirectory = null;
            this.properties.reloadProperties(newProperties);
        }
        finally {
            lock.unlock();
        }
    }

    public Properties reloadKylinConfig2Properties(Properties properties) {
        Properties result = BCC.check(properties);
        result.setProperty(BCC.check("kylin.metadata.url.identifier"), this.getMetadataUrlPrefixFromProperties(properties));
        result.setProperty(BCC.check("kylin.metadata.url.unique-id"), this.getMetadataUrlUniqueIdFromProperties(properties));
        result.setProperty(BCC.check("kylin.log.spark-executor-properties-file"), this.getLogSparkExecutorPropertiesFile());
        result.setProperty(BCC.check("kylin.log.spark-driver-properties-file"), this.getLogSparkDriverPropertiesFile());
        result.setProperty(BCC.check("kylin.log.spark-appmaster-properties-file"), this.getLogSparkAppMasterPropertiesFile());
        result.put("kylin.env.hdfs-working-dir", this.makeQualified(new Path(result.getProperty("kylin.env.hdfs-working-dir", "/kylin"))).toString());
        if (result.getProperty("kylin.env.hdfs-data-working-dir") != null) {
            result.put("kylin.env.hdfs-data-working-dir", this.makeQualified(new Path(result.getProperty("kylin.env.hdfs-data-working-dir"))).toString());
        }
        if (result.getProperty("kylin.env.hdfs-write-working-dir") != null) {
            result.put("kylin.env.hdfs-write-working-dir", this.makeQualified(new Path(result.getProperty("kylin.env.hdfs-write-working-dir"))).toString());
        }
        return result;
    }

    public String getMetadataUrlPrefixFromProperties(Properties properties) {
        return this.getMetadataUrlFromProperties(properties).getIdentifier();
    }

    public StorageURL getMetadataUrlFromProperties(Properties properties) {
        return StorageURL.valueOf(this.getOptionalFromProperties("kylin.metadata.url", "kylin_metadata@jdbc", properties));
    }

    public String getOptionalFromProperties(String prop, String dft, Properties properties) {
        String property = SystemPropertiesCache.getProperty(prop);
        return property != null ? this.getSubstitutor().replace(property) : this.getSubstitutor().replace(properties.getProperty(prop, dft));
    }

    public String getChannelFromProperties(Properties properties) {
        return this.getOptionalFromProperties("kylin.env.channel", "on-premises", properties);
    }

    public String getMetadataUrlUniqueIdFromProperties(Properties properties) {
        if ("cloud".equalsIgnoreCase(this.getChannelFromProperties(properties))) {
            return this.getMetadataUrlPrefixFromProperties(properties);
        }
        StorageURL url = this.getMetadataUrlFromProperties(properties);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url.getIdentifier());
        Optional.ofNullable(url.getParameter("url")).map(value -> value.split("\\?")[0]).map(value -> "_" + value).ifPresent(stringBuilder::append);
        String instanceId = stringBuilder.toString().replaceAll("\\W", "_");
        return instanceId;
    }

    public String getHdfsWorkingDirectoryFromProperties(Properties properties) {
        String hdfsWorkingDirectory;
        Path path;
        String root = this.getOptionalFromProperties("kylin.env.hdfs-data-working-dir", null, properties);
        boolean compriseMetaId = false;
        if (root == null) {
            root = this.getOptionalFromProperties("kylin.env.hdfs-working-dir", "/kylin", properties);
            compriseMetaId = true;
        }
        if (!(path = new Path(root)).isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        path = this.makeQualified(path);
        if (compriseMetaId) {
            String metaId = this.getMetadataUrlPrefixFromProperties(properties).replace(':', '-').replace('/', '-');
            path = new Path(path, metaId);
        }
        if (!(root = path.toString()).endsWith("/")) {
            root = root + "/";
        }
        if ((hdfsWorkingDirectory = root).startsWith("file:")) {
            hdfsWorkingDirectory = hdfsWorkingDirectory.replace("file:", "file://");
        } else if (hdfsWorkingDirectory.startsWith("maprfs:")) {
            hdfsWorkingDirectory = hdfsWorkingDirectory.replace("maprfs:", "maprfs://");
        }
        logger.info("Hdfs data working dir is {} in properties", (Object)hdfsWorkingDirectory);
        return hdfsWorkingDirectory;
    }

    public KylinConfig base() {
        return this;
    }

    private int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.base().superHashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof KylinConfig)) {
            return false;
        }
        return this.base() == ((KylinConfig)another).base();
    }

    public String toString() {
        return "KylinConfig " + System.identityHashCode(this) + " with base id: " + System.identityHashCode(this.base());
    }

    public static SetAndUnsetThreadLocalConfig setAndUnsetThreadLocalConfig(KylinConfig config) {
        return new SetAndUnsetThreadLocalConfig(config);
    }

    public static boolean useLegacyConfig() {
        return Objects.equals("true", System.getenv(USE_LEGACY_CONFIG));
    }

    @Generated
    public static void setConfigLoader(IExternalConfigLoader configLoader) {
        KylinConfig.configLoader = configLoader;
    }

    static {
        String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
        Unsafe.setProperty("saffron.default.charset", NATIVE_UTF16_CHARSET_NAME);
        Unsafe.setProperty("saffron.default.nationalcharset", NATIVE_UTF16_CHARSET_NAME);
        Unsafe.setProperty("saffron.default.collation.name", NATIVE_UTF16_CHARSET_NAME + "$en_US");
    }

    public static class SetAndUnsetThreadLocalConfig
    implements AutoCloseable {
        private KylinConfig originThreadLocalConfig = (KylinConfig)KylinConfig.access$100().get();

        private SetAndUnsetThreadLocalConfig(KylinConfig config) {
            if (this.originThreadLocalConfig != null) {
                logger.warn("KylinConfig already hosts thread local instance {}, will be overwritten by {}", (Object)this.originThreadLocalConfig, (Object)config);
            }
            THREAD_ENV_INSTANCE.set(config);
        }

        public KylinConfig get() {
            Preconditions.checkNotNull(THREAD_ENV_INSTANCE.get(), (Object)"KylinConfig thread local instance is already closed");
            return (KylinConfig)THREAD_ENV_INSTANCE.get();
        }

        public KylinConfig getOriginConfig() {
            return this.originThreadLocalConfig == null ? SYS_ENV_INSTANCE : this.originThreadLocalConfig;
        }

        @Override
        public void close() {
            THREAD_ENV_INSTANCE.remove();
            if (this.originThreadLocalConfig != null) {
                THREAD_ENV_INSTANCE.set(this.originThreadLocalConfig);
            }
        }
    }

    public static enum UriType {
        PROPERTIES_FILE,
        REST_ADDR,
        LOCAL_FOLDER,
        HDFS_FILE;

    }
}

