/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jnet;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.jnet.ParentAwareURLStreamHandlerFactory;

public class Installer {
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) throws Exception {
        try {
            URL.setURLStreamHandlerFactory(factory);
        }
        catch (Error err) {
            Field[] fields = URL.class.getDeclaredFields();
            int index = 0;
            Field factoryField = null;
            while (factoryField == null && index < fields.length) {
                Field current = fields[index];
                if (Modifier.isStatic(current.getModifiers()) && current.getType().equals(URLStreamHandlerFactory.class)) {
                    factoryField = current;
                    factoryField.setAccessible(true);
                    continue;
                }
                ++index;
            }
            if (factoryField == null) {
                throw new Exception("Unable to detect static field in the URL class for the URLStreamHandlerFactory. Please report this error together with your exact environment to the Apache Excalibur project.");
            }
            try {
                URLStreamHandlerFactory oldFactory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory instanceof ParentAwareURLStreamHandlerFactory) {
                    ((ParentAwareURLStreamHandlerFactory)factory).setParentFactory(oldFactory);
                }
                factoryField.set(null, factory);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Unable to set url stream handler factory " + factory);
            }
            catch (IllegalAccessException e) {
                throw new Exception("Unable to set url stream handler factory " + factory);
            }
        }
    }

    protected static Field getStaticURLStreamHandlerFactoryField() {
        Field[] fields = URL.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers()) || !fields[i].getType().equals(URLStreamHandlerFactory.class)) continue;
            fields[i].setAccessible(true);
            return fields[i];
        }
        return null;
    }
}

