/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.BigQueryThresholdUpdater;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.security.AccessDeniedException;
import org.apache.kylin.query.util.ConvertToComputedColumn;
import org.apache.kylin.query.util.EscapeTransformer;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.RawSqlParser;
import org.apache.kylin.query.util.RestoreFromComputedColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    private static final Logger log;
    public static final ImmutableSet<String> REMOVED_TRANSFORMERS;
    private static final Pattern SELECT_PATTERN;
    private static final Pattern SELECT_STAR_PTN;
    private static final Pattern LIMIT_PATTERN;
    private static final String SELECT = "select";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";
    public static final String JDBC = "jdbc";
    private static final Map<String, IQueryTransformer> QUERY_TRANSFORMER_MAP;
    private static final EscapeTransformer ESCAPE_TRANSFORMER;

    private QueryUtil() {
    }

    public static String adaptCalciteSyntax(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        String transformed = StringHelper.backtickToDoubleQuote((String)str);
        transformed = ESCAPE_TRANSFORMER.transform(transformed);
        return transformed;
    }

    public static boolean isSelectStatement(String sql) {
        String sql1 = sql.toLowerCase(Locale.ROOT);
        sql1 = QueryUtil.removeCommentInSql(sql1);
        sql1 = sql1.trim();
        while (sql1.startsWith("(")) {
            sql1 = sql1.substring(1).trim();
        }
        return sql1.startsWith(SELECT) || sql1.startsWith("with") && sql1.contains(SELECT) || sql1.startsWith("explain") && sql1.contains(SELECT);
    }

    public static boolean isSelectStarStatement(String sql) {
        return SELECT_STAR_PTN.matcher(sql).find();
    }

    public static String removeCommentInSql(String sql) {
        try {
            return new RawSqlParser(sql).parse().getStatementString();
        }
        catch (Exception ex) {
            log.error("Something unexpected while removing comments in the query, return original query", (Throwable)ex);
            return sql;
        }
    }

    public static String makeErrorMsgUserFriendly(Throwable e) {
        String msg = e.getMessage();
        boolean needBreak = false;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            String className = cause.getClass().getName();
            if (className.contains("ParseException") || className.contains("NoSuchTableException") || className.contains("NoSuchDatabaseException") || cause instanceof AccessDeniedException) {
                msg = cause.getMessage();
                needBreak = true;
            } else if (className.contains("ArithmeticException")) {
                msg = "ArithmeticException: " + cause.getMessage();
                needBreak = true;
            } else if (className.contains("NoStreamingRealizationFoundException")) {
                msg = "NoStreamingRealizationFoundException: " + cause.getMessage();
                needBreak = true;
            }
            if (needBreak) break;
        }
        return QueryUtil.makeErrorMsgUserFriendly(msg);
    }

    public static String makeErrorMsgUserFriendly(String errorMsg) {
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        String[] split = (errorMsg = errorMsg.trim()).split(COLON);
        if (split.length == 3) {
            String prefix = "Error";
            if (StringUtils.startsWithIgnoreCase((CharSequence)split[0], (CharSequence)prefix)) {
                split[0] = split[0].substring(prefix.length()).trim();
            }
            if (StringUtils.startsWith((CharSequence)split[0], (CharSequence)(prefix = "while executing SQL"))) {
                split[0] = split[0].substring(0, prefix.length()) + COLON + split[0].substring(prefix.length());
            }
            return split[1].trim() + COLON + " " + split[2].trim() + "\n" + split[0];
        }
        return errorMsg;
    }

    public static String addLimit(String originString) {
        if (StringUtils.isBlank((CharSequence)originString)) {
            return originString;
        }
        String replacedString = originString.trim();
        Matcher selectMatcher = SELECT_PATTERN.matcher(replacedString);
        if (!selectMatcher.find()) {
            return originString;
        }
        while (replacedString.endsWith(SEMI_COLON)) {
            replacedString = replacedString.substring(0, replacedString.length() - 1).trim();
        }
        Matcher limitMatcher = LIMIT_PATTERN.matcher(replacedString);
        return limitMatcher.find() ? originString : replacedString.concat(" limit 1");
    }

    public static String massageSql(QueryParams queryParams) {
        String massagedSql = QueryUtil.appendLimitOffset(queryParams.getProject(), queryParams.getSql(), queryParams.getLimit(), queryParams.getOffset());
        queryParams.setSql(massagedSql);
        massagedSql = QueryUtil.transformSql(queryParams);
        QueryContext.current().record("end_massage_sql");
        return massagedSql;
    }

    public static String massageSqlAndExpandCC(QueryParams queryParams) {
        String massaged = QueryUtil.massageSql(queryParams);
        return new RestoreFromComputedColumn().convert(massaged, queryParams.getProject(), queryParams.getDefaultSchema());
    }

    private static String transformSql(QueryParams queryParams) {
        String sql = queryParams.getSql();
        String[] classes = queryParams.getKylinConfig().getQueryTransformers();
        List<IQueryTransformer> transformers = QueryUtil.fetchTransformers(queryParams.isCCNeeded(), classes);
        if (log.isDebugEnabled()) {
            log.debug("All used query transformers are: {}", (Object)transformers.stream().map(clz -> clz.getClass().getCanonicalName()).collect(Collectors.joining(",")));
        }
        for (IQueryTransformer t : transformers) {
            QueryInterruptChecker.checkThreadInterrupted((String)("Interrupted sql transformation at the stage of " + t.getClass()), (String)"Current step: SQL transformation.");
            sql = t.transform(sql, queryParams.getProject(), queryParams.getDefaultSchema());
        }
        return sql;
    }

    public static String trimRightSemiColon(String sql) {
        while (sql.endsWith(SEMI_COLON)) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }

    public static String appendLimitOffset(String project, String sql, int limit, int offset) {
        sql = sql.replace("\r", " ").replace("\n", System.lineSeparator());
        sql = QueryUtil.trimRightSemiColon(sql);
        ArrayList sqlElements = Lists.newArrayList((Object[])sql.toLowerCase(Locale.ROOT).split("(?![._'\"`])\\p{P}|\\s+"));
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        Integer maxRows = projectConfig.getMaxResultRows();
        if (maxRows != null && maxRows > 0 && (maxRows < limit || limit <= 0)) {
            limit = maxRows;
        }
        if (projectConfig.getForceLimit() > 0 && limit <= 0 && !sql.toLowerCase(Locale.ROOT).contains("limit") && QueryUtil.isSelectStarStatement(sql)) {
            limit = projectConfig.getForceLimit();
        }
        if (QueryUtil.isBigQueryPushDownCapable(projectConfig)) {
            long bigQueryThreshold = BigQueryThresholdUpdater.getBigQueryThreshold();
            if (limit <= 0 && bigQueryThreshold > 0L) {
                log.info("Big query route to pushdown, Add limit {} to sql.", (Object)bigQueryThreshold);
                limit = (int)bigQueryThreshold;
            }
        }
        if (limit > 0 && !sqlElements.contains("limit")) {
            sql = sql + "\nLIMIT " + limit;
        }
        if (offset > 0 && !sqlElements.contains("offset")) {
            sql = sql + "\nOFFSET " + offset;
        }
        return sql.trim();
    }

    public static boolean isBigQueryPushDownCapable(KylinConfig kylinConfig) {
        return kylinConfig.isBigQueryPushDown() && JDBC.equals(KapConfig.getInstanceFromEnv().getShareStateSwitchImplement());
    }

    public static List<IQueryTransformer> fetchTransformers(boolean isCCNeeded, String[] configTransformers) {
        ArrayList transformers = Lists.newArrayList();
        for (String clz : configTransformers) {
            IQueryTransformer transformer;
            String name = clz.substring(clz.lastIndexOf(46) + 1);
            if (REMOVED_TRANSFORMERS.contains((Object)name)) continue;
            if (QUERY_TRANSFORMER_MAP.containsKey(clz)) {
                transformer = QUERY_TRANSFORMER_MAP.get(clz);
            } else {
                try {
                    transformer = (IQueryTransformer)ClassUtil.newInstance((String)clz);
                    QUERY_TRANSFORMER_MAP.putIfAbsent(clz, transformer);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to init query transformer", e);
                }
            }
            if (transformer instanceof ConvertToComputedColumn) {
                if (!isCCNeeded) continue;
                transformers.add(transformer);
                continue;
            }
            transformers.add(transformer);
        }
        return transformers;
    }

    public static SqlSelect extractSqlSelect(SqlCall selectOrOrderby) {
        SqlSelect sqlSelect = null;
        if (selectOrOrderby instanceof SqlSelect) {
            sqlSelect = (SqlSelect)selectOrOrderby;
        } else if (selectOrOrderby instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)selectOrOrderby;
            if (sqlOrderBy.query instanceof SqlSelect) {
                sqlSelect = (SqlSelect)sqlOrderBy.query;
            }
        }
        return sqlSelect;
    }

    static {
        String[] classNames;
        log = LoggerFactory.getLogger((String)"query");
        REMOVED_TRANSFORMERS = ImmutableSet.of((Object)"ReplaceStringWithVarchar");
        SELECT_PATTERN = Pattern.compile("^select", 2);
        SELECT_STAR_PTN = Pattern.compile("^select\\s+\\*\\p{all}*", 2);
        LIMIT_PATTERN = Pattern.compile("(limit\\s+\\d+)$", 2);
        QUERY_TRANSFORMER_MAP = Maps.newConcurrentMap();
        ESCAPE_TRANSFORMER = new EscapeTransformer();
        for (String clz : classNames = KylinConfig.getInstanceFromEnv().getQueryTransformers()) {
            try {
                IQueryTransformer transformer = (IQueryTransformer)ClassUtil.newInstance((String)clz);
                QUERY_TRANSFORMER_MAP.put(clz, transformer);
            }
            catch (Exception e) {
                log.error("Failed to init query transformer of the sys-config: {}", (Object)clz);
            }
        }
    }
}

