/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshSegmentHandler
extends AbstractJobHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshSegmentHandler.class);

    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfm = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)jobParam.getProject());
        NDataflow dataflow = dfm.getDataflow(jobParam.getModel());
        if (jobParam.isMultiPartitionJob()) {
            NDataSegment segment = dataflow.getSegment(jobParam.getSegment()).copy();
            segment.getMultiPartitions().forEach(partition -> {
                if (jobParam.getTargetPartitions().contains(partition.getPartitionId())) {
                    partition.setStatus(PartitionStatusEnum.REFRESH);
                }
            });
            NDataflowUpdate dfUpdate = new NDataflowUpdate(dataflow.getId());
            dfUpdate.setToUpdateSegs(new NDataSegment[]{segment});
            dfm.updateDataflow(dfUpdate);
        }
        return JobFactory.createJob("CUBE_JOB_FACTORY", new JobFactory.JobBuildParams(Sets.newHashSet((Object[])new NDataSegment[]{dataflow.getSegment(jobParam.getSegment())}), jobParam.getProcessLayouts(), jobParam.getOwner(), jobParam.getJobTypeEnum(), jobParam.getJobId(), null, jobParam.getIgnoredSnapshotTables(), jobParam.getTargetPartitions(), jobParam.getTargetBuckets(), jobParam.getExtParams()));
    }
}

