/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;

public class DefaultExecutableOnModel
extends DefaultExecutable {
    private ExecutableHandler handler;

    public DefaultExecutableOnModel() {
    }

    public DefaultExecutableOnModel(Object notSetId) {
        super(notSetId);
    }

    private String getTargetModel() {
        return this.getTargetSubject();
    }

    @Override
    public boolean checkSuicide() {
        try {
            return !this.checkAnyTargetSegmentAndPartitionExists() || !this.checkAnyLayoutExists();
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean checkAnyLayoutExists() {
        String layouts = this.getParam("layoutIds");
        if (StringUtils.isEmpty((CharSequence)layouts)) {
            return true;
        }
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(this.getTargetModel());
        Set allLayoutIds = indexPlan.getAllLayouts().stream().map(l -> l.getId() + "").collect(Collectors.toSet());
        return Stream.of(StringHelper.splitAndTrim((String)layouts, (String)",")).anyMatch(allLayoutIds::contains);
    }

    private boolean checkTargetSegmentAndPartitionExists(String segmentId) {
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(this.getTargetModel());
        if (dataflow == null || dataflow.checkBrokenWithRelatedInfo()) {
            return false;
        }
        NDataSegment segment = dataflow.getSegment(segmentId);
        if (segment == null) {
            return false;
        }
        if (dataflow.getModel().isMultiPartitionModel()) {
            Set partitionIds = segment.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet());
            Set<Long> partitionInSegment = this.getPartitionsBySegment().get(segmentId);
            if (partitionInSegment == null) {
                logger.warn("Segment {} doesn't contain any partition in this job", (Object)segmentId);
                return true;
            }
            for (long partition : partitionInSegment) {
                if (partitionIds.contains(partition)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkAnyTargetSegmentAndPartitionExists() {
        List<String> topJobTargetSegments = this.getTargetSegments();
        AbstractExecutable parent = this.getParent();
        if (parent != null) {
            topJobTargetSegments = parent.getTargetSegments();
        }
        Preconditions.checkState((!topJobTargetSegments.isEmpty() ? 1 : 0) != 0);
        return topJobTargetSegments.stream().anyMatch(this::checkTargetSegmentAndPartitionExists);
    }

    public boolean checkCuttingInJobByModel() {
        AbstractExecutable parent = this.getParent();
        if (parent == null) {
            parent = this;
        }
        if (!JobParam.isBuildIndexJob(parent.getJobType())) {
            return false;
        }
        String model = ((DefaultExecutableOnModel)parent).getTargetModel();
        return ExecutableManager.getInstance(this.getConfig(), this.getProject()).countCuttingInJobByModel(model, parent) > 0L;
    }

    @Override
    public void onExecuteDiscardHook(String jobId) {
        if (this.handler != null) {
            this.handler.handleDiscardOrSuicidal();
        }
    }

    @Override
    protected void onExecuteSuicidalHook(String jobId) {
        if (this.handler != null) {
            this.handler.handleDiscardOrSuicidal();
        }
    }

    @Generated
    public ExecutableHandler getHandler() {
        return this.handler;
    }

    @Generated
    public void setHandler(ExecutableHandler handler) {
        this.handler = handler;
    }
}

