/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.JobFinishedNotifier;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.ExecuteRuntimeException;
import org.apache.kylin.job.exception.JobStoppedException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.DagExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecutableThread;
import org.apache.kylin.job.execution.ExecuteResult;

public class DefaultExecutable
extends AbstractExecutable
implements ChainedExecutable,
DagExecutable {
    private final List<AbstractExecutable> subTasks = Lists.newArrayList();

    public DefaultExecutable() {
    }

    public DefaultExecutable(Object notSetId) {
        super(notSetId);
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        return Collections.emptySet();
    }

    @Override
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        List<Executable> executables = this.getTasks().stream().map(Executable.class::cast).collect(Collectors.toList());
        switch (this.getJobSchedulerMode()) {
            case DAG: {
                logger.info("Execute in DAG mode.");
                this.dagSchedule(executables, context);
                break;
            }
            default: {
                logger.info("Execute in CHAIN mode.");
                this.chainedSchedule(executables, context);
            }
        }
        return ExecuteResult.createSucceed();
    }

    @Override
    public void chainedSchedule(List<Executable> executables, JobContext context) throws ExecuteException {
        for (Executable subTask : executables) {
            this.executeStep(subTask, context);
        }
    }

    @Override
    public void dagSchedule(List<Executable> executables, JobContext context) throws ExecuteException {
        List<Executable> dagTopExecutables = executables.stream().filter(executable -> StringUtils.isBlank((CharSequence)executable.getPreviousStep())).collect(Collectors.toList());
        Map<String, Executable> dagExecutablesMap = executables.stream().collect(Collectors.toMap(Executable::getId, executable -> executable));
        this.resetJobErrorMessage();
        this.dagExecute(dagTopExecutables, dagExecutablesMap, context);
        this.waitAllDagExecutablesFinished(executables);
    }

    private void resetJobErrorMessage() {
        this.getManager().updateJobError(this.getId(), null, null, null, null);
    }

    public void dagExecute(List<Executable> dagExecutables, Map<String, Executable> dagExecutablesMap, JobContext context) throws ExecuteException {
        try {
            if (dagExecutables.size() == 1) {
                logger.info("dagExecute execute single : {}", (Object)dagExecutables.get(0).getDisplayName());
                this.executeDagExecutable(dagExecutablesMap, dagExecutables.get(0), context);
                return;
            }
            dagExecutables.forEach(executable -> new ExecutableThread(this, dagExecutablesMap, context, (Executable)executable).start());
        }
        catch (Exception e) {
            throw new ExecuteException((Throwable)e);
        }
    }

    public void executeDagExecutable(Map<String, Executable> dagExecutablesMap, Executable executable, JobContext context) {
        try {
            logger.info("execute dag executable : {}-{} -> {}", new Object[]{Thread.currentThread().getName(), Thread.currentThread().getId(), executable.getDisplayName()});
            this.checkPreviousStep(dagExecutablesMap, executable);
            this.executeStep(executable, context);
            this.executeNextSteps(dagExecutablesMap, executable, context);
        }
        catch (Exception e) {
            throw new ExecuteRuntimeException(e);
        }
    }

    private void executeNextSteps(Map<String, Executable> dagExecutablesMap, Executable executable, JobContext context) throws ExecuteException {
        Set<String> nextSteps = executable.getNextSteps();
        if (CollectionUtils.isNotEmpty(nextSteps)) {
            List<Executable> nextExecutables = nextSteps.stream().map(dagExecutablesMap::get).collect(Collectors.toList());
            this.dagExecute(nextExecutables, dagExecutablesMap, context);
        }
    }

    public void waitAllDagExecutablesFinished(List<Executable> dagExecutables) {
        block2: while (true) {
            try {
                while (true) {
                    long runningCount;
                    if ((runningCount = dagExecutables.stream().filter(executable -> executable.getStatus() == ExecutableState.RUNNING || executable.getStatus() == ExecutableState.PENDING || executable.getStatus() == ExecutableState.READY).count()) == 0L) {
                        logger.debug("{} all next step finished", (Object)dagExecutables.get(0).getPreviousStep());
                        break block2;
                    }
                    HashSet finishedState = Sets.newHashSet((Object[])new ExecutableState[]{ExecutableState.ERROR, ExecutableState.PAUSED, ExecutableState.DISCARDED});
                    long peerStepErrorCount = dagExecutables.stream().filter(step -> finishedState.contains((Object)step.getStatus())).count();
                    if (peerStepErrorCount != 0L) {
                        logger.debug("{} next step has error", (Object)dagExecutables.get(0).getPreviousStep());
                        break block2;
                    }
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                logger.error("wait all next step success has error : {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void executeStep(Executable executable, JobContext context) throws ExecuteException {
        if (executable.isRunnable()) {
            executable.execute(context);
        } else if (executable.getStatus().isNotBad()) {
            logger.info("step {} is already succeed, skip it.", (Object)executable.getDisplayName());
        } else {
            throw new IllegalStateException("invalid subtask state, sub task:" + executable.getDisplayName() + ", state:" + (Object)((Object)executable.getStatus()));
        }
    }

    private void checkPreviousStep(Map<String, Executable> dagExecutablesMap, Executable executable) {
        String previousStep;
        Executable previousExecutable;
        if (StringUtils.isNotBlank((CharSequence)executable.getPreviousStep()) && ExecutableState.SUCCEED != (previousExecutable = dagExecutablesMap.get(previousStep = executable.getPreviousStep())).getStatus()) {
            throw new IllegalStateException("invalid subtask state, sub task:" + previousExecutable.getDisplayName() + ", state:" + (Object)((Object)previousExecutable.getStatus()));
        }
    }

    @Override
    protected boolean needCheckState() {
        return false;
    }

    @Override
    protected void onExecuteStart() throws JobStoppedException {
        if (this.isStoppedNonVoluntarily() && ExecutableState.PENDING != this.getOutput().getState()) {
            return;
        }
        this.updateJobOutput(this.project, this.getId(), ExecutableState.RUNNING, null, null, null);
    }

    @Override
    protected void onExecuteFinished(ExecuteResult result) throws JobStoppedException {
        ExecutableState state = this.checkState();
        logger.info("Job finished {}, state:{}", (Object)this.getDisplayName(), (Object)state);
        switch (state) {
            case SUCCEED: {
                this.updateToFinalState(ExecutableState.SUCCEED, this::afterUpdateOutput, result.getShortErrMsg());
                this.onStatusChange(MailNotificationType.JOB_FINISHED);
                break;
            }
            case DISCARDED: {
                this.updateToFinalState(ExecutableState.DISCARDED, this::onExecuteDiscardHook, result.getShortErrMsg());
                break;
            }
            case SUICIDAL: {
                this.updateToFinalState(ExecutableState.SUICIDAL, this::onExecuteSuicidalHook, result.getShortErrMsg());
                this.onStatusChange(MailNotificationType.JOB_ERROR);
                break;
            }
            case ERROR: 
            case PAUSED: 
            case READY: {
                if (this.isStoppedNonVoluntarily()) {
                    logger.info("Execute finished  {} which is stopped nonvoluntarily, state: {}", (Object)this.getDisplayName(), (Object)this.getOutput().getState());
                    break;
                }
                Consumer<String> hook = null;
                Map<String, String> info = null;
                String output = null;
                String shortErrMsg = null;
                if (state == ExecutableState.ERROR) {
                    logger.warn("[UNEXPECTED_THINGS_HAPPENED] Unexpected ERROR state discovered here!!! {}", (Object)result.getErrorMsg());
                    info = result.getExtraInfo();
                    output = result.getErrorMsg();
                    hook = this::onExecuteErrorHook;
                    shortErrMsg = result.getShortErrMsg();
                }
                this.updateJobOutput(this.getProject(), this.getId(), state, info, output, shortErrMsg, hook);
                if (state != ExecutableState.ERROR) break;
                this.onStatusChange(MailNotificationType.JOB_ERROR);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state when job finished: " + (Object)((Object)state));
            }
        }
        EventBusFactory.getInstance().postSync((Object)new JobFinishedNotifier(this.getId(), this.getProject(), this.getTargetSubject(), this.getDuration(), state.toString(), this.getJobType().toString(), this.getSegmentIds(), this.getLayoutIds(), this.getTargetPartitions(), this.getWaitTime(), this.getClass().getName(), this.getSubmitter(), result.succeed(), this.getJobStartTime(), this.getJobEndTime(), this.getTag(), result.getThrowable()));
    }

    private ExecutableState checkState() {
        List<AbstractExecutable> jobs = this.getTasks();
        boolean allSucceed = true;
        boolean hasError = false;
        boolean hasDiscarded = false;
        boolean hasSuicidal = false;
        boolean hasPaused = false;
        for (Executable executable : jobs) {
            logger.info("Sub-task finished {}, state: {}", (Object)executable.getDisplayName(), (Object)executable.getStatus());
            boolean taskSucceed = false;
            switch (executable.getStatus()) {
                case ERROR: 
                case RUNNING: {
                    hasError = true;
                    break;
                }
                case DISCARDED: {
                    hasDiscarded = true;
                    break;
                }
                case SUICIDAL: {
                    hasSuicidal = true;
                    break;
                }
                case PAUSED: {
                    hasPaused = true;
                    break;
                }
                case SUCCEED: 
                case SKIP: 
                case WARNING: {
                    taskSucceed = true;
                    break;
                }
            }
            allSucceed &= taskSucceed;
        }
        ExecutableState state = allSucceed ? ExecutableState.SUCCEED : (hasDiscarded ? ExecutableState.DISCARDED : (hasSuicidal ? ExecutableState.SUICIDAL : (hasError ? ExecutableState.ERROR : (hasPaused ? ExecutableState.PAUSED : ExecutableState.PENDING))));
        return state;
    }

    private long getJobStartTime() {
        return this.subTasks.stream().map(AbstractExecutable::getStartTime).filter(t -> t != 0L).min(Comparator.comparingLong(t -> t)).orElse(0L);
    }

    private long getJobEndTime() {
        return this.subTasks.stream().map(AbstractExecutable::getEndTime).filter(t -> t != 0L).max(Comparator.comparingLong(t -> t)).orElse(System.currentTimeMillis());
    }

    @Override
    public long getWaitTime(ExecutablePO po) {
        return this.subTasks.stream().map(task -> task.getWaitTime(po)).mapToLong(Long::longValue).sum();
    }

    @Override
    public long getWaitTime() {
        return this.subTasks.stream().map(AbstractExecutable::getWaitTime).mapToLong(Long::longValue).sum();
    }

    @Override
    public long getDuration() {
        return this.subTasks.stream().map(AbstractExecutable::getDuration).mapToLong(Long::longValue).sum();
    }

    Optional<AbstractExecutable> getSubTaskByStepId(int stepId) {
        if (stepId < 0 || stepId >= this.subTasks.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.subTasks.get(stepId));
    }

    protected void onExecuteDiscardHook(String jobId) {
    }

    protected void onExecuteSuicidalHook(String jobId) {
    }

    private void updateToFinalState(ExecutableState finalState, Consumer<String> hook, String failedMsg) {
        if (!this.getOutput().getState().isFinalState()) {
            this.updateJobOutput(this.getProject(), this.getId(), finalState, null, null, failedMsg, hook);
        }
    }

    @Override
    public List<AbstractExecutable> getTasks() {
        return this.subTasks;
    }

    @Override
    protected boolean needRetry() {
        return false;
    }

    @Override
    public void addTask(AbstractExecutable executable) {
        int stepId = this.subTasks.size();
        executable.setId(this.getId() + "_" + String.format(Locale.ROOT, "%02d", stepId));
        executable.setParent(this);
        executable.setStepId(stepId);
        this.subTasks.add(executable);
    }

    @Override
    public <T extends AbstractExecutable> T getTask(Class<T> clz) {
        List<AbstractExecutable> tasks = this.getTasks();
        for (AbstractExecutable task : tasks) {
            if (!task.getClass().equals(clz)) continue;
            return (T)task;
        }
        return null;
    }

    protected void afterUpdateOutput(String jobId) {
    }

    protected boolean onStatusChange(MailNotificationType notificationType) {
        KylinConfig config = this.getConfig();
        if (config.isMailEnabled()) {
            return super.notifyUser(notificationType);
        }
        return false;
    }
}

