/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ExecutableOutputPO
implements Serializable {
    @JsonIgnore
    private InputStream contentStream;
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="log_path")
    private String logPath;
    @JsonProperty(value="status")
    private String status = "READY";
    @JsonProperty(value="info")
    private Map<String, String> info = Maps.newHashMap();
    @JsonProperty(value="last_modified")
    private long lastModified;
    @JsonProperty(value="createTime")
    private long createTime = System.currentTimeMillis();
    @JsonProperty(value="start_time")
    private long startTime;
    @JsonProperty(value="end_time")
    private long endTime;
    @JsonProperty(value="wait_time")
    private long waitTime;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="last_running_start_time")
    private long lastRunningStartTime;
    @JsonProperty(value="is_resumable")
    private boolean resumable = false;
    @JsonProperty(value="byte_size")
    private long byteSize;
    @JsonProperty(value="failed_msg")
    private String failedMsg;
    @JsonProperty(value="failed_step_id")
    private String failedStepId;
    @JsonProperty(value="failed_segment_id")
    private String failedSegmentId;
    @JsonProperty(value="failed_stack")
    private String failedStack;
    @JsonProperty(value="failed_reason")
    private String failedReason;

    public void addStartTime(long time) {
        if (this.startTime == 0L) {
            this.startTime = time;
        }
        this.endTime = 0L;
    }

    public void addEndTime(long time) {
        Preconditions.checkArgument((this.startTime > 0L ? 1 : 0) != 0);
        this.endTime = time;
    }

    public void addDuration(long time) {
        if (time != 0L && time > this.lastRunningStartTime) {
            this.duration = this.duration + time - this.lastRunningStartTime;
        }
    }

    public void addLastRunningStartTime(long time) {
        this.lastRunningStartTime = time;
    }

    public void resetTime() {
        this.createTime = System.currentTimeMillis();
        this.startTime = 0L;
        this.endTime = 0L;
        this.waitTime = 0L;
        this.duration = 0L;
        this.lastRunningStartTime = 0L;
    }

    @Generated
    public void setContentStream(InputStream contentStream) {
        this.contentStream = contentStream;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setInfo(Map<String, String> info) {
        this.info = info;
    }

    @Generated
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setLastRunningStartTime(long lastRunningStartTime) {
        this.lastRunningStartTime = lastRunningStartTime;
    }

    @Generated
    public void setResumable(boolean resumable) {
        this.resumable = resumable;
    }

    @Generated
    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    @Generated
    public void setFailedMsg(String failedMsg) {
        this.failedMsg = failedMsg;
    }

    @Generated
    public void setFailedStepId(String failedStepId) {
        this.failedStepId = failedStepId;
    }

    @Generated
    public void setFailedSegmentId(String failedSegmentId) {
        this.failedSegmentId = failedSegmentId;
    }

    @Generated
    public void setFailedStack(String failedStack) {
        this.failedStack = failedStack;
    }

    @Generated
    public void setFailedReason(String failedReason) {
        this.failedReason = failedReason;
    }

    @Generated
    public InputStream getContentStream() {
        return this.contentStream;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, String> getInfo() {
        return this.info;
    }

    @Generated
    public long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getWaitTime() {
        return this.waitTime;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public long getLastRunningStartTime() {
        return this.lastRunningStartTime;
    }

    @Generated
    public boolean isResumable() {
        return this.resumable;
    }

    @Generated
    public long getByteSize() {
        return this.byteSize;
    }

    @Generated
    public String getFailedMsg() {
        return this.failedMsg;
    }

    @Generated
    public String getFailedStepId() {
        return this.failedStepId;
    }

    @Generated
    public String getFailedSegmentId() {
        return this.failedSegmentId;
    }

    @Generated
    public String getFailedStack() {
        return this.failedStack;
    }

    @Generated
    public String getFailedReason() {
        return this.failedReason;
    }
}

