/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.constant;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.ExecutableState;

public class JobStatusUtil {
    public static List<ExecutableState> mapJobStatusToScheduleState(List<String> jobStatusStrList) {
        if (CollectionUtils.isEmpty(jobStatusStrList)) {
            return Lists.newArrayList();
        }
        ArrayList stateList = Lists.newArrayList();
        jobStatusStrList.forEach(str -> stateList.addAll(JobStatusUtil.mapJobStatusToScheduleState(JobStatusEnum.valueOf(str))));
        return stateList;
    }

    public static List<ExecutableState> mapJobStatusToScheduleState(JobStatusEnum jobStatus) {
        ArrayList scheduleStateList = Lists.newArrayList();
        switch (jobStatus) {
            case SKIP: {
                scheduleStateList.add(ExecutableState.SKIP);
                break;
            }
            case NEW: {
                scheduleStateList.add(ExecutableState.READY);
                break;
            }
            case PENDING: {
                scheduleStateList.add(ExecutableState.READY);
                scheduleStateList.add(ExecutableState.PENDING);
                break;
            }
            case RUNNING: {
                scheduleStateList.add(ExecutableState.RUNNING);
                break;
            }
            case ERROR: {
                scheduleStateList.add(ExecutableState.ERROR);
                break;
            }
            case FINISHED: {
                scheduleStateList.add(ExecutableState.SUCCEED);
                break;
            }
            case STOPPED: {
                scheduleStateList.add(ExecutableState.PAUSED);
                break;
            }
            case SUICIDAL: {
                scheduleStateList.add(ExecutableState.SUICIDAL);
                break;
            }
            case DISCARDED: {
                scheduleStateList.add(ExecutableState.SUICIDAL);
                scheduleStateList.add(ExecutableState.DISCARDED);
                break;
            }
            default: {
                throw new RuntimeException("Can not map " + jobStatus.name() + " to ExecutableState");
            }
        }
        return scheduleStateList;
    }
}

