/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(ShellExecutable.class);
    private static final String CMD = "cmd";

    public ShellExecutable() {
    }

    public ShellExecutable(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected ExecuteResult doWork(JobContext context) {
        try {
            logger.info("executing:{}", (Object)this.getCmd());
            BufferedLogger patternedLogger = new BufferedLogger(logger);
            CliCommandExecutor.CliCmdExecResult result = context.getKylinConfig().getCliCommandExecutor().execute(this.getCmd(), (org.apache.kylin.common.util.Logger)patternedLogger);
            Preconditions.checkState((result.getCode() == 0 ? 1 : 0) != 0);
            return ExecuteResult.createSucceed(result.getCmd());
        }
        catch (Exception e) {
            return ExecuteResult.createError(e);
        }
    }

    public void setCmd(String cmd) {
        this.setParam(CMD, cmd);
    }

    public String getCmd() {
        return this.getParam(CMD);
    }
}

