/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.IndexBuildJobUtil;
import org.apache.kylin.job.common.LayoutOptimizeJobUtil;
import org.apache.kylin.job.common.MergeJobUtil;
import org.apache.kylin.job.common.PartitionBuildJobUtil;
import org.apache.kylin.job.common.RefreshJobUtil;
import org.apache.kylin.job.common.SegmentBuildJobUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataSegmentManager;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableUtil.class);
    private static final ConcurrentMap<JobTypeEnum, ExecutableUtil> implementations = new ConcurrentHashMap<JobTypeEnum, ExecutableUtil>();

    protected static void registerImplementation(JobTypeEnum type, ExecutableUtil child) {
        implementations.put(type, child);
    }

    private static void registerDefaultImplementations() {
        ExecutableUtil.registerImplementation(JobTypeEnum.INDEX_BUILD, new IndexBuildJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.INDEX_MERGE, new MergeJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.INDEX_REFRESH, new RefreshJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.INC_BUILD, new SegmentBuildJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.SUB_PARTITION_REFRESH, new RefreshJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.SUB_PARTITION_BUILD, new PartitionBuildJobUtil());
        ExecutableUtil.registerImplementation(JobTypeEnum.LAYOUT_DATA_OPTIMIZE, new LayoutOptimizeJobUtil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutableUtil getImplementation(JobTypeEnum type) {
        ExecutableUtil implementation = (ExecutableUtil)implementations.get((Object)type);
        if (implementation != null) return implementation;
        Class<ExecutableUtil> clazz = ExecutableUtil.class;
        synchronized (ExecutableUtil.class) {
            implementation = (ExecutableUtil)implementations.get((Object)type);
            if (implementation != null) return implementation;
            ExecutableUtil.registerDefaultImplementations();
            return (ExecutableUtil)implementations.get((Object)type);
        }
    }

    public static void computeParams(JobParam jobParam) {
        ExecutableUtil paramUtil;
        NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataModelDesc(jobParam.getModel());
        if (model != null && model.isMultiPartitionModel()) {
            jobParam.getCondition().put("MULTI_PARTITION_JOB", true);
        }
        if ((paramUtil = ExecutableUtil.getImplementation(jobParam.getJobTypeEnum())) != null) {
            paramUtil.computeLayout(jobParam);
            if (jobParam.isMultiPartitionJob()) {
                paramUtil.computePartitions(jobParam);
            }
        }
    }

    public static void computeJobBucket(JobParam jobParam) {
        if (!jobParam.isMultiPartitionJob()) {
            return;
        }
        if (CollectionUtils.isEmpty(jobParam.getTargetPartitions())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_EMPTY, new Object[0]);
        }
        HashSet buckets = Sets.newHashSet();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfm = NDataflowManager.getInstance((KylinConfig)config, (String)jobParam.getProject());
        NDataflow df = dfm.getDataflow(jobParam.getModel());
        NDataSegmentManager segmentManager = (NDataSegmentManager)config.getManager(jobParam.getProject(), NDataSegmentManager.class);
        for (String targetSegment : jobParam.getTargetSegments()) {
            NDataSegment segment = df.getSegment(targetSegment);
            AtomicLong bucketStart = new AtomicLong(segment.getMaxBucketId());
            Set<Long> partitions = JobTypeEnum.INDEX_BUILD == jobParam.getJobTypeEnum() ? segment.getAllPartitionIds() : jobParam.getTargetPartitions();
            jobParam.getProcessLayouts().forEach(layout -> partitions.forEach(partition -> buckets.add(new JobBucket(segment.getId(), layout.getId(), bucketStart.incrementAndGet(), partition.longValue()))));
            segmentManager.update(segment.getUuid(), copyForWrite -> copyForWrite.setMaxBucketId(bucketStart.get()));
        }
        jobParam.setTargetBuckets(buckets);
    }

    public void checkLayoutsNotEmpty(JobParam jobParam) {
        String enableAutoIndexPlan = jobParam.getExtParams().get("kylin.planner.autoApproveEnabled");
        if (Boolean.parseBoolean(enableAutoIndexPlan)) {
            return;
        }
        if (CollectionUtils.isEmpty(jobParam.getProcessLayouts())) {
            log.warn("JobParam {} is no longer valid because no layout awaits building", (Object)jobParam);
            throw new KylinException(this.getCheckIndexErrorCode(), new Object[0]);
        }
    }

    protected Set<LayoutEntity> filterTobeDelete(HashSet<LayoutEntity> layouts) {
        return layouts.stream().filter(layout -> !layout.isToBeDeleted()).collect(Collectors.toSet());
    }

    public ErrorCodeProducer getCheckIndexErrorCode() {
        return ErrorCodeServer.JOB_CREATE_CHECK_INDEX_FAIL;
    }

    public void computeLayout(JobParam jobParam) {
    }

    public void computePartitions(JobParam jobParam) {
    }

    public static Map<String, String> removeGultenParams(Map<String, String> params) {
        params.computeIfPresent("spark.plugins", (pluginKey, pluginValue) -> {
            String tempPluginValue = pluginValue;
            String comma = ",";
            if (StringUtils.contains((CharSequence)pluginValue, (CharSequence)"org.apache.gluten.GlutenPlugin")) {
                tempPluginValue = Arrays.stream(tempPluginValue.split(comma)).filter(p -> !StringUtils.equals((CharSequence)p, (CharSequence)"org.apache.gluten.GlutenPlugin")).collect(Collectors.joining(comma));
            }
            return tempPluginValue;
        });
        params.computeIfPresent("spark.shuffle.manager", (pluginKey, pluginValue) -> {
            String tempPluginValue = pluginValue;
            if (StringUtils.equals((CharSequence)pluginValue, (CharSequence)"org.apache.spark.shuffle.sort.ColumnarShuffleManager")) {
                tempPluginValue = "sort";
            }
            return tempPluginValue;
        });
        return params.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("spark.gluten.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

