/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!\u0002\n\u0014\u0003\u0003\u0001\u0003\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u001a\t\u0011a\u0002!\u0011!Q\u0001\nQB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tE\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015y\u0006A\"\u0001a\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u0002<\u0001!\t\"!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA-\u0001\u0011\u0005\u00111\f\u0002\u000f)\u0006Dw.\u001a$jY\u0016Le\u000eZ3y\u0015\t!R#A\u0003gS2,7O\u0003\u0002\u0017/\u0005)A-\u001a7uC*\u0011\u0001$G\u0001\u0004gFd'B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M!\u0001!I\u00140!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002-/\u0005IQ\r_3dkRLwN\\\u0005\u0003]%\u0012\u0011BR5mK&sG-\u001a=\u0011\u0005A\nT\"A\u000b\n\u0005I*\"AE*oCB\u001c\bn\u001c;EKN\u001c'/\u001b9u_J,\u0012\u0001\u000e\t\u0003kYj\u0011aF\u0005\u0003o]\u0011Ab\u00159be.\u001cVm]:j_:\faa\u001d9be.\u0004\u0013\u0001\u00033fYR\fGj\\4\u0016\u0003m\u0002\"\u0001\r\u001f\n\u0005u*\"\u0001\u0003#fYR\fGj\\4\u0002\u0013\u0011,G\u000e^1M_\u001e\u0004\u0013\u0001\u00029bi\",\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b!AZ:\u000b\u0005\u0019[\u0012A\u00025bI>|\u0007/\u0003\u0002I\u0007\n!\u0001+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0019a\u0014N\\5u}Q!AJT(Q!\ti\u0005!D\u0001\u0014\u0011\u0015Qr\u00011\u00015\u0011\u0015It\u00011\u0001<\u0011\u0015yt\u00011\u0001B\u0003%\u0011xn\u001c;QCRD7/F\u0001T!\r!F,\u0011\b\u0003+js!AV-\u000e\u0003]S!\u0001W\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013BA.$\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00180\u0003\u0007M+\u0017O\u0003\u0002\\G\u0005iQ.\u0019;dQ&twMR5mKN$2!\u00195t!\r!FL\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KV\tq!Y2uS>t7/\u0003\u0002hI\n9\u0011\t\u001a3GS2,\u0007\"B5\n\u0001\u0004Q\u0017\u0001\u00059beRLG/[8o\r&dG/\u001a:t!\r!Fl\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001oF\u0001\tG\u0006$\u0018\r\\=ti&\u0011!/\u001c\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"\u0002;\n\u0001\u0004Q\u0017a\u00033bi\u00064\u0015\u000e\u001c;feN\f\u0011\u0002\\5ti\u001aKG.Z:\u0015\u0007]\\H\u0010E\u0002U9b\u0004\"\u0001K=\n\u0005iL#A\u0005)beRLG/[8o\t&\u0014Xm\u0019;pefDQ!\u001b\u0006A\u0002)DQ\u0001\u001e\u0006A\u0002)\fA\u0002\\5ti\u0006#GMR5mKN$Ra`A\f\u00033\u0001r!!\u0001\u0002\n\u0005=\u0011M\u0004\u0003\u0002\u0004\u0005\u0015\u0001C\u0001,$\u0013\r\t9aI\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004(bAA\u0004GAA\u0011\u0011AA\u0005\u0003#\t\t\u0002\u0005\u0003\u0002\u0002\u0005M\u0011\u0002BA\u000b\u0003\u001b\u0011aa\u0015;sS:<\u0007\"B5\f\u0001\u0004Q\u0007\"\u0002;\f\u0001\u0004Q\u0017\u0001G7bW\u0016\u0004\u0016M\u001d;ji&|g\u000eR5sK\u000e$xN]5fgR\u0019q/a\b\t\u000f\u0005\u0005B\u00021\u0001\u0002$\u00051\u0002/\u0019:uSRLwN\u001c,bYV,7\u000fV8GS2,7\u000f\u0005\u0003U9\u0006\u0015\u0002C\u0002\u0012\u0002(\u0005=\u0011-C\u0002\u0002*\r\u0012a\u0001V;qY\u0016\u0014\u0014a\u00049beRLG/[8o'\u000eDW-\\1\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ur#A\u0003usB,7/\u0003\u0003\u0002:\u0005M\"AC*ueV\u001cG\u000fV=qK\u0006a\u0011MY:pYV$X\rU1uQR\u0019\u0011)a\u0010\t\u000f\u0005\u0005c\u00021\u0001\u0002\u0012\u0005)1\r[5mI\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0012\u0005iAO];oG\u0006$XMU5hQR$b!!\u0005\u0002L\u0005=\u0003bBA'!\u0001\u0007\u0011\u0011C\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0003#\u0002\u0002\u0019AA*\u0003\raWM\u001c\t\u0004E\u0005U\u0013bAA,G\t\u0019\u0011J\u001c;\u0002\u0017\u001d,GOQ1tKB\u000bG\u000f\u001b\u000b\u0005\u0003;\n\u0019\u0007\u0005\u0003#\u0003?\n\u0015bAA1G\t1q\n\u001d;j_:Da!!\u001a\u0012\u0001\u0004\t\u0015\u0001\u00034jY\u0016\u0004\u0016\r\u001e5")
public abstract class TahoeFileIndex
implements FileIndex,
SnapshotDescriptor {
    private final SparkSession spark;
    private final DeltaLog deltaLog;
    private final Path path;

    @Override
    public StructType schema() {
        return SnapshotDescriptor.schema$(this);
    }

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Path path() {
        return this.path;
    }

    public Seq<Path> rootPaths() {
        Path path = this.path();
        return Nil$.MODULE$.$colon$colon((Object)path);
    }

    public abstract Seq<AddFile> matchingFiles(Seq<Expression> var1, Seq<Expression> var2);

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Map<Map<String, String>, Seq<AddFile>> partitionValuesToFiles = this.listAddFiles(partitionFilters, dataFilters);
        return this.makePartitionDirectories((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionValuesToFiles.toSeq());
    }

    private Map<Map<String, String>, Seq<AddFile>> listAddFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.matchingFiles(partitionFilters, dataFilters).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.partitionValues());
    }

    private Seq<PartitionDirectory> makePartitionDirectories(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionValuesToFiles) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        return (Seq)partitionValuesToFiles.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partitionValues = (Map)tuple2._1();
            Seq files = (Seq)tuple2._2();
            Object[] rowValues = (Object[])((TraversableOnce)this.partitionSchema().map((Function1 & Serializable & scala.Serializable)p -> {
                String colName = DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)p);
                Literal partValue = Literal$.MODULE$.apply(partitionValues.get((Object)colName).orNull(Predef$.MODULE$.$conforms()));
                Cast qual$1 = new Cast((Expression)partValue, p.dataType(), Option$.MODULE$.apply((Object)timeZone), false);
                InternalRow x$1 = qual$1.eval$default$1();
                return qual$1.eval(x$1);
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            FileStatus[] fileStatuses = (FileStatus[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> new FileStatus(f.size(), false, 0, 1L, f.modificationTime(), this.absolutePath(f.path())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            PartitionDirectory partitionDirectory = new PartitionDirectory((InternalRow)new GenericInternalRow(rowValues), (Seq)Predef$.MODULE$.wrapRefArray((Object[])fileStatuses));
            return partitionDirectory;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public StructType partitionSchema() {
        return this.metadata().partitionSchema();
    }

    public Path absolutePath(String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(this.path(), p);
    }

    public String toString() {
        String truncatedPath = this.truncateRight(this.path().toString(), 100);
        return new StringBuilder(17).append("Delta[version=").append(this.version()).append(", ").append(truncatedPath).append("]").toString();
    }

    private String truncateRight(String input, int len) {
        return input.length() > len ? new StringBuilder(4).append("... ").append(new StringOps(Predef$.MODULE$.augmentString(input)).takeRight(len)).toString() : input;
    }

    public Option<Path> getBasePath(Path filePath) {
        return new Some((Object)this.path());
    }

    public TahoeFileIndex(SparkSession spark, DeltaLog deltaLog, Path path) {
        this.spark = spark;
        this.deltaLog = deltaLog;
        this.path = path;
        FileIndex.$init$((FileIndex)this);
        SnapshotDescriptor.$init$(this);
    }
}

