/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.spark.ErrorInfo;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.SortedMap;

public final class DeltaThrowableHelper$ {
    public static DeltaThrowableHelper$ MODULE$;
    private JsonMapper mapper;
    private URL sparkErrorClassSource;
    private SortedMap<String, ErrorInfo> sparkErrorClassesMap;
    private SortedMap<String, ErrorInfo> deltaErrorClassToInfoMap;
    private SortedMap<String, ErrorInfo> errorClassToInfoMap;
    private volatile byte bitmap$0;

    static {
        new DeltaThrowableHelper$();
    }

    private JsonMapper mapper$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mapper;
    }

    private JsonMapper mapper() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mapper$lzycompute() : this.mapper;
    }

    private URL safeGetErrorClassesSource(String sourceFile) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
        return (URL)Option$.MODULE$.apply((Object)classLoader.getResource(sourceFile)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(79).append("Cannot find the error class definition file on path ").append(sourceFile).append("\" through the ").append("class loader ").append(classLoader.toString()).toString());
        });
    }

    private URL sparkErrorClassSource$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkErrorClassSource = this.safeGetErrorClassesSource("error/error-classes.json");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkErrorClassSource;
    }

    public URL sparkErrorClassSource() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkErrorClassSource$lzycompute() : this.sparkErrorClassSource;
    }

    public URL deltaErrorClassSource() {
        return this.safeGetErrorClassesSource("error/delta-error-classes.json");
    }

    private SortedMap<String, ErrorInfo> sparkErrorClassesMap$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sparkErrorClassesMap = (SortedMap)this.mapper().readValue(this.sparkErrorClassSource(), (TypeReference)new TypeReference<SortedMap<String, ErrorInfo>>(){});
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sparkErrorClassesMap;
    }

    public SortedMap<String, ErrorInfo> sparkErrorClassesMap() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.sparkErrorClassesMap$lzycompute() : this.sparkErrorClassesMap;
    }

    private SortedMap<String, ErrorInfo> deltaErrorClassToInfoMap$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.deltaErrorClassToInfoMap = (SortedMap)this.mapper().readValue(this.deltaErrorClassSource(), (TypeReference)new TypeReference<SortedMap<String, ErrorInfo>>(){});
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.deltaErrorClassToInfoMap;
    }

    public SortedMap<String, ErrorInfo> deltaErrorClassToInfoMap() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.deltaErrorClassToInfoMap$lzycompute() : this.deltaErrorClassToInfoMap;
    }

    private SortedMap<String, ErrorInfo> errorClassToInfoMap$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.errorClassToInfoMap = this.deltaErrorClassToInfoMap().$plus$plus(this.sparkErrorClassesMap());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.errorClassToInfoMap;
    }

    private SortedMap<String, ErrorInfo> errorClassToInfoMap() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.errorClassToInfoMap$lzycompute() : this.errorClassToInfoMap;
    }

    public String getMessage(String errorClass, String[] messageParameters) {
        ErrorInfo errorInfo = (ErrorInfo)this.errorClassToInfoMap().getOrElse((Object)errorClass, (Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot find error class '").append(errorClass).append("'").toString());
        });
        return String.format(errorInfo.messageFormat().replaceAll("<[a-zA-Z0-9_-]+>", "%s"), messageParameters);
    }

    public String getSqlState(String errorClass) {
        return (String)Option$.MODULE$.apply((Object)errorClass).flatMap((Function1 & java.io.Serializable & Serializable)key -> MODULE$.errorClassToInfoMap().get(key)).flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.sqlState()).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean isInternalError(String errorClass) {
        String string = errorClass;
        String string2 = "INTERNAL_ERROR";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private DeltaThrowableHelper$() {
        MODULE$ = this;
    }
}

