/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;

public class CLIHiveClient
implements IHiveClient {
    protected HiveConf hiveConf = new HiveConf(CLIHiveClient.class);
    protected Driver driver = null;
    protected HiveMetaStoreClient metaStoreClient = null;

    @Override
    public void executeHQL(String hql) throws CommandNeedRetryException, IOException {
        CommandProcessorResponse response = this.getDriver().run(hql);
        int retCode = response.getResponseCode();
        if (retCode != 0) {
            String err = response.getErrorMessage();
            throw new IOException("Failed to execute hql [" + hql + "], error message is: " + err);
        }
    }

    @Override
    public void executeHQL(String[] hqls) throws CommandNeedRetryException, IOException {
        for (String sql : hqls) {
            this.executeHQL(sql);
        }
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws Exception {
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        List allFields = this.getMetaStoreClient().getFields(database, tableName);
        List partitionFields = table.getPartitionKeys();
        if (allFields == null) {
            allFields = Lists.newArrayList();
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            allFields.addAll(partitionFields);
        }
        ArrayList allColumns = Lists.newArrayList();
        ArrayList partitionColumns = Lists.newArrayList();
        for (FieldSchema fieldSchema : allFields) {
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            for (FieldSchema fieldSchema : partitionFields) {
                partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
            }
        }
        builder.setAllColumns(allColumns);
        builder.setPartitionColumns(partitionColumns);
        builder.setSdLocation(table.getSd().getLocation());
        builder.setFileSize(this.getBasicStatForTable(new Table(table), "totalSize"));
        builder.setFileNum(this.getBasicStatForTable(new Table(table), "numFiles"));
        builder.setIsNative(!MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)table));
        builder.setTableName(tableName);
        builder.setSdInputFormat(table.getSd().getInputFormat());
        builder.setSdOutputFormat(table.getSd().getOutputFormat());
        builder.setOwner(table.getOwner());
        builder.setLastAccessTime(table.getLastAccessTime());
        builder.setTableType(table.getTableType());
        builder.setSkipHeaderLineCount((String)table.getParameters().get("skip.header.line.count"));
        return builder.createHiveTableMeta();
    }

    @Override
    public List<String> getHiveDbNames() throws Exception {
        return this.getMetaStoreClient().getAllDatabases();
    }

    @Override
    public List<String> getHiveTableNames(String database) throws Exception {
        return this.getMetaStoreClient().getAllTables(database);
    }

    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        return this.getBasicStatForTable(new Table(table), "numRows");
    }

    private HiveMetaStoreClient getMetaStoreClient() throws Exception {
        if (this.metaStoreClient == null) {
            this.metaStoreClient = new HiveMetaStoreClient(this.hiveConf);
        }
        return this.metaStoreClient;
    }

    private long getBasicStatForTable(Table table, String statType) {
        Map params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong((String)params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }

    private Driver getDriver() {
        if (this.driver == null) {
            this.driver = new Driver(this.hiveConf);
            SessionState.start((SessionState)new CliSessionState(this.hiveConf));
        }
        return this.driver;
    }
}

