/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit.rule;

import lombok.Generated;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class TransactionExceptedException
implements TestRule {
    private ExpectedException exception = ExpectedException.none();

    public static TransactionExceptedException none() {
        return new TransactionExceptedException();
    }

    private TransactionExceptedException() {
    }

    public void expectInTransaction(Class<? extends Throwable> type) {
        this.expect((Matcher<?>)new ClassTransactionMatcher(type));
    }

    public void expectMessageInTransaction(String message) {
        this.expect((Matcher<?>)new MessageTransactionMatcher(message));
    }

    @Deprecated
    @Generated
    public ExpectedException handleAssertionErrors() {
        return this.exception.handleAssertionErrors();
    }

    @Deprecated
    @Generated
    public ExpectedException handleAssumptionViolatedExceptions() {
        return this.exception.handleAssumptionViolatedExceptions();
    }

    @Generated
    public ExpectedException reportMissingExceptionWithMessage(String message) {
        return this.exception.reportMissingExceptionWithMessage(message);
    }

    @Generated
    public Statement apply(Statement base, org.junit.runner.Description description) {
        return this.exception.apply(base, description);
    }

    @Generated
    public void expect(Matcher<?> matcher) {
        this.exception.expect(matcher);
    }

    @Generated
    public void expect(Class<? extends Throwable> type) {
        this.exception.expect(type);
    }

    @Generated
    public void expectMessage(String substring) {
        this.exception.expectMessage(substring);
    }

    @Generated
    public void expectMessage(Matcher<String> matcher) {
        this.exception.expectMessage(matcher);
    }

    @Generated
    public void expectCause(Matcher<?> expectedCause) {
        this.exception.expectCause(expectedCause);
    }

    @Generated
    public boolean isAnyExceptionExpected() {
        return this.exception.isAnyExceptionExpected();
    }

    private static class MessageTransactionMatcher
    extends BaseMatcher {
        private String message;

        public MessageTransactionMatcher(String message) {
            this.message = message;
        }

        public boolean matches(Object item) {
            if (!(item instanceof TransactionException)) {
                return false;
            }
            Throwable ex = (Throwable)item;
            while ((ex = ex.getCause()) != null) {
                if (ex.getMessage() == null || !ex.getMessage().contains(this.message)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
        }
    }

    private static class ClassTransactionMatcher
    extends BaseMatcher {
        private Class<?> aClass;

        public ClassTransactionMatcher(Class<?> aClass) {
            this.aClass = aClass;
        }

        public boolean matches(Object item) {
            if (!(item instanceof TransactionException)) {
                return false;
            }
            Throwable ex = (Throwable)item;
            while ((ex = ex.getCause()) != null) {
                if (!this.aClass.isAssignableFrom(ex.getClass())) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
        }
    }
}

