/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.ClassUtil;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.test.util.ReflectionTestUtils;

public class ClassUtilTest {
    @Test
    public void testFindContainingJar() throws ClassNotFoundException {
        Assert.assertTrue((boolean)ClassUtil.findContainingJar(Class.forName("org.apache.commons.logging.LogFactory")).contains("commons-logging"));
        Assert.assertTrue((boolean)ClassUtil.findContainingJar(Class.forName("org.apache.commons.logging.LogFactory"), (String)"slf4j").contains("jcl-over-slf4j"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    void testAddToClasspath() throws Exception {
        File extraJarsDir = null;
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            extraJarsDir = new File(tmpDir, "class_util_test_jars");
            extraJarsDir.mkdir();
            List<File> jarFiles = Arrays.asList(new File(extraJarsDir, "hive-common-3.3.1.jar"), new File(extraJarsDir, "aws-java-sdk-core-1.11.901.jar"), new File(extraJarsDir, "hadoop-aws-3.3.1.jar"), new File(extraJarsDir, "hadoop-aws-3.3.1"), new File(extraJarsDir, "no-match-file.jar"));
            for (File f : jarFiles) {
                f.createNewFile();
            }
            File singleJarFile = new File(extraJarsDir, "a-single-file.jar");
            singleJarFile.createNewFile();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassUtil.addToClasspath((String)String.format("%s/*hive*", extraJarsDir.getCanonicalPath()), (ClassLoader)loader);
            ClassUtil.addToClasspath((String)String.format("%s/*aws*", extraJarsDir.getCanonicalPath()), (ClassLoader)loader);
            try {
                ClassUtil.addToClasspath((String)String.format("%s/*hive", extraJarsDir.getCanonicalPath()), (ClassLoader)loader);
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
            try {
                ClassUtil.addToClasspath((String)String.format("%s/hive*", extraJarsDir.getCanonicalPath()), (ClassLoader)loader);
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
            ClassUtil.addToClasspath((String)singleJarFile.getCanonicalPath(), (ClassLoader)loader);
            URL[] urls = (URL[])ReflectionTestUtils.invokeMethod((Object)loader, (String)"getURLs", (Object[])new Object[0]);
            List urlList = Stream.of(urls).filter(url -> {
                for (File f : jarFiles) {
                    if (!url.getPath().contains(f.getName()) && !url.getPath().contains(singleJarFile.getName())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            Assertions.assertEquals((int)4, (int)urlList.size());
            if (extraJarsDir == null) return;
        }
        catch (Throwable throwable) {
            if (extraJarsDir == null) throw throwable;
            FileUtils.forceDeleteOnExit(extraJarsDir);
            throw throwable;
        }
        FileUtils.forceDeleteOnExit((File)extraJarsDir);
    }
}

