/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcUtilTest {
    private Connection connection;

    @Before
    public void setup() throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
    }

    @Test
    public void testIsColumnExists() throws SQLException {
        String table = JdbcUtilTest.class.getSimpleName();
        this.connection.createStatement().execute("create table " + table + "(col1 int, col2 varchar)");
        Assert.assertTrue((boolean)JdbcUtil.isColumnExists((Connection)this.connection, (String)table, (String)"col1"));
        this.connection = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertTrue((boolean)JdbcUtil.isColumnExists((Connection)this.connection, (String)table, (String)"cOL1"));
        this.connection = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertFalse((boolean)JdbcUtil.isColumnExists((Connection)this.connection, (String)table, (String)"not_exists"));
    }

    @Test
    public void testIsIndexExists() throws SQLException {
        String table = "INDEXTEST";
        String index = "IX_1";
        this.connection.createStatement().execute("create table " + table + "(col1 int, col2 varchar)");
        this.connection.createStatement().execute("create index " + index + " on " + table + "(col1)");
        Connection connectionAutoRelease = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertTrue((boolean)JdbcUtil.isIndexExists((Connection)connectionAutoRelease, (String)table, (String)index));
        Assert.assertTrue((boolean)connectionAutoRelease.isClosed());
        Connection connectionManuallyRelease = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertTrue((boolean)JdbcUtil.isIndexExists((Connection)connectionManuallyRelease, (String)table, (String)index, (boolean)false));
        Assert.assertFalse((boolean)connectionManuallyRelease.isClosed());
        Connection connectionAutoRelease1 = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertTrue((boolean)JdbcUtil.isTableExists((Connection)connectionAutoRelease1, (String)table));
        Assert.assertTrue((boolean)connectionAutoRelease1.isClosed());
        Connection connectionManuallyRelease1 = DriverManager.getConnection("jdbc:h2:mem:jdbc_util_test;DB_CLOSE_DELAY=-1;MODE=MySQL", "sa", null);
        Assert.assertTrue((boolean)JdbcUtil.isTableExists((Connection)connectionManuallyRelease1, (String)table, (boolean)false));
        Assert.assertFalse((boolean)connectionManuallyRelease1.isClosed());
    }

    @Test
    public void testRetry() throws Exception {
        HashSet set = new HashSet();
        int result = (Integer)JdbcUtil.retry(() -> {
            boolean shouldThrowException = set.isEmpty();
            set.add(true);
            if (shouldThrowException) {
                throw new Exception("test");
            }
            return 1;
        });
        Assert.assertEquals((long)1L, (long)result);
    }
}

