/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.JdbcInfo;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcAuditLogStoreTool {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String LOCAL_INSTANCE = "127.0.0.1";

    public static AuditLog createProjectAuditLog(String projectName, long mvcc, String uuid, String unitId, boolean diffFlag) {
        return JdbcAuditLogStoreTool.createProjectAuditLog(projectName, mvcc, uuid, unitId, null, diffFlag);
    }

    public static AuditLog createProjectAuditLog(String projectName, long mvcc, String uuid, String unitId, String modelUuid, boolean diffFlag) {
        AuditLog resource = new AuditLog();
        resource.setResPath("PROJECT/" + projectName);
        resource.setDiffFlag(diffFlag);
        resource.setProject(uuid);
        resource.setInstance(LOCAL_INSTANCE);
        resource.setUnitId(unitId);
        resource.setModelUuid(modelUuid);
        resource.setByteSource(ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET)));
        resource.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        resource.setMvcc(Long.valueOf(mvcc));
        return resource;
    }

    public static AuditLog createProjectAuditLog(String projectName, long mvcc) {
        return JdbcAuditLogStoreTool.createProjectAuditLog(projectName, mvcc, UUID.randomUUID().toString(), UUID.randomUUID().toString(), null, false);
    }

    public static AuditLog createProjectAuditLog(String projectName, String modelUuid, long mvcc) {
        return JdbcAuditLogStoreTool.createProjectAuditLog(projectName, mvcc, UUID.randomUUID().toString(), UUID.randomUUID().toString(), modelUuid, false);
    }

    public static AuditLog createProjectAuditLog(String projectName, long mvcc, String uuid, String unitId, AuditLog before) {
        AuditLog resource = new AuditLog();
        resource.setResPath("PROJECT/" + projectName);
        resource.setDiffFlag(true);
        resource.setUnitId(unitId);
        resource.setProject(uuid);
        resource.setByteSource(ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET)));
        resource.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        resource.setMvcc(Long.valueOf(mvcc));
        resource.setInstance(LOCAL_INSTANCE);
        ResourceCreateOrUpdateEvent event = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)before);
        ResourceCreateOrUpdateEvent resEvent = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)resource);
        RawResource createdOrUpdated = resEvent.getCreatedOrUpdated();
        createdOrUpdated.fillContentDiffFromRaw(event.getCreatedOrUpdated());
        resource.setByteSource(ByteSource.wrap((byte[])createdOrUpdated.getContentDiff()));
        return resource;
    }

    public static List<Event> createEvents() {
        ResourceCreateOrUpdateEvent event1 = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc", 0L));
        ResourceCreateOrUpdateEvent event2 = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc2", 0L));
        ResourceCreateOrUpdateEvent event3 = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc", 1L));
        ResourceCreateOrUpdateEvent event4 = (ResourceCreateOrUpdateEvent)Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc3", 0L));
        ResourceDeleteEvent event5 = new ResourceDeleteEvent("PROJECT/abc3");
        event5.setKey("abc3");
        return Lists.newArrayList((Object[])new Event[]{event1, event2, event3, event4, event5});
    }

    public static void prepareJdbcAuditLogStore(String projectPrefixName, JdbcTemplate jdbcTemplate, long logNum) {
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        String table = url.getIdentifier() + "_audit_log_v2";
        int i = 0;
        while ((long)i < logNum) {
            String projectName = (projectPrefixName != null ? projectPrefixName : "p") + i;
            String unitId = RandomUtil.randomUUIDStr();
            jdbcTemplate.update(String.format(Locale.ROOT, JdbcAuditLogStore.INSERT_SQL, table), new Object[]{"PROJECT/" + projectName, ("{ \"uuid\" : \"" + RandomUtil.randomUUIDStr() + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET), System.currentTimeMillis(), 0, unitId, null, null, AddressUtil.getLocalInstance(), projectName, false});
            ++i;
        }
    }

    public static void mockAuditLogForProjectEntry(String uuid, String project, JdbcInfo info, boolean isDel, long mvcc, String unitId) {
        Object[] objectArray;
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        if (isDel) {
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = "PROJECT/" + project;
            objectArray2[1] = null;
            objectArray2[2] = System.currentTimeMillis();
            objectArray2[3] = mvcc;
            objectArray2[4] = unitId;
            objectArray2[5] = null;
            objectArray2[6] = null;
            objectArray2[7] = LOCAL_INSTANCE;
            objectArray2[8] = null;
            objectArray = objectArray2;
            objectArray2[9] = false;
        } else {
            Object[] objectArray3 = new Object[10];
            objectArray3[0] = "PROJECT/" + project;
            objectArray3[1] = ("{\"name\" : \"" + project + "\",\"uuid\" : \"" + uuid + "\"}").getBytes(DEFAULT_CHARSET);
            objectArray3[2] = System.currentTimeMillis();
            objectArray3[3] = mvcc;
            objectArray3[4] = unitId;
            objectArray3[5] = null;
            objectArray3[6] = null;
            objectArray3[7] = LOCAL_INSTANCE;
            objectArray3[8] = null;
            objectArray = objectArray3;
            objectArray3[9] = false;
        }
        Object[] log = objectArray;
        ArrayList<Object[]> logs = new ArrayList<Object[]>();
        logs.add(log);
        jdbcTemplate.batchUpdate(String.format(Locale.ROOT, JdbcAuditLogStore.INSERT_SQL, url.getIdentifier() + "_audit_log_v2"), logs);
    }

    public static void mockAuditLogForProjectEntry(String project, JdbcInfo info, boolean isDel) {
        String unitId = RandomUtil.randomUUIDStr();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), project, info, isDel, 0L, unitId);
    }
}

