/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.IOException;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceStoreTestBase;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
@OverwriteProp(key="kylin.env", value="UT")
class InMemResourceStoreTest {
    InMemResourceStoreTest() {
    }

    @Test
    public void testFileStore() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStoreTestBase.wrapInNewUrl(config.getMetadataUrl().toString(), config, ResourceStoreTestBase::testAStore);
    }

    @Test
    public void testMemoryLeak() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStoreTestBase.testPotentialMemoryLeak(config.getMetadataUrl().toString(), config);
    }

    @Test
    public void testUUID() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStoreTestBase.wrapInNewUrl(config.getMetadataUrl().toString(), config, ResourceStoreTestBase::testGetUUID);
    }

    @Disabled(value="wait for metaStore to be refactored.")
    @Test
    void testReload() throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore systemResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        JsonSerializer serializer = new JsonSerializer(ResourceStoreTestBase.TestEntity.class);
        systemResourceStore.checkAndPutResource(MetadataType.mergeKeyWithType((String)"test", (MetadataType)MetadataType.SYSTEM), (RootPersistentEntity)new ResourceStoreTestBase.TestEntity("data2"), (Serializer)serializer);
        KylinConfig newConfig = KylinConfig.createKylinConfig((KylinConfig)config);
        ResourceStore copyResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)newConfig);
        Assert.assertFalse((boolean)this.isSameResourceStore(systemResourceStore, copyResourceStore));
        systemResourceStore.reload();
        Assert.assertTrue((boolean)this.isSameResourceStore(systemResourceStore, copyResourceStore));
    }

    private boolean isSameResourceStore(ResourceStore resourceStore1, ResourceStore resourceStore2) {
        NavigableSet paths1 = resourceStore1.listResourcesRecursively(MetadataType.ALL.name());
        NavigableSet paths2 = resourceStore2.listResourcesRecursively(MetadataType.ALL.name());
        return Objects.equals(paths1, paths2);
    }
}

