/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.tool.garbage.AbstractComparableCleanTask;
import org.apache.kylin.tool.garbage.StorageCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CleanTaskExecutorService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanTaskExecutorService.class);
    private static final CleanTaskExecutorService INSTANCE = new CleanTaskExecutorService();
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 2;
    private final ScheduledExecutorService timeoutCheckerPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("storage-cleaner-timeout-checker"));
    private final AtomicBoolean bound = new AtomicBoolean(false);
    private ExecutorService pool;

    private CleanTaskExecutorService() {
    }

    public static CleanTaskExecutorService getInstance() {
        return INSTANCE;
    }

    public boolean bindWorkingPool(Supplier<ExecutorService> workingPoolProvider) {
        Preconditions.checkArgument((workingPoolProvider != null ? 1 : 0) != 0, (Object)"workingPool is null");
        if (this.bound.compareAndSet(false, true)) {
            this.pool = workingPoolProvider.get();
            return true;
        }
        return false;
    }

    public CompletableFuture<Void> cleanStorageForService(boolean storageCleanup, List<String> projects, double requestFSRate, int retryTimes) {
        return this.cleanStorageAsync(RandomUtil.randomUUIDStr(), StorageCleaner.CleanerTag.SERVICE, storageCleanup, projects, requestFSRate, retryTimes);
    }

    public void cleanStorageForRoutine(boolean storageCleanup, List<String> projects, double requestFSRate, int retryTimes) {
        this.cleanStorageSync(StorageCleaner.CleanerTag.ROUTINE, storageCleanup, projects, requestFSRate, retryTimes);
    }

    private void cleanStorageSync(StorageCleaner.CleanerTag tag, boolean storageCleanup, List<String> projects, double requestFSRate, int retryTimes) {
        this.cleanStorageAsync(RandomUtil.randomUUIDStr(), tag, storageCleanup, projects, requestFSRate, retryTimes).join();
    }

    private CompletableFuture<Void> cleanStorageAsync(String traceId, StorageCleaner.CleanerTag tag, boolean storageCleanup, List<String> projects, double requestFSRate, int retryTimes) {
        StorageCleaner cleaner = this.makeCleaner(traceId, tag, projects, requestFSRate, retryTimes, storageCleanup);
        if (cleaner != null) {
            return this.cleanStorageAsync(cleaner);
        }
        return CompletableFuture.completedFuture(null);
    }

    private StorageCleaner makeCleaner(String traceId, StorageCleaner.CleanerTag tag, List<String> projects, double requestFSRate, int retryTimes, boolean storageCleanup) {
        Preconditions.checkArgument((projects != null ? 1 : 0) != 0, (Object)"projects is null");
        StorageCleaner storageCleaner = null;
        try {
            storageCleaner = new StorageCleaner(storageCleanup, projects, requestFSRate, retryTimes);
            storageCleaner.withTag(tag);
            storageCleaner.withTraceId(traceId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create storage cleaner for projects: {}. TraceId: {}", new Object[]{projects, traceId, e});
        }
        return storageCleaner;
    }

    private CompletableFuture<Void> cleanStorageAsync(StorageCleaner cleaner) {
        LOGGER.info("To submit cleaning hdfs files task. TraceId: {}.", (Object)cleaner.getTraceId());
        CompletableFuture<Void> f = this.submit(cleaner, KylinConfig.getInstanceFromEnv().getStorageCleanTaskTimeout(), TimeUnit.MILLISECONDS);
        f.whenComplete((v, t) -> {
            if (t == null) {
                LOGGER.info("HDFS files cleaning task has successfully completed. TraceId: {}", (Object)cleaner.getTraceId());
                return;
            }
            LOGGER.error("\u001b[31mcleanup HDFS failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr\u001b[0m. TraceId: " + cleaner.getTraceId(), t);
        });
        return f;
    }

    public CompletableFuture<Void> submit(final StorageCleaner cleaner, long timeout, TimeUnit timeUnit) {
        return this.submit(new AbstractComparableCleanTask(){

            @Override
            public String getName() {
                return cleaner.getTraceId();
            }

            @Override
            protected String details() {
                return String.format(Locale.ROOT, "traceId: %s, tag: %s, projects: %s", new Object[]{cleaner.getTraceId(), cleaner.getTag(), cleaner.getProjectNames().toString()});
            }

            @Override
            public StorageCleaner.CleanerTag getCleanerTag() {
                return cleaner.getTag();
            }

            @Override
            protected void doRun() {
                try {
                    cleaner.execute();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, timeout, timeUnit);
    }

    public CompletableFuture<Void> submit(AbstractComparableCleanTask task, long timeout, TimeUnit timeUnit) {
        if (this.pool == null) {
            throw new RejectedExecutionException("The working pool has not been initialized, please bind it at first!");
        }
        LOGGER.debug("To submit storage cleaning task {}.", (Object)task.getBrief());
        CompletableFuture<Void> resultFuture = task.getWatcher();
        AtomicReference<Object> cancelFuture = new AtomicReference<Object>(null);
        try {
            if (!resultFuture.isDone()) {
                Future<?> workingFuture = this.pool.submit(task);
                LOGGER.info("Submitted storage cleaning task {}.", (Object)task.getBrief());
                cancelFuture.set(this.timeoutCheckerPool.schedule(() -> {
                    if (!workingFuture.isDone() && !workingFuture.cancel(true)) {
                        LOGGER.warn("You may have leaked threads, failed to cancel task {}!", (Object)task.getBrief());
                    }
                    resultFuture.completeExceptionally(new TimeoutException("Timeout for cleaning!"));
                }, timeout, timeUnit));
            }
        }
        catch (RejectedExecutionException re) {
            resultFuture.completeExceptionally(re);
        }
        resultFuture.whenComplete((v, t) -> {
            if (cancelFuture.get() != null) {
                ((Future)cancelFuture.get()).cancel(true);
            }
            if (t != null) {
                throw new CompletionException("To cancel task watcher because of encountering exceptions for task " + task.getBrief(), (Throwable)t);
            }
            LOGGER.info("Cleaning task {} successfully completed!", (Object)task.getBrief());
        });
        return resultFuture;
    }

    @Override
    public void close() throws IOException {
        if (this.pool != null) {
            try {
                this.pool.shutdown();
                if (!this.pool.awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOGGER.warn("The working thread pool couldn't shutdown before timeout {}s!", (Object)2);
                    this.pool.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                LOGGER.info("[{}] Shutdown when JVM is to shutdown.", (Object)CleanTaskExecutorService.class.getName());
                INSTANCE.close();
                LOGGER.info("[{}] Shutdown successfully.", (Object)CleanTaskExecutorService.class.getName());
            }
            catch (Exception e) {
                LOGGER.error("[{}] Occurring exceptions to shutdown!", (Object)CleanTaskExecutorService.class.getName());
            }
        }));
    }
}

