/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.LayoutEntityConverter;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxesRunTime;

public final class LayoutEntityConverter$ {
    public static LayoutEntityConverter$ MODULE$;

    static {
        new LayoutEntityConverter$();
    }

    public LayoutEntityConverter.LayoutEntityConverter LayoutEntityConverter(LayoutEntity layoutEntity) {
        return new LayoutEntityConverter.LayoutEntityConverter(layoutEntity);
    }

    public StructType genCuboidSchemaFromNCuboidLayoutWithPartitionColumn(LayoutEntity cuboid, Seq<String> partitionColumn) {
        ImmutableBiMap dimensions = cuboid.getOrderedDimensions();
        return StructType$.MODULE$.apply((Seq)((TraversableLike)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)dimensions).asScala()).filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)LayoutEntityConverter$.$anonfun$genCuboidSchemaFromNCuboidLayoutWithPartitionColumn$1(partitionColumn, tp)))).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.genSparkStructField(((Integer)i._1()).toString(), (TblColRef)i._2()), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$plus((GenTraversableOnce)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)cuboid.getOrderedMeasures()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new StructField(((Integer)i._1()).toString(), MODULE$.generateFunctionReturnDataType(((MeasureDesc)i._2()).getFunction()), true, StructField$.MODULE$.apply$default$4()), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)partitionColumn.map((Function1 & Serializable & scala.Serializable)pt -> new Tuple2(pt, dimensions.get((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(pt)).toInt()))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.genSparkStructField((String)i._1(), (TblColRef)i._2()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()));
    }

    public StructField genSparkStructField(String name, TblColRef tbl) {
        StructField structField;
        String dataTpName = tbl.getType().getName();
        if (dataTpName.startsWith("varchar") || dataTpName.startsWith("char")) {
            Metadata meta = new MetadataBuilder().putString("__CHAR_VARCHAR_TYPE_STRING", tbl.getType().toString()).build();
            structField = new StructField(name, SparderTypeUtil$.MODULE$.toSparkType(tbl.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), true, meta);
        } else {
            structField = new StructField(name, SparderTypeUtil$.MODULE$.toSparkType(tbl.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), true, StructField$.MODULE$.apply$default$4());
        }
        return structField;
    }

    public StructType genCuboidSchemaFromNCuboidLayout(LayoutEntity cuboid, boolean isFastBitmapEnabled) {
        Seq seq;
        if (isFastBitmapEnabled) {
            Buffer countDistinctColumns = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(cuboid.listBitmapMeasure()).asScala();
            seq = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)cuboid.getOrderedMeasures()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> countDistinctColumns.contains((Object)((Integer)i._1()).toString()) ? new StructField(((Integer)i._1()).toString(), (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()) : new StructField(((Integer)i._1()).toString(), MODULE$.generateFunctionReturnDataType(((MeasureDesc)i._2()).getFunction()), true, StructField$.MODULE$.apply$default$4()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        } else {
            seq = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)cuboid.getOrderedMeasures()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new StructField(((Integer)i._1()).toString(), MODULE$.generateFunctionReturnDataType(((MeasureDesc)i._2()).getFunction()), true, StructField$.MODULE$.apply$default$4()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        Seq measures = seq;
        return StructType$.MODULE$.apply((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)cuboid.getOrderedDimensions()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.genSparkStructField(((Integer)i._1()).toString(), (TblColRef)i._2()), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$plus((GenTraversableOnce)measures, Seq$.MODULE$.canBuildFrom()));
    }

    public boolean genCuboidSchemaFromNCuboidLayout$default$2() {
        return false;
    }

    public Option<BucketSpec> genBucketSpec(LayoutEntity layoutEntity, Set<String> partitionColumn) {
        return layoutEntity.getShardByColumns().isEmpty() ? Option$.MODULE$.apply((Object)new BucketSpec(layoutEntity.getBucketNum(), (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(layoutEntity.getShardByColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Buffer$.MODULE$.canBuildFrom()), (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)layoutEntity.getColOrder()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LayoutEntityConverter$.$anonfun$genBucketSpec$3(partitionColumn, x$7))))) : Option$.MODULE$.apply(null);
    }

    public DataType generateFunctionReturnDataType(FunctionDesc function) {
        Object object;
        String string = function.getExpression().toUpperCase(Locale.ROOT);
        if ("SUM".equals(string)) {
            ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
            object = parameter.isColumnType() ? SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), true) : SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), true);
        } else if ("COUNT".equals(string)) {
            object = LongType$.MODULE$;
        } else if (string.startsWith("TOP_N")) {
            Buffer fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(function.getParameters()).asScala()).drop(1)).map((Function1 & Serializable & scala.Serializable)p -> new StructField(new StringBuilder(10).append("DIMENSION_").append(p.getColRef().getName()).toString(), SparderTypeUtil$.MODULE$.toSparkType(p.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom());
            object = DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("measure", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dim", (DataType)StructType$.MODULE$.apply((Seq)fields), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        } else {
            boolean bl = "MAX".equals(string) ? true : "MIN".equals(string);
            if (bl) {
                ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
                object = parameter.isColumnType() ? SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()) : SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparderTypeUtil$.MODULE$.toSparkType$default$2());
            } else if ("COLLECT_SET".equals(string)) {
                ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
                object = ArrayType$.MODULE$.apply(SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()));
            } else {
                object = "SUM_LC".equals(string) ? BinaryType$.MODULE$ : SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparderTypeUtil$.MODULE$.toSparkType$default$2());
            }
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$genCuboidSchemaFromNCuboidLayoutWithPartitionColumn$1(Seq partitionColumn$2, Tuple2 tp) {
        return !partitionColumn$2.contains((Object)((Integer)tp._1()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$genBucketSpec$3(Set partitionColumn$3, String x$7) {
        return !partitionColumn$3.contains((Object)x$7);
    }

    private LayoutEntityConverter$() {
        MODULE$ = this;
    }
}

