/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.kylin.shaded.influxdb.okhttp3.OkHttpClient;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDB;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDBFactory;

public class InfluxDBUtils {
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";

    private InfluxDBUtils() {
    }

    public static InfluxDB getInfluxDBInstance(String addr, String username, String password, boolean enableSsl, boolean enableUnsafeSsl) throws Exception {
        String protocol = enableSsl ? HTTPS : HTTP;
        String url = protocol + addr;
        if (enableSsl && enableUnsafeSsl) {
            return InfluxDBFactory.connect((String)url, (String)username, (String)password, (OkHttpClient.Builder)InfluxDBUtils.getBuilderWithAllTrustManager());
        }
        return InfluxDBFactory.connect((String)url, (String)username, (String)password);
    }

    private static OkHttpClient.Builder getBuilderWithAllTrustManager() throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        X509TrustManager x509TrustManager = TrustManagerUtils.getAcceptAllTrustManager();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
        builder.hostnameVerifier((hostname, session) -> true);
        return builder;
    }
}

