/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.utils.ThreadUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0003\u0006\u0001/!)Q\u0005\u0001C\u0001M!A1\u0002\u0001EC\u0002\u0013%\u0011\u0006C\u00045\u0001\t\u0007I\u0011B\u001b\t\rq\u0002\u0001\u0015!\u00037\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0001w\u00059\u0019E.^:uKJluN\\5u_JT!a\u0003\u0007\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003#I\tQa[=mS:T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"aH\u0012\u000e\u0003\u0001R!!\t\u0012\u0002\u0011%tG/\u001a:oC2T!!\u0004\n\n\u0005\u0011\u0002#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003))\u0012A\u000b\t\u0003WIj\u0011\u0001\f\u0006\u0003[9\n!bY8oGV\u0014(/\u001a8u\u0015\ty\u0003'\u0001\u0003vi&d'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g1\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003=QuJQ0T)\u0016\u0003v\f\u0015*F\r&CV#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u0002\u0014\u0001\u00027b]\u001eL!a\u000f\u001d\u0003\rM#(/\u001b8h\u0003AQuJQ0T)\u0016\u0003v\f\u0015*F\r&C\u0006%A\ntG\",G-\u001e7f\u0003R4\u0015\u000e_3e%\u0006$X\rF\u0002@\u0005\u001e\u0003\"!\u0007!\n\u0005\u0005S\"\u0001B+oSRDQaQ\u0003A\u0002\u0011\u000bAAZ;oGB\u0019\u0011$R \n\u0005\u0019S\"!\u0003$v]\u000e$\u0018n\u001c81\u0011\u0015AU\u00011\u0001J\u0003\u0019\u0001XM]5pIB\u0011\u0011DS\u0005\u0003\u0017j\u0011A\u0001T8oO\u0006\u0011Rn\u001c8ji>\u00148\u000b]1sW6\u000b7\u000f^3s)\u0015yd\nX3k\u0011\u0015ye\u00011\u0001Q\u00039\tGo\\7jG\n+\u0018\u000e\u001c3F]Z\u00042!\u0015+W\u001b\u0005\u0011&BA*-\u0003\u0019\tGo\\7jG&\u0011QK\u0015\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0011qKW\u0007\u00021*\u0011\u0011\fD\u0001\u0004U>\u0014\u0017BA.Y\u00055Y\u0015\u0010\\5o\u0005VLG\u000eZ#om\")QL\u0002a\u0001=\u0006\u0011\u0012\r^8nS\u000e\u001c\u0006/\u0019:l'\u0016\u001c8/[8o!\r\tFk\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\n\n1a]9m\u0013\t!\u0017M\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003g\r\u0001\u0007q-A\beSN\u001cwN\u001c8fGR$\u0016.\\3t!\t\t\u0006.\u0003\u0002j%\nQ\u0011\t^8nS\u000eduN\\4\t\u000b-4\u0001\u0019\u00017\u00029\u0005$x.\\5d+:\u0014X-Y2iC\ndWm\u00159be.l\u0015m\u001d;feB\u0011\u0011+\\\u0005\u0003]J\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB7p]&$xN\u001d\u000b\u0006\u007fE\u00148\u000f\u001e\u0005\u0006\u001f\u001e\u0001\r\u0001\u0015\u0005\u0006;\u001e\u0001\rA\u0018\u0005\u0006M\u001e\u0001\ra\u001a\u0005\u0006W\u001e\u0001\r\u0001\\\u0001\tg\",H\u000fZ8x]R\tq\b")
public class ClusterMonitor
implements Logging {
    private ScheduledExecutorService scheduler;
    private final String JOB_STEP_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ScheduledExecutorService scheduler$lzycompute() {
        ClusterMonitor clusterMonitor = this;
        synchronized (clusterMonitor) {
            if (!this.bitmap$0) {
                this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("connect-master-guard");
                this.bitmap$0 = true;
            }
        }
        return this.scheduler;
    }

    private ScheduledExecutorService scheduler() {
        return !this.bitmap$0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    private String JOB_STEP_PREFIX() {
        return this.JOB_STEP_PREFIX;
    }

    public void scheduleAtFixedRate(Function0<BoxedUnit> func, long period) {
        this.scheduler().scheduleAtFixedRate(new Runnable(null, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        }, period, period, TimeUnit.SECONDS);
    }

    public void monitorSparkMaster(AtomicReference<KylinBuildEnv> atomicBuildEnv, AtomicReference<SparkSession> atomicSparkSession, AtomicLong disconnectTimes, AtomicBoolean atomicUnreachableSparkMaster) {
        block0: {
            long disconnectMaxTimes;
            KylinConfig config = atomicBuildEnv.get().kylinConfig();
            if (!KapConfig.wrap((KylinConfig)config).isCloud() || config.isUTEnv() || (disconnectMaxTimes = config.getClusterManagerHealthCheckMaxTimes()) < 0L) break block0;
            long connectPeriod = config.getClusterManagerHealCheckIntervalSecond();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("ClusterMonitor thread start with max times is ").append(disconnectMaxTimes).append(" period is ").append(connectPeriod).toString());
            this.scheduleAtFixedRate((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.monitor(atomicBuildEnv, atomicSparkSession, disconnectTimes, atomicUnreachableSparkMaster), connectPeriod);
        }
    }

    public void monitor(AtomicReference<KylinBuildEnv> atomicBuildEnv, AtomicReference<SparkSession> atomicSparkSession, AtomicLong disconnectTimes, AtomicBoolean atomicUnreachableSparkMaster) {
        block2: {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "monitor start");
            KylinConfig config = atomicBuildEnv.get().kylinConfig();
            long disconnectMaxTimes = config.getClusterManagerHealthCheckMaxTimes();
            try {
                IClusterManager clusterManager = atomicBuildEnv.get().clusterManager();
                clusterManager.applicationExisted(new StringBuilder(0).append(this.JOB_STEP_PREFIX()).append(atomicBuildEnv.get().buildJobInfos().getJobStepId()).toString());
                disconnectTimes.set(0L);
                atomicUnreachableSparkMaster.set(false);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "monitor stop");
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("monitor error with : ").append(e.getMessage()).toString());
                if (disconnectTimes.incrementAndGet() < disconnectMaxTimes || atomicSparkSession.get() == null) break block2;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Job will stop: Unable connect spark master to reach timeout maximum time");
                atomicUnreachableSparkMaster.set(true);
                atomicSparkSession.get().stop();
            }
        }
    }

    public void shutdown() {
        this.scheduler().shutdownNow();
    }

    public ClusterMonitor() {
        Logging.$init$((Logging)this);
        this.JOB_STEP_PREFIX = "job_step_";
    }
}

