/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeJob;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.engine.spark.job.SanityChecker$;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.datasource.storage.StorageListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4A\u0001D\u0007\u00015!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003<\u0001\u0011\u0005C\bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003e\u0001\u0011%QmB\u0003l\u001b!\u0005ANB\u0003\r\u001b!\u0005Q\u000eC\u00037\u000f\u0011\u0005a\u000eC\u0004p\u000f\t\u0007I\u0011\u00019\t\rE<\u0001\u0015!\u00034\u0011\u0015\u0011x\u0001\"\u0001t\u00055\u0019\u0016M\\5us\u000eCWmY6fe*\u0011abD\u0001\u0004U>\u0014'B\u0001\t\u0012\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00112#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003)U\tQa[=mS:T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001cC1\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012+\u001b\u0005\u0019#B\u0001\u0013&\u0003\u001d\u0019Ho\u001c:bO\u0016T!AJ\u0014\u0002\u0015\u0011\fG/Y:pkJ\u001cWM\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005A)\u0012BA\u0016$\u0005=\u0019Fo\u001c:bO\u0016d\u0015n\u001d;f]\u0016\u0014\bCA\u00171\u001b\u0005q#BA\u0018\u0010\u0003\u0015)H/\u001b7t\u0013\t\tdFA\u0003M_\u001e,\u00050\u0001\u0004fqB,7\r\u001e\t\u00039QJ!!N\u000f\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005aR\u0004CA\u001d\u0001\u001b\u0005i\u0001\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014AG8o!\u0016\u00148/[:u\u0005\u00164wN]3SKB\f'\u000f^5uS>tGcA\u001fA)B\u0011ADP\u0005\u0003\u007fu\u0011A!\u00168ji\")\u0011i\u0001a\u0001\u0005\u0006IA-\u0019;b\rJ\fW.\u001a\t\u0003\u0007Fs!\u0001R(\u000f\u0005\u0015seB\u0001$N\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002K3\u00051AH]8pizJ\u0011\u0001G\u0005\u0003-]I!\u0001E\u000b\n\u0005!J\u0013B\u0001)(\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001)(\u0011\u0015)6\u00011\u0001W\u0003\u0019a\u0017-_8viB\u0011qKX\u0007\u00021*\u0011\u0011LW\u0001\u0006[>$W\r\u001c\u0006\u00037r\u000bAaY;cK*\u0011QlE\u0001\t[\u0016$\u0018\rZ1uC&\u0011q\f\u0017\u0002\r\u0019\u0006Lx.\u001e;F]RLG/_\u0001\u001a_:\u0004VM]:jgR\fe\r^3s%\u0016\u0004\u0018M\u001d;ji&|g\u000eF\u0002>E\u000eDQ!\u0011\u0003A\u0002\tCQ!\u0016\u0003A\u0002Y\u000bQb\u00195fG.\u0014vn^\"pk:$H\u0003B\u001fgQ*DQaZ\u0003A\u0002M\n!\u0002\u001a4S_^\u001cu.\u001e8u\u0011\u0015IW\u00011\u00014\u00039\u0001\u0018M]3oiJ{woQ8v]RDQ!V\u0003A\u0002Y\u000bQbU1oSRL8\t[3dW\u0016\u0014\bCA\u001d\b'\r91\u0004\f\u000b\u0002Y\u0006I1kS%Q?\u001ac\u0015iR\u000b\u0002g\u0005Q1kS%Q?\u001ac\u0015i\u0012\u0011\u0002\u0011\u001d,GoQ8v]R$2a\r;w\u0011\u0015)8\u00021\u0001C\u0003\t!g\rC\u0003V\u0017\u0001\u0007a\u000b")
public class SanityChecker
implements StorageListener,
LogEx {
    private final long expect;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long getCount(Dataset<Row> dataset, LayoutEntity layoutEntity) {
        return SanityChecker$.MODULE$.getCount(dataset, layoutEntity);
    }

    public static long SKIP_FLAG() {
        return SanityChecker$.MODULE$.SKIP_FLAG();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void onPersistBeforeRepartition(Dataset<Row> dataFrame, LayoutEntity layout) {
    }

    public void onPersistAfterRepartition(Dataset<Row> dataFrame, LayoutEntity layout) {
        if (!KylinConfig.getInstanceFromEnv().isSanityCheckEnabled()) {
            return;
        }
        if (this.expect == SanityChecker$.MODULE$.SKIP_FLAG()) {
            this.log().info("Cannot find count constant measure in root, skip sanity check");
            return;
        }
        long actual = SanityChecker$.MODULE$.getCount(dataFrame, layout);
        if (actual == SanityChecker$.MODULE$.SKIP_FLAG()) {
            this.log().info("Cannot find count constant measure in current cuboid, skip sanity check");
            return;
        }
        this.checkRowCount(actual, this.expect, layout);
    }

    private void checkRowCount(long dfRowCount, long parentRowCount, LayoutEntity layout) {
        if (dfRowCount != parentRowCount) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeJob.SANITY_CHECK_ERROR, new Object[]{new StringBuilder(0).append(layout.getId()).toString()});
        }
    }

    public SanityChecker(long expect) {
        this.expect = expect;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
    }
}

