/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.helper.RoutineToolHelper;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.KylinInstance;
import org.apache.kylin.metadata.resourcegroup.RequestTypeEnum;
import org.apache.kylin.metadata.resourcegroup.ResourceGroup;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupMappingInfo;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.FileService;
import org.apache.kylin.rest.service.MetadataBackupService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.RoutineJob;
import org.apache.kylin.tool.garbage.LogCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ScheduleService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduleService.class);
    private static final String GLOBAL = "global";
    private static final String CLEAN_SPARDER_EVENT_LOG = "http://%s/kylin/api/system/clean_sparder_event_log";
    @Autowired
    @Qualifier(value="normalRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    FileService fileService;
    @Autowired
    MetadataBackupService backupService;
    @Autowired
    ProjectService projectService;
    private final ExecutorService executors = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("RoutineTaskScheduler"));
    private final ExecutorService asyncExecutors = new ThreadPoolExecutor(20, 20, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("RoutineBroadcastScheduler"));
    private long opsCronTimeout;
    private String tmpMetadataBackupFilePath;
    private static final ThreadLocal<Future<?>> CURRENT_FUTURE;
    private static final Map<Future<?>, Long> ASYNC_FUTURES;

    @Scheduled(cron="${kylin.metadata.ops-cron:0 0 0 * * *}")
    public void routineTask() {
        this.submitJob();
    }

    private void submitJob() {
        if (!JobContextUtil.getJobContext((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobScheduler().isMaster()) {
            log.info("Not master node, skip submitting routine job");
            return;
        }
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        projects.add("_global");
        for (String project : projects) {
            ExecutableManager manager = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            manager.checkAndSubmitCronJob("ROUTINE_JOB_FACTORY", JobTypeEnum.ROUTINE);
        }
        log.info("Successfully create garbage cleanup jobs.");
    }

    public void doRoutineTaskForGlobal() {
        this.doTask(() -> {
            log.info("Start to work");
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            long startTime = System.currentTimeMillis();
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_OPS_CRON, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
            try (SetThreadName ignored = new SetThreadName("RoutineOpsWorker", new Object[0]);){
                AtomicReference<Object> backupFolder = new AtomicReference<Object>(null);
                this.broadcastCleanSparderEventLogToAllNodes();
                this.executeTask(() -> backupFolder.set(this.backupService.backupAll()), "MetadataBackup", startTime);
                this.executeMetadataBackupInTenantMode(kylinConfig, startTime, backupFolder);
                this.executeTask(() -> RoutineToolHelper.cleanQueryHistoriesAsync((long)this.getRemainingTime(startTime), (TimeUnit)TimeUnit.MILLISECONDS), "QueryHistoriesCleanup", startTime);
                this.executeTask(RoutineToolHelper::cleanStreamingStats, "StreamingStatsCleanup", startTime);
                this.executeTask(RoutineToolHelper::deleteRawRecItems, "RawRecItemsDeletion", startTime);
                this.executeTask(RoutineToolHelper::cleanGlobalSourceUsage, "SourceUsageCleanup", startTime);
                this.executeTask(() -> this.projectService.cleanupAcl(), "AclCleanup", startTime);
                this.executeTask(() -> this.projectService.cleanRawRecForDeletedProject(), "RawRecCleanup", startTime);
                this.executeTask(RoutineToolHelper::cleanStorageForRoutine, "HdfsCleanup", startTime);
                this.executeTask(() -> new LogCleaner().cleanUp(), "RemoteLogCleanup", startTime);
                log.info("Finish to work for global, cost {}ms", (Object)(System.currentTimeMillis() - startTime));
            }
            return true;
        });
    }

    public void doRoutineTaskForProject(String project) {
        this.doTask(() -> {
            log.info("Start to work");
            long startTime = System.currentTimeMillis();
            MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_OPS_CRON, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
            try (SetThreadName ignored = new SetThreadName("RoutineOpsWorker", new Object[0]);){
                this.executeTask(() -> this.projectService.garbageCleanup(project, this.getRemainingTime(startTime)), "ProjectGarbageCleanup", startTime);
                this.executeTask(() -> RoutineToolHelper.cleanEventLog((RoutineToolHelper.CleanType)RoutineToolHelper.CleanType.SPARK, (String)project), "EventLogCleanup", startTime);
                log.info("Finish to work for project {}, cost {}ms", (Object)project, (Object)(System.currentTimeMillis() - startTime));
            }
            return true;
        });
    }

    private void doTask(Callable<Boolean> callable) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.opsCronTimeout = kylinConfig.getRoutineOpsTaskTimeOut();
        CURRENT_FUTURE.remove();
        ASYNC_FUTURES.clear();
        try {
            callable.call();
        }
        catch (InterruptedException e) {
            log.warn("Routine task execution interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            log.warn("Routine task execution timeout", (Throwable)e);
            if (CURRENT_FUTURE.get() != null) {
                CURRENT_FUTURE.get().cancel(true);
            }
            ASYNC_FUTURES.keySet().forEach(asyncTask -> asyncTask.cancel(true));
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Unexpected exception.", (Throwable)e);
        }
        finally {
            ASYNC_FUTURES.clear();
        }
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_OPS_CRON_SUCCESS, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMetadataBackupInTenantMode(KylinConfig kylinConfig, long startTime, AtomicReference<Pair<String, String>> backupFolder) throws InterruptedException, TimeoutException {
        ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)kylinConfig);
        if (kylinConfig.isKylinMultiTenantEnabled() && rgManager.isResourceGroupEnabled()) {
            Map<String, List<KylinInstance>> servers = this.getResourceGroupServerNode(rgManager);
            log.info("ResourceGroupServerNode : {}", servers);
            if (servers.size() > 0) {
                try {
                    this.tmpMetadataBackupFilePath = "";
                    this.executeBroadcastMetadataBackup(() -> this.broadcastToServer(servers, backupFolder, startTime), "broadcastMetadataBackup", startTime);
                }
                finally {
                    if (StringUtils.isNotBlank((CharSequence)this.tmpMetadataBackupFilePath)) {
                        this.fileService.deleteTmpDir(this.tmpMetadataBackupFilePath);
                    }
                }
                log.info("backup file path [{}] broadcast to server success", backupFolder.get().getFirst());
            }
        }
    }

    public Map<String, List<KylinInstance>> getResourceGroupServerNode(ResourceGroupManager rgManager) {
        HashMap servers = Maps.newHashMap();
        ResourceGroup allResourceGroups = rgManager.getResourceGroup();
        String concurrentServer = AddressUtil.getLocalInstance();
        String concurrentServerResourceGroupId = allResourceGroups.getKylinInstances().stream().filter(instance -> instance.getInstance().equals(concurrentServer)).map(KylinInstance::getResourceGroupId).findFirst().orElse(null);
        List buildResourceGroups = allResourceGroups.getResourceGroupMappingInfoList().stream().filter(resourceGroupMappingInfo -> resourceGroupMappingInfo.getRequestType() == RequestTypeEnum.BUILD).map(ResourceGroupMappingInfo::getResourceGroupId).filter(groupId -> !StringUtils.equals((CharSequence)groupId, (CharSequence)concurrentServerResourceGroupId)).collect(Collectors.toList());
        allResourceGroups.getKylinInstances().stream().filter(kylinInstance -> buildResourceGroups.contains(kylinInstance.getResourceGroupId())).forEach(instance -> {
            List instances = servers.getOrDefault(instance.getResourceGroupId(), Lists.newArrayList());
            instances.add(instance);
            servers.put(instance.getResourceGroupId(), instances);
        });
        return servers;
    }

    public void broadcastToServer(Map<String, List<KylinInstance>> servers, AtomicReference<Pair<String, String>> backupFolder, long startTime) {
        String backupFilePath = (String)backupFolder.get().getFirst() + "/" + "metadata.zip";
        String backupDir = (String)backupFolder.get().getSecond();
        try {
            Pair tmpFileMessage = this.fileService.saveMetadataBackupInTmpPath(backupFilePath);
            this.tmpMetadataBackupFilePath = (String)tmpFileMessage.getFirst();
            Long tmpFileLength = (Long)tmpFileMessage.getSecond();
            for (Map.Entry<String, List<KylinInstance>> entry : servers.entrySet()) {
                List<KylinInstance> kylinInstances = entry.getValue();
                if (!CollectionUtils.isNotEmpty(kylinInstances)) continue;
                KylinInstance server = kylinInstances.get(RandomUtil.nextInt((int)kylinInstances.size()));
                log.info("routineTask[broadcastMetadataBackup] execute to groupId [{}] server [{}]", (Object)entry.getKey(), (Object)server.getInstance());
                this.executeAsyncTask(() -> this.broadcastToTenantNode((String)entry.getKey(), backupDir, this.tmpMetadataBackupFilePath, tmpFileLength, server.getInstance()), "broadcastToTenantNode-GroupIs[" + entry.getKey() + "]", startTime);
            }
        }
        catch (IOException e) {
            log.error("backup file path [{}] broadcast to server has error. reason:", (Object)backupFilePath, (Object)e);
        }
    }

    private void broadcastCleanSparderEventLogToAllNodes() {
        List allNodes = this.clusterManager.getServers();
        try {
            for (ServerInfoResponse node : allNodes) {
                String url = String.format(Locale.ROOT, CLEAN_SPARDER_EVENT_LOG, node.getHost());
                log.info("Start broadcasting to clean the sparder event log of {}", (Object)url);
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.add("Content-Type", "application/vnd.apache.kylin-v4-public+json");
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)httpHeaders), String.class, new Object[0]);
                this.receive((ResponseEntity<String>)response, "noticeToQueryNode");
            }
        }
        catch (Exception e) {
            log.error("Broadcast cleaning sparder event log failed!", (Throwable)e);
        }
    }

    private void receive(ResponseEntity<String> response, String msg) throws IOException {
        String responseBody;
        RestResponse responseJson;
        int responseStatus = response.getStatusCodeValue();
        if (responseStatus != 200) {
            log.error("{} failed, HttpStatus is {}", (Object)msg, (Object)responseStatus);
        }
        if (!StringUtils.equals((CharSequence)(responseJson = (RestResponse)JsonUtil.readValue((String)(responseBody = (String)Optional.ofNullable(response.getBody()).orElse("")), (TypeReference)new TypeReference<RestResponse<Boolean>>(){})).getCode(), (CharSequence)"000")) {
            log.error("{} failed, response code is {}", (Object)msg, (Object)responseJson.getCode());
        }
    }

    public void broadcastToTenantNode(String resourceGroupId, String backupDir, String tmpFilePath, long tmpFileLength, String host) {
        try {
            String url = String.format(Locale.ROOT, "http://%s/kylin/api/system/broadcast_metadata_backup", host);
            HashMap req = Maps.newHashMap();
            req.put("resource_group_id", resourceGroupId);
            req.put("tmp_file_path", tmpFilePath);
            req.put("tmp_file_size", tmpFileLength);
            req.put("backup_dir", backupDir);
            req.put("from_host", AddressUtil.getLocalInstance());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", "application/vnd.apache.kylin-v4-public+json");
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)JsonUtil.writeValueAsBytes((Object)req), (MultiValueMap)httpHeaders), String.class, new Object[0]);
            this.receive((ResponseEntity<String>)exchange, "noticeToTenantNode");
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void executeTask(Runnable task, String taskName, long startTime) throws InterruptedException, TimeoutException {
        Future<?> future = this.executors.submit(task);
        long remainingTime = this.getRemainingTime(startTime);
        log.info("execute task {} with remaining time: {} ms", (Object)taskName, (Object)remainingTime);
        CURRENT_FUTURE.set(future);
        try {
            future.get(remainingTime, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            log.warn("Routine task {} execution failed, reason:", (Object)taskName, (Object)e);
        }
    }

    public void executeBroadcastMetadataBackup(Runnable task, String taskName, long startTime) throws InterruptedException, TimeoutException {
        this.executeTask(task, taskName, startTime);
        this.cancelTimeoutAsyncTask(startTime);
    }

    public void cancelTimeoutAsyncTask(long startTime) throws InterruptedException {
        while (ASYNC_FUTURES.size() > 0) {
            ASYNC_FUTURES.forEach((asyncTask, start) -> {
                if (this.getRemainingTime((long)start) <= 0L) {
                    asyncTask.cancel(true);
                }
            });
            long doneTaskCount = ASYNC_FUTURES.keySet().stream().filter(Future::isDone).count();
            if (doneTaskCount == (long)ASYNC_FUTURES.size()) {
                log.info("all running asyncTask[broadcastToServer] is done");
                break;
            }
            if (this.getRemainingTime(startTime) <= 0L) {
                log.warn("cancel all running asyncTask, DoneAsyncTask count: [{}], AllAsyncTask count : [{}]", (Object)doneTaskCount, (Object)ASYNC_FUTURES.size());
                ASYNC_FUTURES.keySet().stream().filter(asyncTask -> !asyncTask.isDone()).forEach(asyncTask -> asyncTask.cancel(true));
                break;
            }
            TimeUnit.SECONDS.sleep(10L);
        }
    }

    public void executeAsyncTask(Runnable task, String taskName, long startTime) {
        Future<?> future = this.asyncExecutors.submit(task);
        long remainingTime = this.getRemainingTime(startTime);
        log.info("execute async task {} with remaining time: {} ms", (Object)taskName, (Object)remainingTime);
        ASYNC_FUTURES.put(future, System.currentTimeMillis());
    }

    private long getRemainingTime(long startTime) {
        return this.opsCronTimeout - (System.currentTimeMillis() - startTime);
    }

    public Pair<String, String> triggerAllCleanupGarbage(HttpServletRequest request) {
        String jobMaster = JobContextUtil.getJobContext((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobScheduler().getJobMaster();
        StringBuilder msg = new StringBuilder();
        Pair result = new Pair();
        result.setFirst((Object)"000");
        String url = "http://" + jobMaster + "/kylin/api/system/do_cleanup_garbage";
        try {
            EnvelopeResponse response = this.generateTaskForRemoteHost(request, url);
            if (response.getCode().equals("000")) {
                msg.append(jobMaster).append(":").append("triggered successfully").append(";");
            }
            if (response.getCode().equals("999")) {
                result.setFirst((Object)"999");
                msg.append(jobMaster).append(":").append("triggered failed").append(response.getMsg()).append(";");
            }
        }
        catch (Exception e) {
            msg.append(jobMaster).append(":").append("triggered failed: ").append(e.getMessage()).append(";");
        }
        result.setSecond((Object)msg.toString());
        return result;
    }

    static {
        JobFactory.register((String)"ROUTINE_JOB_FACTORY", (JobFactory)new RoutineJob.RoutineJobFactory());
        CURRENT_FUTURE = new ThreadLocal();
        ASYNC_FUTURES = Maps.newConcurrentMap();
    }
}

