/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.org.influxdb;

import java.util.Objects;
import org.apache.kylin.shaded.influxdb.okhttp3.OkHttpClient;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDB;
import org.apache.kylin.shaded.influxdb.org.influxdb.impl.InfluxDBImpl;
import org.apache.kylin.shaded.influxdb.org.influxdb.impl.Preconditions;

public enum InfluxDBFactory {
    INSTANCE;


    public static InfluxDB connect(String url) {
        Preconditions.checkNonEmptyString(url, "url");
        return new InfluxDBImpl(url, null, null, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, String username, String password) {
        Preconditions.checkNonEmptyString(url, "url");
        Preconditions.checkNonEmptyString(username, "username");
        return new InfluxDBImpl(url, username, password, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, OkHttpClient.Builder client) {
        Preconditions.checkNonEmptyString(url, "url");
        Objects.requireNonNull(client, "client");
        return new InfluxDBImpl(url, null, null, client);
    }

    public static InfluxDB connect(String url, String username, String password, OkHttpClient.Builder client) {
        return InfluxDBFactory.connect(url, username, password, client, InfluxDB.ResponseFormat.JSON);
    }

    public static InfluxDB connect(String url, String username, String password, OkHttpClient.Builder client, InfluxDB.ResponseFormat responseFormat) {
        Preconditions.checkNonEmptyString(url, "url");
        Preconditions.checkNonEmptyString(username, "username");
        Objects.requireNonNull(client, "client");
        return new InfluxDBImpl(url, username, password, client, responseFormat);
    }
}

