/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.impl.AggAddContextImpl;
import org.apache.calcite.adapter.enumerable.impl.AggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class EnumerableAggregateBase
extends Aggregate {
    protected EnumerableAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, hints, input, groupSet, groupSets, aggCalls);
    }

    protected static boolean hasOrderedCall(List<AggImpState> aggs) {
        for (AggImpState agg : aggs) {
            if (agg.call.collation.equals(RelCollations.EMPTY)) continue;
            return true;
        }
        return false;
    }

    protected void declareParentAccumulator(List<Expression> initExpressions, BlockBuilder initBlock, PhysType accPhysType) {
        if (accPhysType.getJavaRowType() instanceof JavaTypeFactoryImpl.SyntheticRecordType) {
            JavaTypeFactoryImpl.SyntheticRecordType synType = (JavaTypeFactoryImpl.SyntheticRecordType)((Object)accPhysType.getJavaRowType());
            ParameterExpression record0_ = Expressions.parameter((Type)accPhysType.getJavaRowType(), (String)"record0");
            initBlock.add((Statement)Expressions.declare((int)0, (ParameterExpression)record0_, null));
            initBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)record0_, (Expression)Expressions.new_((Type)accPhysType.getJavaRowType()))));
            List<Types.RecordField> fieldList = synType.getRecordFields();
            for (int i = 0; i < initExpressions.size(); ++i) {
                Expression right = initExpressions.get(i);
                initBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.field((Expression)record0_, (PseudoField)((PseudoField)fieldList.get(i))), (Expression)right)));
            }
            initBlock.add((Expression)record0_);
        } else {
            initBlock.add(accPhysType.record(initExpressions));
        }
    }

    protected void implementLambdaFactory(BlockBuilder builder, PhysType inputPhysType, List<AggImpState> aggs, Expression accumulatorInitializer, boolean hasOrderedCall, ParameterExpression lambdaFactory) {
        if (hasOrderedCall) {
            ParameterExpression pe = Expressions.parameter(List.class, (String)builder.newName("lazyAccumulators"));
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, (Expression)Expressions.new_(LinkedList.class)));
            for (AggImpState agg : aggs) {
                if (agg.call.collation.equals(RelCollations.EMPTY)) {
                    builder.add(Expressions.statement((Expression)Expressions.call((Expression)pe, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.new_((Constructor)BuiltInMethod.BASIC_LAZY_ACCUMULATOR.constructor, (Expression[])new Expression[]{Objects.requireNonNull(agg.accumulatorAdder, "agg.accumulatorAdder")})})));
                    continue;
                }
                Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(agg.call.collation.getFieldCollations());
                builder.add(Expressions.statement((Expression)Expressions.call((Expression)pe, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.new_((Constructor)BuiltInMethod.SOURCE_SORTER.constructor, (Expression[])new Expression[]{Objects.requireNonNull(agg.accumulatorAdder, "agg.accumulatorAdder"), (Expression)pair.left, (Expression)pair.right})})));
            }
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)lambdaFactory, (Expression)Expressions.new_((Constructor)BuiltInMethod.LAZY_AGGREGATE_LAMBDA_FACTORY.constructor, (Expression[])new Expression[]{accumulatorInitializer, pe})));
        } else {
            ParameterExpression pe = Expressions.parameter(List.class, (String)builder.newName("accumulatorAdders"));
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, (Expression)Expressions.new_(LinkedList.class)));
            for (AggImpState agg : aggs) {
                builder.add(Expressions.statement((Expression)Expressions.call((Expression)pe, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Objects.requireNonNull(agg.accumulatorAdder, "agg.accumulatorAdder")})));
            }
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)lambdaFactory, (Expression)Expressions.new_((Constructor)BuiltInMethod.BASIC_AGGREGATE_LAMBDA_FACTORY.constructor, (Expression[])new Expression[]{accumulatorInitializer, pe})));
        }
    }

    protected void createAccumulatorAdders(final ParameterExpression inParameter, List<AggImpState> aggs, PhysType accPhysType, ParameterExpression accExpr, final PhysType inputPhysType, BlockBuilder builder, final EnumerableRelImplementor implementor, final JavaTypeFactory typeFactory) {
        int stateOffset = 0;
        for (int i = 0; i < aggs.size(); ++i) {
            BlockBuilder builder2 = new BlockBuilder();
            final AggImpState agg = aggs.get(i);
            int stateSize = Objects.requireNonNull(agg.state, "agg.state").size();
            ArrayList<Expression> accumulator = new ArrayList<Expression>(stateSize);
            for (int j = 0; j < stateSize; ++j) {
                accumulator.add(accPhysType.fieldReference((Expression)accExpr, j + stateOffset));
            }
            agg.state = accumulator;
            stateOffset += stateSize;
            AggAddContextImpl addContext = new AggAddContextImpl(builder2, accumulator){

                @Override
                public List<RexNode> rexArguments() {
                    List<RelDataTypeField> inputTypes = inputPhysType.getRowType().getFieldList();
                    ArrayList<RexNode> args = new ArrayList<RexNode>();
                    for (int index : agg.call.getArgList()) {
                        args.add(RexInputRef.of(index, inputTypes));
                    }
                    return args;
                }

                @Override
                public @Nullable RexNode rexFilterArgument() {
                    return agg.call.filterArg < 0 ? null : RexInputRef.of(agg.call.filterArg, inputPhysType.getRowType());
                }

                @Override
                public RexToLixTranslator rowTranslator() {
                    return RexToLixTranslator.forAggregation(typeFactory, this.currentBlock(), new RexToLixTranslator.InputGetterImpl((Expression)inParameter, inputPhysType), implementor.getConformance());
                }
            };
            agg.implementor.implementAdd(Objects.requireNonNull(agg.context, "agg.context"), addContext);
            builder2.add((Expression)accExpr);
            agg.accumulatorAdder = builder.append("accumulatorAdder", (Expression)Expressions.lambda(Function2.class, (BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{accExpr, inParameter}));
        }
    }

    protected List<Type> createAggStateTypes(List<Expression> initExpressions, BlockBuilder initBlock, List<AggImpState> aggs, JavaTypeFactory typeFactory) {
        ArrayList<Type> aggStateTypes = new ArrayList<Type>();
        for (AggImpState agg : aggs) {
            agg.context = new AggContextImpl(agg, typeFactory);
            List<Type> state = agg.implementor.getStateType(agg.context);
            if (state.isEmpty()) {
                agg.state = ImmutableList.of();
                continue;
            }
            aggStateTypes.addAll(state);
            ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
            for (int i = 0; i < state.size(); ++i) {
                String aggName = "a" + agg.aggIdx;
                if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                    aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
                }
                Type type = state.get(i);
                ParameterExpression pe = Expressions.parameter((Type)type, (String)initBlock.newName(aggName + "s" + i));
                initBlock.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, null));
                decls.add((Expression)pe);
            }
            agg.state = decls;
            initExpressions.addAll(decls);
            agg.implementor.implementReset(agg.context, new AggResultContextImpl(initBlock, agg.call, decls, null, null));
        }
        return aggStateTypes;
    }

    protected class AggContextImpl
    implements AggContext {
        private final AggImpState agg;
        private final JavaTypeFactory typeFactory;

        AggContextImpl(AggImpState agg, JavaTypeFactory typeFactory) {
            this.agg = agg;
            this.typeFactory = typeFactory;
        }

        @Override
        public SqlAggFunction aggregation() {
            return this.agg.call.getAggregation();
        }

        @Override
        public RelDataType returnRelType() {
            return this.agg.call.type;
        }

        @Override
        public Type returnType() {
            return EnumUtils.javaClass(this.typeFactory, this.returnRelType());
        }

        @Override
        public List<? extends RelDataType> parameterRelTypes() {
            return EnumUtils.fieldRowTypes(EnumerableAggregateBase.this.getInput().getRowType(), null, this.agg.call.getArgList());
        }

        @Override
        public List<? extends Type> parameterTypes() {
            return EnumUtils.fieldTypes(this.typeFactory, this.parameterRelTypes());
        }

        @Override
        public List<ImmutableBitSet> groupSets() {
            return EnumerableAggregateBase.this.groupSets;
        }

        @Override
        public List<Integer> keyOrdinals() {
            return EnumerableAggregateBase.this.groupSet.asList();
        }

        @Override
        public List<? extends RelDataType> keyRelTypes() {
            return EnumUtils.fieldRowTypes(EnumerableAggregateBase.this.getInput().getRowType(), null, EnumerableAggregateBase.this.groupSet.asList());
        }

        @Override
        public List<? extends Type> keyTypes() {
            return EnumUtils.fieldTypes(this.typeFactory, this.keyRelTypes());
        }
    }
}

