/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.common;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;

public final class GlutenTestConfig$
implements Logging {
    public static GlutenTestConfig$ MODULE$;
    private final String GLUTEN_CH_LIB_PATH_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GlutenTestConfig$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String GLUTEN_CH_LIB_PATH_KEY() {
        return this.GLUTEN_CH_LIB_PATH_KEY;
    }

    public boolean enableGluten() {
        boolean bl;
        String chLibPath = System.getProperty(this.GLUTEN_CH_LIB_PATH_KEY());
        if (StringUtils.isEmpty((CharSequence)chLibPath) || !new File(chLibPath).exists()) {
            this.log().warn("-Dclickhouse.lib.path is not set or path not exists, skip gluten config");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public void configGluten(SparkConf conf) {
        if (!this.enableGluten()) {
            return;
        }
        String chLibPath = System.getProperty(this.GLUTEN_CH_LIB_PATH_KEY());
        conf.set("spark.gluten.enabled", "true");
        conf.set("spark.plugins", "org.apache.gluten.GlutenPlugin");
        conf.set("spark.gluten.sql.columnar.libpath", chLibPath);
        conf.set("spark.gluten.sql.columnar.extended.columnar.pre.rules", "org.apache.spark.sql.execution.gluten.ConvertKylinFileSourceToGlutenRule");
        conf.set("spark.gluten.sql.columnar.extended.expressions.transformer", "org.apache.spark.sql.catalyst.expressions.gluten.CustomerExpressionTransformer");
        conf.set("spark.sql.columnVector.offheap.enabled", "true");
        conf.set("spark.memory.offHeap.enabled", "true");
        conf.set("spark.memory.offHeap.size", "2g");
        conf.set("spark.gluten.sql.enable.native.validation", "false");
        conf.set("spark.shuffle.manager", "org.apache.spark.shuffle.sort.ColumnarShuffleManager");
        conf.set("spark.gluten.sql.columnar.iterator", "true");
        conf.set("spark.gluten.sql.columnar.sort", "true");
        conf.set("spark.sql.exchange.reuse", "true");
        conf.set("spark.gluten.sql.columnar.forceshuffledhashjoin", "true");
        conf.set("spark.locality.wait", "0");
        conf.set("spark.locality.wait.node", "0");
        conf.set("spark.locality.wait.process", "0");
        conf.set("spark.sql.autoBroadcastJoinThreshold", "20MB");
        conf.set("spark.gluten.sql.columnar.columnartorow", "true");
        conf.set("spark.gluten.sql.columnar.loadnative", "true");
        conf.set("spark.gluten.sql.columnar.loadarrow", "false");
        conf.set("spark.gluten.sql.columnar.hashagg.enablefinal", "true");
        conf.set("spark.gluten.sql.columnar.separate.scan.rdd.for.ch", "false");
        conf.set("spark.databricks.delta.maxSnapshotLineageLength", "20");
        conf.set("spark.databricks.delta.snapshotPartitions", "1");
        conf.set("spark.databricks.delta.properties.defaults.checkpointInterval", "5");
        conf.set("spark.databricks.delta.stalenessLimit", "3600000");
        conf.set("spark.gluten.sql.columnar.backend.ch.worker.id", "1");
        conf.set("spark.gluten.sql.columnar.coalesce.batches", "false");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.logger.level", "error");
        conf.set("spark.io.compression.codec", "LZ4");
        conf.set("spark.gluten.sql.columnar.shuffle.customizedCompression.codec", "LZ4");
        conf.set("spark.gluten.sql.columnar.backend.ch.customized.shuffle.codec.enable", "true");
        conf.set("spark.gluten.sql.columnar.backend.ch.customized.buffer.size", "4096");
        conf.set("spark.gluten.sql.columnar.backend.ch.files.per.partition.threshold", "5");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.enable_nullable", "true");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.local_engine.settings.metrics_perf_events_enabled", "false");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.logger.level", "ERROR");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.local_engine.settings.max_bytes_before_external_group_by", "5000000000");
        conf.set("spark.gluten.sql.columnar.maxBatchSize", "32768");
        conf.set("spark.gluten.sql.columnar.backend.ch.shuffle.hash.algorithm", "sparkMurmurHash3_32");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_config.use_local_format", "true");
        conf.set("spark.gluten.sql.columnar.backend.ch.runtime_settings.use_excel_serialization", "true");
    }

    private GlutenTestConfig$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.GLUTEN_CH_LIB_PATH_KEY = "clickhouse.lib.path";
    }
}

