/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.IOException;
import org.apache.kylin.profiler.AsyncProfiler;
import org.junit.Assert;
import org.junit.Test;

public class AsyncProfilerTest {
    @Test
    public void testLocalLoaded() {
        Assert.assertTrue((boolean)AsyncProfiler.getInstance((boolean)true).isLoaded());
    }

    @Test
    public void testRemoteLoaded() {
        Assert.assertTrue((boolean)AsyncProfiler.getInstance((boolean)false).isLoaded());
    }

    @Test
    public void testLoadError() {
        System.setProperty("os.name", "Mac");
        String errorMsg = "";
        try {
            AsyncProfiler.getInstance((boolean)true);
        }
        catch (Throwable throwable) {
            errorMsg = throwable.getMessage();
        }
        Assert.assertNotNull((Object)errorMsg);
    }

    @Test
    public void testExecute() throws IOException {
        AsyncProfiler asyncProfiler = AsyncProfiler.getInstance((boolean)true);
        try {
            asyncProfiler.execute("start,event=cpu");
            asyncProfiler.stop();
        }
        catch (IllegalStateException illegalState) {
            System.out.println(this.getClass().getCanonicalName() + ": " + illegalState.getMessage());
        }
    }

    @Test
    public void testStop() {
        Assert.assertThrows((String)"Profiler is not active", IllegalStateException.class, () -> ((AsyncProfiler)AsyncProfiler.getInstance((boolean)true)).stop());
    }
}

