/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiMigrateRolesArguments {
    @SerializedName(value="roleNamesToMigrate")
    private List<String> roleNamesToMigrate = null;
    @SerializedName(value="destinationHostId")
    private String destinationHostId = null;
    @SerializedName(value="clearStaleRoleData")
    private Boolean clearStaleRoleData = null;

    public ApiMigrateRolesArguments roleNamesToMigrate(List<String> roleNamesToMigrate) {
        this.roleNamesToMigrate = roleNamesToMigrate;
        return this;
    }

    public ApiMigrateRolesArguments addRoleNamesToMigrateItem(String roleNamesToMigrateItem) {
        if (this.roleNamesToMigrate == null) {
            this.roleNamesToMigrate = new ArrayList<String>();
        }
        this.roleNamesToMigrate.add(roleNamesToMigrateItem);
        return this;
    }

    @Schema(description="The list of role names to migrate.")
    public List<String> getRoleNamesToMigrate() {
        return this.roleNamesToMigrate;
    }

    public void setRoleNamesToMigrate(List<String> roleNamesToMigrate) {
        this.roleNamesToMigrate = roleNamesToMigrate;
    }

    public ApiMigrateRolesArguments destinationHostId(String destinationHostId) {
        this.destinationHostId = destinationHostId;
        return this;
    }

    @Schema(description="The ID of the host to which the roles should be migrated.")
    public String getDestinationHostId() {
        return this.destinationHostId;
    }

    public void setDestinationHostId(String destinationHostId) {
        this.destinationHostId = destinationHostId;
    }

    public ApiMigrateRolesArguments clearStaleRoleData(Boolean clearStaleRoleData) {
        this.clearStaleRoleData = clearStaleRoleData;
        return this;
    }

    @Schema(description="Delete existing stale role data, if any. For example, when migrating a NameNode, if the destination host has stale data in the NameNode data directories (possibly because a NameNode role was previously located there), this stale data will be deleted before migrating the role. Defaults to false.")
    public Boolean isClearStaleRoleData() {
        return this.clearStaleRoleData;
    }

    public void setClearStaleRoleData(Boolean clearStaleRoleData) {
        this.clearStaleRoleData = clearStaleRoleData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiMigrateRolesArguments apiMigrateRolesArguments = (ApiMigrateRolesArguments)o;
        return Objects.equals(this.roleNamesToMigrate, apiMigrateRolesArguments.roleNamesToMigrate) && Objects.equals(this.destinationHostId, apiMigrateRolesArguments.destinationHostId) && Objects.equals(this.clearStaleRoleData, apiMigrateRolesArguments.clearStaleRoleData);
    }

    public int hashCode() {
        return Objects.hash(this.roleNamesToMigrate, this.destinationHostId, this.clearStaleRoleData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiMigrateRolesArguments {\n");
        sb.append("    roleNamesToMigrate: ").append(this.toIndentedString(this.roleNamesToMigrate)).append("\n");
        sb.append("    destinationHostId: ").append(this.toIndentedString(this.destinationHostId)).append("\n");
        sb.append("    clearStaleRoleData: ").append(this.toIndentedString(this.clearStaleRoleData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

