/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.zeppelin;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class ZeppelinServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "ZEPPELIN";
    public static final String SERVICE_TYPE = "ZEPPELIN";
    public static final String ROLE_TYPE = "ZEPPELIN_SERVER";
    protected static final String SSL_ENABLED = "ssl_enabled";
    protected static final String SERVER_SSL_PORT = "zeppelin_server_ssl_port";
    protected static final String SERVER_PORT = "zeppelin_server_port";

    @Override
    public String getService() {
        return "ZEPPELIN";
    }

    @Override
    public String getServiceType() {
        return "ZEPPELIN";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        if (this.isSSL(roleConfig)) {
            scheme = "https";
            port = this.getSSLPort(roleConfig);
        } else {
            scheme = "http";
            port = this.getPort(roleConfig);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), SERVER_PORT, this.getPort(roleConfig));
        model.addRoleProperty(this.getRoleType(), SERVER_SSL_PORT, this.getSSLPort(roleConfig));
        return model;
    }

    protected boolean isSSL(ApiConfigList roleConfig) {
        return Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
    }

    protected String getPort(ApiConfigList roleConfig) {
        return this.getRoleConfigValue(roleConfig, SERVER_PORT);
    }

    protected String getSSLPort(ApiConfigList roleConfig) {
        return this.getRoleConfigValue(roleConfig, SERVER_SSL_PORT);
    }
}

