/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dto.HomePageProfile;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class GatewayConfigImpl
extends Configuration
implements GatewayConfig {
    private static final String GATEWAY_DEFAULT_TOPOLOGY_NAME_PARAM = "default.app.topology.name";
    private static final String GATEWAY_DEFAULT_TOPOLOGY_NAME = "homepage";
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String GATEWAY_CONFIG_DIR_PREFIX = "conf";
    private static final String GATEWAY_CONFIG_FILE_PREFIX = "gateway";
    private static final String DEFAULT_STACKS_SERVICES_DIR = "services";
    private static final String DEFAULT_APPLICATIONS_DIR = "applications";
    private static final String[] GATEWAY_CONFIG_FILENAMES = new String[]{"gateway-default.xml", "gateway-site.xml"};
    private static final String GATEWAY_SERVICE_PREFIX = "gateway.service.";
    public static final String HTTP_HOST = "gateway.host";
    public static final String HTTP_PORT = "gateway.port";
    public static final String HTTP_PATH = "gateway.path";
    public static final String DEPLOYMENT_DIR = "gateway.deployment.dir";
    public static final String SECURITY_DIR = "gateway.security.dir";
    public static final String DATA_DIR = "gateway.data.dir";
    public static final String STACKS_SERVICES_DIR = "gateway.services.dir";
    public static final String GLOBAL_RULES_SERVICES = "gateway.global.rules.services";
    public static final String APPLICATIONS_DIR = "gateway.applications.dir";
    public static final String HADOOP_CONF_DIR = "gateway.hadoop.conf.dir";
    public static final String FRONTEND_URL = "gateway.frontend.url";
    private static final String TRUST_ALL_CERTS = "gateway.trust.all.certs";
    private static final String CLIENT_AUTH_NEEDED = "gateway.client.auth.needed";
    private static final String CLIENT_AUTH_WANTED = "gateway.client.auth.wanted";
    private static final String KEYSTORE_TYPE = "gateway.keystore.type";
    private static final String KEYSTORE_CACHE_LIMIT = "gateway.keystore.cache.size.limit";
    private static final long DEFAULT_KEYSTORE_CACHE_LIMIT = 1000L;
    private static final String KEYSTORE_CACHE_ENTRY_TTL = "gateway.keystore.cache.entry.ttl";
    private static final long DEFAULT_KEYSTORE_CACHE_ENTRY_TTL = 60L;
    private static final String XFORWARDED_ENABLED = "gateway.xforwarded.enabled";
    private static final String EPHEMERAL_DH_KEY_SIZE = "gateway.jdk.tls.ephemeralDHKeySize";
    private static final String HTTP_CLIENT_MAX_CONNECTION = "gateway.httpclient.maxConnections";
    private static final String HTTP_CLIENT_CONNECTION_TIMEOUT = "gateway.httpclient.connectionTimeout";
    private static final String HTTP_CLIENT_SOCKET_TIMEOUT = "gateway.httpclient.socketTimeout";
    private static final String THREAD_POOL_MAX = "gateway.threadpool.max";
    public static final String HTTP_SERVER_REQUEST_BUFFER = "gateway.httpserver.requestBuffer";
    public static final String HTTP_SERVER_REQUEST_HEADER_BUFFER = "gateway.httpserver.requestHeaderBuffer";
    public static final String HTTP_SERVER_RESPONSE_BUFFER = "gateway.httpserver.responseBuffer";
    public static final String HTTP_SERVER_RESPONSE_HEADER_BUFFER = "gateway.httpserver.responseHeaderBuffer";
    public static final String DEPLOYMENTS_BACKUP_VERSION_LIMIT = "gateway.deployment.backup.versionLimit";
    public static final String DEPLOYMENTS_BACKUP_AGE_LIMIT = "gateway.deployment.backup.ageLimit";
    public static final String METRICS_ENABLED = "gateway.metrics.enabled";
    public static final String JMX_METRICS_REPORTING_ENABLED = "gateway.jmx.metrics.reporting.enabled";
    public static final String GRAPHITE_METRICS_REPORTING_ENABLED = "gateway.graphite.metrics.reporting.enabled";
    public static final String GRAPHITE_METRICS_REPORTING_HOST = "gateway.graphite.metrics.reporting.host";
    public static final String GRAPHITE_METRICS_REPORTING_PORT = "gateway.graphite.metrics.reporting.port";
    public static final String GRAPHITE_METRICS_REPORTING_FREQUENCY = "gateway.graphite.metrics.reporting.frequency";
    public static final String GATEWAY_IDLE_TIMEOUT = "gateway.idle.timeout";
    public static final String REMOTE_IP_HEADER_NAME = "gateway.remote.ip.header.name";
    private static final String JETTY_MAX_FORM_CONTENT_SIZE = "gateway.jetty.max.form.content.size";
    private static final String JETTY_MAX_FORM_KEYS = "gateway.jetty.max.form.keys";
    public static final String WEBSOCKET_FEATURE_ENABLED = "gateway.websocket.feature.enabled";
    public static final String WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = "gateway.websocket.max.text.size";
    public static final String WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = "gateway.websocket.max.binary.size";
    public static final String WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = "gateway.websocket.max.text.buffer.size";
    public static final String WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = "gateway.websocket.max.binary.buffer.size";
    public static final String WEBSOCKET_INPUT_BUFFER_SIZE = "gateway.websocket.input.buffer.size";
    public static final String WEBSOCKET_ASYNC_WRITE_TIMEOUT = "gateway.websocket.async.write.timeout";
    public static final String WEBSOCKET_IDLE_TIMEOUT = "gateway.websocket.idle.timeout";
    public static final String WEBSOCKET_MAX_WAIT_BUFFER_COUNT = "gateway.websocket.max.wait.buffer.count";
    public static final String WEBSHELL_FEATURE_ENABLED = "gateway.webshell.feature.enabled";
    public static final String WEBSHELL_AUDIT_LOGGING_ENABLED = "gateway.webshell.audit.logging.enabled";
    public static final String WEBSHELL_MAX_CONCURRENT_SESSIONS = "gateway.webshell.max.concurrent.sessions";
    public static final String WEBSHELL_READ_BUFFER_SIZE = "gateway.webshell.read.buffer.size";
    public static final String GATEWAY_PORT_MAPPING_PREFIX = "gateway.port.mapping.";
    public static final String GATEWAY_PORT_MAPPING_REGEX = "gateway\\.port\\.mapping\\..*";
    public static final String GATEWAY_PORT_MAPPING_ENABLED = "gateway.port.mapping.enabled";
    public static final String CLUSTER_CONFIG_MONITOR_PREFIX = "gateway.cluster.config.monitor.";
    public static final String CLUSTER_CONFIG_MONITOR_INTERVAL_SUFFIX = ".interval";
    public static final String CLUSTER_CONFIG_MONITOR_ENABLED_SUFFIX = ".enabled";
    private static final String SSL_ENABLED = "ssl.enabled";
    private static final String SSL_INCLUDE_PROTOCOLS = "ssl.include.protocols";
    private static final String SSL_EXCLUDE_PROTOCOLS = "ssl.exclude.protocols";
    private static final String SSL_INCLUDE_CIPHERS = "ssl.include.ciphers";
    private static final String SSL_EXCLUDE_CIPHERS = "ssl.exclude.ciphers";
    private static final String SSL_RENEGOTIATION = "ssl.renegotiation";
    public static final String DEFAULT_HTTP_PORT = "8888";
    public static final String DEFAULT_HTTP_PATH = "gateway";
    public static final String DEFAULT_DEPLOYMENT_DIR = "deployments";
    public static final String DEFAULT_SECURITY_DIR = "security";
    public static final String DEFAULT_DATA_DIR = "data";
    private static final String PROVIDERCONFIG_DIR_NAME = "shared-providers";
    private static final String DESCRIPTORS_DIR_NAME = "descriptors";
    public static final String REMOTE_ALIAS_SERVICE_ENABLED = "gateway.remote.alias.service.enabled";
    public static final String STRICT_TOPOLOGY_VALIDATION = "gateway.strict.topology.validation";
    private static final String TOPOLOGY_REDEPLOYMENT_REQUIRES_CHANGES = "gateway.topology.redeploy.requires.changes";
    public static final String READ_ONLY_OVERRIDE_TOPOLOGIES = "gateway.read.only.override.topologies";
    public static final String READ_ONLY_OVERRIDE_PROVIDERS = "gateway.read.only.override.providers";
    public static final boolean DEFAULT_WEBSOCKET_FEATURE_ENABLED = false;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_INPUT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_WEBSOCKET_ASYNC_WRITE_TIMEOUT = 60000;
    public static final int DEFAULT_WEBSOCKET_IDLE_TIMEOUT = 300000;
    public static final int DEFAULT_WEBSOCKET_MAX_WAIT_BUFFER_COUNT = 100;
    public static final boolean DEFAULT_WEBSHELL_FEATURE_ENABLED = false;
    public static final boolean DEFAULT_WEBSHELL_AUDIT_LOGGING_ENABLED = false;
    public static final int DEFAULT_WEBSHELL_MAX_CONCURRENT_SESSIONS = 3;
    public static final int DEFAULT_WEBSHELL_READ_BUFFER_SIZE = 1024;
    public static final boolean DEFAULT_GATEWAY_PORT_MAPPING_ENABLED = true;
    public static final boolean DEFAULT_REMOTE_ALIAS_SERVICE_ENABLED = true;
    public static final boolean DEFAULT_STRICT_TOPOLOGY_VALIDATION = false;
    public static final String COOKIE_SCOPING_ENABLED = "gateway.scope.cookies.feature.enabled";
    public static final boolean DEFAULT_COOKIE_SCOPING_FEATURE_ENABLED = false;
    private static final String CRYPTO_ALGORITHM = "gateway.crypto.algorithm";
    private static final String CRYPTO_PBE_ALGORITHM = "gateway.crypto.pbe.algorithm";
    private static final String CRYPTO_TRANSFORMATION = "gateway.crypto.transformation";
    private static final String CRYPTO_SALTSIZE = "gateway.crypto.salt.size";
    private static final String CRYPTO_ITERATION_COUNT = "gateway.crypto.iteration.count";
    private static final String CRYPTO_KEY_LENGTH = "gateway.crypto.key.length";
    public static final String SERVER_HEADER_ENABLED = "gateway.server.header.enabled";
    static final String CONFIG_REGISTRY_PREFIX = "gateway.remote.config.registry";
    static final String REMOTE_CONFIG_MONITOR_CLIENT_NAME = "gateway.remote.config.monitor.client";
    static final String REMOTE_CONFIG_MONITOR_CLIENT_ALLOW_READ_ACCESS = "gateway.remote.config.monitor.client.allowUnauthenticatedReadAccess";
    private static final String REMOTE_CONFIG_MONITOR_DB_POLLING_INTERVAL_SECONDS = "gateway.remote.config.monitor.db.poll.interval.seconds";
    private static final long REMOTE_CONFIG_MONITOR_DB_POLLING_INTERVAL_SECONDS_DEFAULT = 30L;
    private static final String REMOTE_CONFIG_MONITOR_DB_POLLING_CLEANUP_INTERVAL_SECONDS = "gateway.remote.config.monitor.db.cleanup.interval.seconds";
    private static final int REMOTE_CONFIG_MONITOR_DB_POLLING_CLEANUP_INTERVAL_DEFAULT = 10800;
    static final String DEFAULT_DISCOVERY_ADDRESS = "gateway.discovery.default.address";
    static final String DEFAULT_DISCOVERY_CLUSTER = "gateway.discovery.default.cluster";
    static final String KNOX_ADMIN_GROUPS = "gateway.knox.admin.groups";
    static final String KNOX_ADMIN_USERS = "gateway.knox.admin.users";
    static final String CUSTOM_FEDERATION_HEADER_NAME = "gateway.custom.federation.header.name";
    static final String DEFAULT_FEDERATION_HEADER_NAME = "SM_USER";
    static final String AUTO_DEPLOY_TOPOLOGIES = "gateway.auto.deploy.topologies";
    static final String DEFAULT_AUTO_DEPLOY_TOPOLOGIES = "manager,admin";
    static final String DISPATCH_HOST_WHITELIST = "gateway.dispatch.whitelist";
    static final String DISPATCH_HOST_WHITELIST_SERVICES = "gateway.dispatch.whitelist.services";
    static final String REMOTE_ALIAS_SERVICE_CONFIG_PREFIX = "gateway.remote.alias.service.config.prefix";
    static final String REMOTE_ALIAS_SERVICE_CONFIG_PREFIX_DEFAULT = "gateway.remote.alias.service.config.";
    private static final List<String> DEFAULT_GLOBAL_RULES_SERVICES = Arrays.asList("NAMENODE", "JOBTRACKER", "WEBHDFS", "WEBHCAT", "OOZIE", "WEBHBASE", "HIVE", "RESOURCEMANAGER", "RESOURCEMANAGERAPI");
    public static final String X_FORWARD_CONTEXT_HEADER_APPEND_SERVICES = "gateway.xforwarded.header.context.append.servicename";
    private static final String TOKEN_STATE_SERVER_MANAGED = "gateway.knox.token.exp.server-managed";
    private static final String CLOUDERA_MANAGER_DESCRIPTORS_MONITOR_INTERVAL = "gateway.cloudera.manager.descriptors.monitor.interval";
    private static final String CLOUDERA_MANAGER_ADVANCED_SERVICE_DISCOVERY_CONF_MONITOR_INTERVAL = "gateway.cloudera.manager.advanced.service.discovery.config.monitor.interval";
    private static final String CLOUDERA_MANAGER_SERVICE_DISCOVERY_REPOSITORY_CACHE_ENTRY_TTL = "gateway.cloudera.manager.service.discovery.repository.cache.entry.ttl";
    private static final String CLOUDERA_MANAGER_SERVICE_DISCOVERY_MAX_RETRY_ATTEMPS = "gateway.cloudera.manager.service.discovery.maximum.retry.attemps";
    private static final String KNOX_TOKEN_EVICTION_INTERVAL = "gateway.knox.token.eviction.interval";
    private static final String KNOX_TOKEN_EVICTION_GRACE_PERIOD = "gateway.knox.token.eviction.grace.period";
    private static final String KNOX_TOKEN_ALIAS_PERSISTENCE_INTERVAL = "gateway.knox.token.state.alias.persistence.interval";
    private static final String KNOX_TOKEN_PERMISSIVE_VALIDATION_ENABLED = "gateway.knox.token.permissive.validation";
    private static final String KNOX_TOKEN_HASH_ALGORITHM = "gateway.knox.token.hash.algorithm";
    public static final String KNOX_TOKEN_USER_LIMIT = "gateway.knox.token.limit.per.user";
    private static final long KNOX_TOKEN_EVICTION_INTERVAL_DEFAULT = TimeUnit.MINUTES.toSeconds(5L);
    private static final long KNOX_TOKEN_EVICTION_GRACE_PERIOD_DEFAULT = TimeUnit.HOURS.toSeconds(24L);
    private static final long KNOX_TOKEN_ALIAS_PERSISTENCE_INTERVAL_DEFAULT = TimeUnit.SECONDS.toSeconds(15L);
    public static final int KNOX_TOKEN_USER_LIMIT_DEFAULT = 10;
    private static final boolean KNOX_TOKEN_PERMISSIVE_VALIDATION_ENABLED_DEFAULT = false;
    private static final String KNOX_HOMEPAGE_PROFILE_PREFIX = "knox.homepage.profile.";
    private static final String KNOX_HOMEPAGE_PINNED_TOPOLOGIES = "knox.homepage.pinned.topologies";
    private static final String KNOX_HOMEPAGE_HIDDEN_TOPOLOGIES = "knox.homepage.hidden.topologies";
    private static final Set<String> KNOX_HOMEPAGE_HIDDEN_TOPOLOGIES_DEFAULT = new HashSet<String>(Arrays.asList("admin", "manager", "knoxsso", "metadata", "homepage"));
    private static final String KNOX_HOMEPAGE_LOGOUT_ENABLED = "knox.homepage.logout.enabled";
    private static final String GLOBAL_LOGOUT_PAGE_URL = "knox.global.logout.page.url";
    private static final String KNOX_INCOMING_XFORWARDED_ENABLED = "gateway.incoming.xforwarded.enabled";
    private static final String GATEWAY_DATABASE_TYPE = "gateway.database.type";
    private static final String GATEWAY_DATABASE_CONN_URL = "gateway.database.connection.url";
    private static final String GATEWAY_DATABASE_HOST = "gateway.database.host";
    private static final String GATEWAY_DATABASE_PORT = "gateway.database.port";
    private static final String GATEWAY_DATABASE_NAME = "gateway.database.name";
    private static final String GATEWAY_DATABASE_SSL_ENABLED = "gateway.database.ssl.enabled";
    private static final String GATEWAY_DATABASE_VERIFY_SERVER_CERT = "gateway.database.ssl.verify.server.cert";
    private static final String GATEWAY_DATABASE_TRUSTSTORE_FILE = "gateway.database.ssl.truststore.file";
    private static final String GATEWAY_SESSION_VERIFICATION_PREFIX = "gateway.session.verification";
    private static final String GATEWAY_SESSION_VERIFICATION_PRIVILEGED_USER_LIMIT = "gateway.session.verification.privileged.user.limit";
    private static final String GATEWAY_SESSION_VERIFICATION_NON_PRIVILEGED_USER_LIMIT = "gateway.session.verification.non.privileged.user.limit";
    private static final int GATEWAY_SESSION_VERIFICATION_PRIVILEGED_USER_LIMIT_DEFAULT = 3;
    private static final int GATEWAY_SESSION_VERIFICATION_NON_PRIVILEGED_USER_LIMIT_DEFAULT = 2;
    private static final String GATEWAY_SESSION_VERIFICATION_PRIVILEGED_USERS = "gateway.session.verification.privileged.users";
    private static final String GATEWAY_SESSION_VERIFICATION_UNLIMITED_USERS = "gateway.session.verification.unlimited.users";
    private static final String GATEWAY_SESSION_VERIFICATION_EXPIRED_TOKENS_CLEANING_PERIOD = "gateway.session.verification.expired.tokens.cleaning.period";
    private static final long GATEWAY_SESSION_VERIFICATION_EXPIRED_TOKENS_CLEANING_PERIOD_DEFAULT = TimeUnit.MINUTES.toSeconds(30L);
    private static final String GATEWAY_SERVLET_ASYNC_SUPPORTED = "gateway.servlet.async.supported";
    private static final boolean GATEWAY_SERVLET_ASYNC_SUPPORTED_DEFAULT = false;

    public GatewayConfigImpl() {
        this.init();
    }

    private String getVar(String variableName, String defaultValue) {
        String value = this.get(variableName);
        if (value == null) {
            value = System.getProperty(variableName);
        }
        if (value == null) {
            value = System.getenv(variableName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String getGatewayHomeDir() {
        return this.get("GATEWAY_HOME", System.getProperty("GATEWAY_HOME", System.getenv("GATEWAY_HOME")));
    }

    public String getGatewayPIDDir() {
        String pidDir = this.getGatewayHomeDir() + File.separator + "pids";
        return FilenameUtils.normalize((String)pidDir);
    }

    public String getGatewayConfDir() {
        String configDir = System.getProperty("GATEWAY_CONF_HOME", System.getenv("GATEWAY_CONF_HOME"));
        if (StringUtils.isBlank((CharSequence)configDir)) {
            configDir = this.getVar("KNOX_GATEWAY_CONF_DIR", this.getGatewayHomeDir() + File.separator + GATEWAY_CONFIG_DIR_PREFIX);
        }
        return FilenameUtils.normalize((String)configDir);
    }

    public String getGatewayDataDir() {
        String dataDir = System.getProperty("GATEWAY_DATA_HOME", System.getenv("GATEWAY_DATA_HOME"));
        if (StringUtils.isBlank((CharSequence)dataDir)) {
            dataDir = System.getProperty("KNOX_GATEWAY_DATA_DIR", System.getenv("KNOX_GATEWAY_DATA_DIR"));
        }
        if (StringUtils.isBlank((CharSequence)dataDir)) {
            dataDir = this.get(DATA_DIR, this.getGatewayHomeDir() + File.separator + DEFAULT_DATA_DIR);
        }
        return FilenameUtils.normalize((String)dataDir);
    }

    public String getGatewayServicesDir() {
        return this.get(STACKS_SERVICES_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_STACKS_SERVICES_DIR);
    }

    public String getGatewayApplicationsDir() {
        return this.get(APPLICATIONS_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_APPLICATIONS_DIR);
    }

    public String getHadoopConfDir() {
        return this.get(HADOOP_CONF_DIR);
    }

    private void init() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            this.set("env." + e.getKey(), e.getValue());
        }
        for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
            this.set("sys." + p.getKey().toString(), p.getValue().toString());
        }
        URL lastFileUrl = null;
        for (String fileName : GATEWAY_CONFIG_FILENAMES) {
            lastFileUrl = this.loadConfig(fileName);
        }
        this.initGatewayHomeDir(lastFileUrl);
        log.cookieScopingFeatureEnabled(this.isCookieScopingToPathEnabled());
    }

    private void initGatewayHomeDir(URL lastFileUrl) {
        String home = System.getProperty("GATEWAY_HOME");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("system property", home);
            return;
        }
        home = System.getenv("GATEWAY_HOME");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("environment variable", home);
            return;
        }
        if (lastFileUrl != null) {
            File file = new File(lastFileUrl.getFile()).getAbsoluteFile();
            File dir = file.getParentFile().getParentFile();
            if (dir.exists() && dir.canRead()) {
                home = dir.getAbsolutePath();
            }
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("configuration file location", home);
            return;
        }
        home = System.getProperty("user.dir");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("user.dir system property", home);
        }
    }

    private URL loadConfig(String fileName) {
        URL configFileUrl = this.loadConfigFile(this.getGatewayConfDir(), fileName);
        if (configFileUrl == null) {
            configFileUrl = this.loadConfigFile(System.getProperty("GATEWAY_HOME"), GATEWAY_CONFIG_DIR_PREFIX + File.separator + fileName);
        }
        if (configFileUrl == null) {
            configFileUrl = this.loadConfigFile(System.getenv("GATEWAY_HOME"), GATEWAY_CONFIG_DIR_PREFIX + File.separator + fileName);
        }
        if (configFileUrl == null) {
            configFileUrl = this.loadConfigFile(System.getProperty("user.dir"), GATEWAY_CONFIG_DIR_PREFIX + File.separator + fileName);
        }
        if (configFileUrl == null) {
            configFileUrl = this.loadConfigResource(GATEWAY_CONFIG_DIR_PREFIX + File.separator + fileName);
        }
        if (configFileUrl != null && !"file".equals(configFileUrl.getProtocol())) {
            configFileUrl = null;
        }
        return configFileUrl;
    }

    private URL loadConfigFile(String dir, String file) {
        File f;
        URL url = null;
        if (dir != null && (f = new File(dir, file)).exists()) {
            String path = f.getAbsolutePath();
            try {
                url = f.toURI().toURL();
                this.addResource(new Path(path));
                log.loadingConfigurationFile(path);
            }
            catch (MalformedURLException e) {
                log.failedToLoadConfig(path, e);
            }
        }
        return url;
    }

    private URL loadConfigResource(String file) {
        URL url = this.getResource(file);
        if (url != null) {
            log.loadingConfigurationResource(url.toExternalForm());
            this.addResource(url);
        }
        return url;
    }

    public List<String> getGatewayHost() {
        String hosts = this.get(HTTP_HOST, "0.0.0.0");
        String[] hostArray = hosts.split(",");
        ArrayList<String> hostIps = new ArrayList<String>();
        for (String host : hostArray) {
            hostIps.add(host.trim());
        }
        return hostIps;
    }

    public int getGatewayPort() {
        return Integer.parseInt(this.get(HTTP_PORT, DEFAULT_HTTP_PORT));
    }

    public String getGatewayPath() {
        return this.get(HTTP_PATH, "gateway");
    }

    public String getGatewayProvidersConfigDir() {
        return this.getGatewayConfDir() + File.separator + PROVIDERCONFIG_DIR_NAME;
    }

    public String getGatewayDescriptorsDir() {
        return this.getGatewayConfDir() + File.separator + DESCRIPTORS_DIR_NAME;
    }

    public String getGatewayTopologyDir() {
        return this.getGatewayConfDir() + File.separator + "topologies";
    }

    public String getGatewayDeploymentDir() {
        return this.get(DEPLOYMENT_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_DEPLOYMENT_DIR);
    }

    public String getGatewaySecurityDir() {
        return this.get(SECURITY_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_SECURITY_DIR);
    }

    public String getGatewayKeystoreDir() {
        return Paths.get(this.getGatewaySecurityDir(), "keystores").toAbsolutePath().toString();
    }

    public List<InetSocketAddress> getGatewayAddress() throws UnknownHostException {
        List<String> hostIps = this.getGatewayHost();
        int port = this.getGatewayPort();
        ArrayList<InetSocketAddress> socketAddressList = new ArrayList<InetSocketAddress>();
        for (String host : hostIps) {
            socketAddressList.add(new InetSocketAddress(host, port));
        }
        return socketAddressList;
    }

    public boolean isSSLEnabled() {
        return Boolean.parseBoolean(this.get(SSL_ENABLED, "true"));
    }

    public boolean isHadoopKerberosSecured() {
        return Boolean.parseBoolean(this.get("gateway.hadoop.kerberos.secured", "false"));
    }

    public String getKerberosConfig() {
        return this.get("java.security.krb5.conf");
    }

    public boolean isKerberosDebugEnabled() {
        return Boolean.parseBoolean(this.get("sun.security.krb5.debug", "false"));
    }

    public String getKerberosLoginConfig() {
        return this.get("java.security.auth.login.config");
    }

    public String getDefaultTopologyName() {
        String name = this.get(GATEWAY_DEFAULT_TOPOLOGY_NAME_PARAM);
        return name != null ? name : GATEWAY_DEFAULT_TOPOLOGY_NAME;
    }

    public String getDefaultAppRedirectPath() {
        String defTopo = this.getDefaultTopologyName();
        if (defTopo == null) {
            return null;
        }
        return "/" + this.getGatewayPath() + "/" + defTopo;
    }

    public String getFrontendUrl() {
        return this.get(FRONTEND_URL, null);
    }

    public Set<String> getIncludedSSLProtocols() {
        Collection includedSslProtocols = this.getTrimmedStringCollection(SSL_INCLUDE_PROTOCOLS);
        return includedSslProtocols == null ? Collections.emptySet() : new HashSet(includedSslProtocols);
    }

    public List<String> getExcludedSSLProtocols() {
        List<String> protocols = null;
        String value = this.get(SSL_EXCLUDE_PROTOCOLS);
        if (!"none".equals(value)) {
            protocols = Arrays.asList(value.split("\\s*,\\s*"));
        }
        return protocols;
    }

    public List<String> getIncludedSSLCiphers() {
        List<String> list = null;
        String value = this.get(SSL_INCLUDE_CIPHERS);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            list = Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return list;
    }

    public List<String> getExcludedSSLCiphers() {
        List<String> list = null;
        String value = this.get(SSL_EXCLUDE_CIPHERS);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            list = Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return list;
    }

    public boolean isSSLRenegotiationAllowed() {
        return this.getBoolean(SSL_RENEGOTIATION, true);
    }

    public boolean isClientAuthNeeded() {
        return Boolean.parseBoolean(this.get(CLIENT_AUTH_NEEDED, "false"));
    }

    public boolean isClientAuthWanted() {
        return Boolean.parseBoolean(this.get(CLIENT_AUTH_WANTED, "false"));
    }

    public String getTruststorePath() {
        return this.get("gateway.truststore.path", null);
    }

    public boolean getTrustAllCerts() {
        return Boolean.parseBoolean(this.get(TRUST_ALL_CERTS, "false"));
    }

    public String getTruststoreType() {
        return this.get("gateway.truststore.type", DEFAULT_GATEWAY_TRUSTSTORE_TYPE);
    }

    public String getTruststorePasswordAlias() {
        return this.get("gateway.truststore.password.alias", "gateway-truststore-password");
    }

    public String getKeystoreType() {
        return this.get(KEYSTORE_TYPE, KeyStore.getDefaultType());
    }

    public boolean isXForwardedEnabled() {
        return Boolean.parseBoolean(this.get(XFORWARDED_ENABLED, "true"));
    }

    public String getEphemeralDHKeySize() {
        return this.get(EPHEMERAL_DH_KEY_SIZE, "2048");
    }

    public int getHttpClientMaxConnections() {
        return this.getInt(HTTP_CLIENT_MAX_CONNECTION, 32);
    }

    public int getHttpClientConnectionTimeout() {
        int t = -1;
        String s = this.get(HTTP_CLIENT_CONNECTION_TIMEOUT, String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        if (s != null) {
            try {
                t = (int)GatewayConfigImpl.parseNetworkTimeout(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public int getHttpClientSocketTimeout() {
        int t = -1;
        String s = this.get(HTTP_CLIENT_SOCKET_TIMEOUT, String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        if (s != null) {
            try {
                t = (int)GatewayConfigImpl.parseNetworkTimeout(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public String getHttpClientTruststorePath() {
        return this.get("gateway.httpclient.truststore.path");
    }

    public String getHttpClientTruststoreType() {
        return this.get("gateway.httpclient.truststore.type", DEFAULT_HTTP_CLIENT_TRUSTSTORE_TYPE);
    }

    public String getHttpClientTruststorePasswordAlias() {
        return this.get("gateway.httpclient.truststore.password.alias", "gateway-httpclient-truststore-password");
    }

    public String getCredentialStoreAlgorithm() {
        return this.get("gateway.credential.store.alg", "AES");
    }

    public String getCredentialStoreType() {
        return this.get("gateway.credential.store.type", "JCEKS");
    }

    public int getThreadPoolMax() {
        int i = this.getInt(THREAD_POOL_MAX, 254);
        if (i < 5) {
            i = 5;
        }
        return i;
    }

    public int getHttpServerRequestBuffer() {
        return this.getInt(HTTP_SERVER_REQUEST_BUFFER, 16384);
    }

    public int getHttpServerRequestHeaderBuffer() {
        return this.getInt(HTTP_SERVER_REQUEST_HEADER_BUFFER, 8192);
    }

    public int getHttpServerResponseBuffer() {
        return this.getInt(HTTP_SERVER_RESPONSE_BUFFER, 32768);
    }

    public int getHttpServerResponseHeaderBuffer() {
        return this.getInt(HTTP_SERVER_RESPONSE_HEADER_BUFFER, 8192);
    }

    public int getGatewayDeploymentsBackupVersionLimit() {
        int i = this.getInt(DEPLOYMENTS_BACKUP_VERSION_LIMIT, 5);
        if (i < 0) {
            i = -1;
        }
        return i;
    }

    public long getGatewayIdleTimeout() {
        return this.getLong(GATEWAY_IDLE_TIMEOUT, 300000L);
    }

    public long getGatewayDeploymentsBackupAgeLimit() {
        long d;
        PeriodFormatter f = new PeriodFormatterBuilder().appendDays().toFormatter();
        String s = this.get(DEPLOYMENTS_BACKUP_AGE_LIMIT, "-1");
        try {
            Period p = Period.parse((String)s, (PeriodFormatter)f);
            d = p.toStandardDuration().getMillis();
            if (d < 0L) {
                d = -1L;
            }
        }
        catch (Exception e) {
            d = -1L;
        }
        return d;
    }

    public String getIdentityKeystorePath() {
        String keystorePath = this.get("gateway.tls.keystore.path");
        if (StringUtils.isEmpty((CharSequence)keystorePath)) {
            keystorePath = Paths.get(this.getGatewayKeystoreDir(), "gateway.jks").toAbsolutePath().toString();
        }
        return keystorePath;
    }

    public String getIdentityKeystoreType() {
        return this.get("gateway.tls.keystore.type", DEFAULT_IDENTITY_KEYSTORE_TYPE);
    }

    public String getIdentityKeystorePasswordAlias() {
        return this.get("gateway.tls.keystore.password.alias", "gateway-identity-keystore-password");
    }

    public String getIdentityKeyAlias() {
        return this.get("gateway.tls.key.alias", "gateway-identity");
    }

    public String getIdentityKeyPassphraseAlias() {
        return this.get("gateway.tls.key.passphrase.alias", "gateway-identity-passphrase");
    }

    public String getSigningKeystoreName() {
        return this.get("gateway.signing.keystore.name");
    }

    public String getSigningKeystorePath() {
        if (this.getSigningKeystoreName() == null) {
            return this.getIdentityKeystorePath();
        }
        return Paths.get(this.getGatewayKeystoreDir(), this.getSigningKeystoreName()).toAbsolutePath().toString();
    }

    public String getSigningKeystoreType() {
        if (this.getSigningKeystoreName() == null) {
            return this.getIdentityKeystoreType();
        }
        return this.get("gateway.signing.keystore.type", DEFAULT_SIGNING_KEYSTORE_TYPE);
    }

    public String getSigningKeyAlias() {
        if (this.getSigningKeystoreName() == null) {
            return this.getIdentityKeyAlias();
        }
        return this.get("gateway.signing.key.alias", "gateway-identity");
    }

    public String getSigningKeystorePasswordAlias() {
        if (this.getSigningKeystoreName() == null) {
            return this.getIdentityKeystorePasswordAlias();
        }
        return this.get("gateway.signing.keystore.password.alias", "signing.keystore.password");
    }

    public String getSigningKeyPassphraseAlias() {
        if (this.getSigningKeystoreName() == null) {
            return this.getIdentityKeyPassphraseAlias();
        }
        return this.get("gateway.signing.key.passphrase.alias", "signing.key.passphrase");
    }

    public List<String> getGlobalRulesServices() {
        String value = this.get(GLOBAL_RULES_SERVICES);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            return Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return DEFAULT_GLOBAL_RULES_SERVICES;
    }

    public boolean isMetricsEnabled() {
        return Boolean.parseBoolean(this.get(METRICS_ENABLED, "false"));
    }

    public boolean isJmxMetricsReportingEnabled() {
        return Boolean.parseBoolean(this.get(JMX_METRICS_REPORTING_ENABLED, "false"));
    }

    public boolean isGraphiteMetricsReportingEnabled() {
        return Boolean.parseBoolean(this.get(GRAPHITE_METRICS_REPORTING_ENABLED, "false"));
    }

    public String getGraphiteHost() {
        return this.get(GRAPHITE_METRICS_REPORTING_HOST, "localhost");
    }

    public int getGraphitePort() {
        return this.getInt(GRAPHITE_METRICS_REPORTING_PORT, 32772);
    }

    public int getGraphiteReportingFrequency() {
        return this.getInt(GRAPHITE_METRICS_REPORTING_FREQUENCY, 1);
    }

    public boolean isWebsocketEnabled() {
        return this.getBoolean(WEBSOCKET_FEATURE_ENABLED, false);
    }

    public boolean isWebShellEnabled() {
        return this.getBoolean(WEBSHELL_FEATURE_ENABLED, false);
    }

    public boolean isWebShellAuditLoggingEnabled() {
        return this.getBoolean(WEBSHELL_AUDIT_LOGGING_ENABLED, false);
    }

    public int getMaximumConcurrentWebshells() {
        return this.getInt(WEBSHELL_MAX_CONCURRENT_SESSIONS, 3);
    }

    public int getWebShellReadBufferSize() {
        return this.getInt(WEBSHELL_READ_BUFFER_SIZE, 1024);
    }

    public int getWebsocketMaxTextMessageSize() {
        return this.getInt(WEBSOCKET_MAX_TEXT_MESSAGE_SIZE, Integer.MAX_VALUE);
    }

    public int getWebsocketMaxBinaryMessageSize() {
        return this.getInt(WEBSOCKET_MAX_BINARY_MESSAGE_SIZE, Integer.MAX_VALUE);
    }

    public int getWebsocketMaxTextMessageBufferSize() {
        return this.getInt(WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE, 32768);
    }

    public int getWebsocketMaxBinaryMessageBufferSize() {
        return this.getInt(WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE, 32768);
    }

    public int getWebsocketInputBufferSize() {
        return this.getInt(WEBSOCKET_INPUT_BUFFER_SIZE, 4096);
    }

    public int getWebsocketAsyncWriteTimeout() {
        return this.getInt(WEBSOCKET_ASYNC_WRITE_TIMEOUT, 60000);
    }

    public int getWebsocketIdleTimeout() {
        return this.getInt(WEBSOCKET_IDLE_TIMEOUT, 300000);
    }

    public int getWebsocketMaxWaitBufferCount() {
        return this.getInt(WEBSOCKET_MAX_WAIT_BUFFER_COUNT, 100);
    }

    public Map<String, Integer> getGatewayPortMappings() {
        ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>();
        Map properties = this.getValByRegex(GATEWAY_PORT_MAPPING_REGEX);
        for (Map.Entry e : properties.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase(GATEWAY_PORT_MAPPING_ENABLED)) continue;
            result.put(StringUtils.substringAfter((String)((String)e.getKey()), (String)GATEWAY_PORT_MAPPING_PREFIX), Integer.parseInt((String)e.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean isGatewayPortMappingEnabled() {
        String result = this.get(GATEWAY_PORT_MAPPING_ENABLED, Boolean.toString(true));
        return Boolean.parseBoolean(result);
    }

    private static long parseNetworkTimeout(String s) {
        PeriodFormatter f = new PeriodFormatterBuilder().appendMinutes().appendSuffix("m", " min").appendSeconds().appendSuffix("s", " sec").appendMillis().toFormatter();
        Period p = Period.parse((String)s, (PeriodFormatter)f);
        return p.toStandardDuration().getMillis();
    }

    public boolean isCookieScopingToPathEnabled() {
        return Boolean.parseBoolean(this.get(COOKIE_SCOPING_ENABLED, Boolean.toString(false)));
    }

    public String getHeaderNameForRemoteAddress() {
        return this.getVar(REMOTE_IP_HEADER_NAME, "X-Forwarded-For");
    }

    public String getAlgorithm() {
        return this.getVar(CRYPTO_ALGORITHM, null);
    }

    public String getPBEAlgorithm() {
        return this.getVar(CRYPTO_PBE_ALGORITHM, null);
    }

    public String getTransformation() {
        return this.getVar(CRYPTO_TRANSFORMATION, null);
    }

    public String getSaltSize() {
        return this.getVar(CRYPTO_SALTSIZE, null);
    }

    public String getIterationCount() {
        return this.getVar(CRYPTO_ITERATION_COUNT, null);
    }

    public String getKeyLength() {
        return this.getVar(CRYPTO_KEY_LENGTH, null);
    }

    public boolean isGatewayServerHeaderEnabled() {
        return Boolean.parseBoolean(this.getVar(SERVER_HEADER_ENABLED, "false"));
    }

    public String getDefaultDiscoveryAddress() {
        return this.getVar(DEFAULT_DISCOVERY_ADDRESS, null);
    }

    public String getDefaultDiscoveryCluster() {
        return this.getVar(DEFAULT_DISCOVERY_CLUSTER, null);
    }

    public int getClusterMonitorPollingInterval(String type) {
        return this.getInt(CLUSTER_CONFIG_MONITOR_PREFIX + type.toLowerCase(Locale.ROOT) + CLUSTER_CONFIG_MONITOR_INTERVAL_SUFFIX, -1);
    }

    public boolean isClusterMonitorEnabled(String type) {
        return this.getBoolean(CLUSTER_CONFIG_MONITOR_PREFIX + type.toLowerCase(Locale.ROOT) + CLUSTER_CONFIG_MONITOR_ENABLED_SUFFIX, false);
    }

    public List<String> getRemoteRegistryConfigurationNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(CONFIG_REGISTRY_PREFIX)) continue;
            String registryName = propertyName.substring(CONFIG_REGISTRY_PREFIX.length() + 1);
            result.add(registryName);
        }
        return result;
    }

    public String getRemoteRegistryConfiguration(String name) {
        return this.get("gateway.remote.config.registry." + name);
    }

    public String getRemoteConfigurationMonitorClientName() {
        return this.get(REMOTE_CONFIG_MONITOR_CLIENT_NAME);
    }

    public boolean allowUnauthenticatedRemoteRegistryReadAccess() {
        return Boolean.parseBoolean(this.get(REMOTE_CONFIG_MONITOR_CLIENT_ALLOW_READ_ACCESS, String.valueOf(false)));
    }

    public boolean isRemoteAliasServiceEnabled() {
        return this.getBoolean(REMOTE_ALIAS_SERVICE_ENABLED, true);
    }

    public String getRemoteAliasServiceConfigurationPrefix() {
        return this.get(REMOTE_ALIAS_SERVICE_CONFIG_PREFIX, REMOTE_ALIAS_SERVICE_CONFIG_PREFIX_DEFAULT);
    }

    public Map<String, String> getRemoteAliasServiceConfiguration() {
        Map remoteAliasServiceConfiguration = this.getPropsWithPrefix(this.getRemoteAliasServiceConfigurationPrefix());
        if (!remoteAliasServiceConfiguration.containsKey("type")) {
            remoteAliasServiceConfiguration.put("type", "zookeeper");
        }
        return remoteAliasServiceConfiguration;
    }

    public List<String> getReadOnlyOverrideTopologyNames() {
        ArrayList<String> topologyNames = new ArrayList<String>();
        String value = this.get(READ_ONLY_OVERRIDE_TOPOLOGIES);
        if (value != null && !value.isEmpty()) {
            topologyNames.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return topologyNames;
    }

    public List<String> getReadOnlyOverrideProviderNames() {
        ArrayList<String> topologyNames = new ArrayList<String>();
        String value = this.get(READ_ONLY_OVERRIDE_PROVIDERS);
        if (value != null && !value.isEmpty()) {
            topologyNames.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return topologyNames;
    }

    public String getKnoxAdminGroups() {
        return this.get(KNOX_ADMIN_GROUPS, null);
    }

    public String getKnoxAdminUsers() {
        return this.get(KNOX_ADMIN_USERS, null);
    }

    public String getFederationHeaderName() {
        return this.get(CUSTOM_FEDERATION_HEADER_NAME, DEFAULT_FEDERATION_HEADER_NAME);
    }

    public List<String> getAutoDeployTopologyNames() {
        String value = this.get(AUTO_DEPLOY_TOPOLOGIES);
        if (value == null) {
            value = DEFAULT_AUTO_DEPLOY_TOPOLOGIES;
        }
        return new ArrayList<String>(Arrays.asList(value.trim().split("\\s*,\\s*")));
    }

    public String getDispatchWhitelist() {
        return this.get(DISPATCH_HOST_WHITELIST);
    }

    public List<String> getDispatchWhitelistServices() {
        ArrayList<String> result = new ArrayList<String>();
        String serviceList = this.get(DISPATCH_HOST_WHITELIST_SERVICES);
        if (serviceList != null) {
            for (String service : serviceList.split(",")) {
                result.add(service.trim());
            }
        }
        return result;
    }

    public boolean isTopologyValidationEnabled() {
        String result = this.get(STRICT_TOPOLOGY_VALIDATION, Boolean.toString(false));
        return Boolean.parseBoolean(result);
    }

    public boolean topologyRedeploymentRequiresChanges() {
        return this.getBoolean(TOPOLOGY_REDEPLOYMENT_REQUIRES_CHANGES, false);
    }

    public List<String> getXForwardContextAppendServices() {
        String value = this.get(X_FORWARD_CONTEXT_HEADER_APPEND_SERVICES);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            return Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    public Set<String> getServicesToIgnoreDoAs() {
        HashSet<String> set = new HashSet<String>();
        String value = this.get("gateway.proxyuser.services.ignore.doas");
        if (value != null) {
            set.addAll(Arrays.asList(value.trim().toLowerCase(Locale.ROOT).split("\\s*,\\s*")));
        }
        return set;
    }

    public long getClouderaManagerDescriptorsMonitoringInterval() {
        return this.getLong(CLOUDERA_MANAGER_DESCRIPTORS_MONITOR_INTERVAL, -1L);
    }

    public long getClouderaManagerAdvancedServiceDiscoveryConfigurationMonitoringInterval() {
        return this.getLong(CLOUDERA_MANAGER_ADVANCED_SERVICE_DISCOVERY_CONF_MONITOR_INTERVAL, -1L);
    }

    public long getClouderaManagerServiceDiscoveryRepositoryEntryTTL() {
        return this.getLong(CLOUDERA_MANAGER_SERVICE_DISCOVERY_REPOSITORY_CACHE_ENTRY_TTL, 600L);
    }

    public int getClouderaManagerServiceDiscoveryMaximumRetryAttempts() {
        return this.getInt(CLOUDERA_MANAGER_SERVICE_DISCOVERY_MAX_RETRY_ATTEMPS, 3);
    }

    public boolean isServerManagedTokenStateEnabled() {
        return this.getBoolean(TOKEN_STATE_SERVER_MANAGED, false);
    }

    public long getKnoxTokenEvictionInterval() {
        return this.getLong(KNOX_TOKEN_EVICTION_INTERVAL, KNOX_TOKEN_EVICTION_INTERVAL_DEFAULT);
    }

    public long getKnoxTokenEvictionGracePeriod() {
        return this.getLong(KNOX_TOKEN_EVICTION_GRACE_PERIOD, KNOX_TOKEN_EVICTION_GRACE_PERIOD_DEFAULT);
    }

    public long getKnoxTokenStateAliasPersistenceInterval() {
        return this.getLong(KNOX_TOKEN_ALIAS_PERSISTENCE_INTERVAL, KNOX_TOKEN_ALIAS_PERSISTENCE_INTERVAL_DEFAULT);
    }

    public String getKnoxTokenHashAlgorithm() {
        return this.get(KNOX_TOKEN_HASH_ALGORITHM, HmacAlgorithms.HMAC_SHA_256.getName());
    }

    public int getMaximumNumberOfTokensPerUser() {
        return this.getInt(KNOX_TOKEN_USER_LIMIT, 10);
    }

    public Set<String> getHiddenTopologiesOnHomepage() {
        HashSet<String> hiddenTopologies = new HashSet<String>(this.getTrimmedStringCollection(KNOX_HOMEPAGE_HIDDEN_TOPOLOGIES));
        return hiddenTopologies == null || hiddenTopologies.isEmpty() ? KNOX_HOMEPAGE_HIDDEN_TOPOLOGIES_DEFAULT : hiddenTopologies;
    }

    public Set<String> getPinnedTopologiesOnHomepage() {
        Collection pinnedTopologies = this.getTrimmedStringCollection(KNOX_HOMEPAGE_PINNED_TOPOLOGIES);
        return pinnedTopologies == null ? Collections.emptySet() : new HashSet(pinnedTopologies);
    }

    public boolean isKnoxTokenPermissiveValidationEnabled() {
        return this.getBoolean(KNOX_TOKEN_PERMISSIVE_VALIDATION_ENABLED, false);
    }

    public String getServiceParameter(String service, String parameter) {
        return this.get(GATEWAY_SERVICE_PREFIX + service + "." + parameter, "");
    }

    public boolean homePageLogoutEnabled() {
        return this.getBoolean(KNOX_HOMEPAGE_LOGOUT_ENABLED, false);
    }

    public String getGlobalLogoutPageUrl() {
        return this.get(GLOBAL_LOGOUT_PAGE_URL);
    }

    public long getKeystoreCacheSizeLimit() {
        return this.getLong(KEYSTORE_CACHE_LIMIT, 1000L);
    }

    public long getKeystoreCacheEntryTimeToLiveInMinutes() {
        return this.getLong(KEYSTORE_CACHE_ENTRY_TTL, 60L);
    }

    public boolean isGatewayServerIncomingXForwardedSupportEnabled() {
        return this.getBoolean(KNOX_INCOMING_XFORWARDED_ENABLED, true);
    }

    public Map<String, Collection<String>> getHomePageProfiles() {
        Map<String, Collection<String>> profiles = this.getPreConfiguredProfiles();
        this.forEach(config -> {
            if (((String)config.getKey()).startsWith(KNOX_HOMEPAGE_PROFILE_PREFIX)) {
                profiles.put(((String)config.getKey()).substring(KNOX_HOMEPAGE_PROFILE_PREFIX.length()).toLowerCase(Locale.getDefault()), this.getTrimmedStringCollection((String)config.getKey()));
            }
        });
        return profiles;
    }

    private Map<String, Collection<String>> getPreConfiguredProfiles() {
        HashMap<String, Collection<String>> profiles = new HashMap<String, Collection<String>>();
        profiles.put("full", HomePageProfile.getFullProfileElements());
        profiles.put("thin", HomePageProfile.getThinProfileElemens());
        profiles.put("token", HomePageProfile.getTokenProfileElements());
        return profiles;
    }

    public String getDatabaseType() {
        return this.get(GATEWAY_DATABASE_TYPE, "none");
    }

    public String getDatabaseConnectionUrl() {
        return this.get(GATEWAY_DATABASE_CONN_URL);
    }

    public String getDatabaseHost() {
        return this.get(GATEWAY_DATABASE_HOST);
    }

    public int getDatabasePort() {
        return this.getInt(GATEWAY_DATABASE_PORT, 0);
    }

    public String getDatabaseName() {
        return this.get(GATEWAY_DATABASE_NAME, "GATEWAY_DATABASE");
    }

    public boolean isDatabaseSslEnabled() {
        return this.getBoolean(GATEWAY_DATABASE_SSL_ENABLED, false);
    }

    public boolean verifyDatabaseSslServerCertificate() {
        return this.getBoolean(GATEWAY_DATABASE_VERIFY_SERVER_CERT, true);
    }

    public String getDatabaseSslTruststoreFileName() {
        return this.get(GATEWAY_DATABASE_TRUSTSTORE_FILE);
    }

    public int getJettyMaxFormContentSize() {
        return this.getInt(JETTY_MAX_FORM_CONTENT_SIZE, 200000);
    }

    public int getJettyMaxFormKeys() {
        return this.getInt(JETTY_MAX_FORM_KEYS, 1000);
    }

    public int getPrivilegedUsersConcurrentSessionLimit() {
        return this.getInt(GATEWAY_SESSION_VERIFICATION_PRIVILEGED_USER_LIMIT, 3);
    }

    public int getNonPrivilegedUsersConcurrentSessionLimit() {
        return this.getInt(GATEWAY_SESSION_VERIFICATION_NON_PRIVILEGED_USER_LIMIT, 2);
    }

    public Set<String> getSessionVerificationPrivilegedUsers() {
        Collection privilegedUsers = this.getTrimmedStringCollection(GATEWAY_SESSION_VERIFICATION_PRIVILEGED_USERS);
        return privilegedUsers == null ? Collections.emptySet() : new HashSet(privilegedUsers);
    }

    public Set<String> getSessionVerificationUnlimitedUsers() {
        Collection nonPrivilegedUsers = this.getTrimmedStringCollection(GATEWAY_SESSION_VERIFICATION_UNLIMITED_USERS);
        return nonPrivilegedUsers == null ? Collections.emptySet() : new HashSet(nonPrivilegedUsers);
    }

    public long getDbRemoteConfigMonitorPollingInterval() {
        return this.getLong(REMOTE_CONFIG_MONITOR_DB_POLLING_INTERVAL_SECONDS, 30L);
    }

    public int getDbRemoteConfigMonitorCleanUpInterval() {
        return this.getInt(REMOTE_CONFIG_MONITOR_DB_POLLING_CLEANUP_INTERVAL_SECONDS, 10800);
    }

    public long getConcurrentSessionVerifierExpiredTokensCleaningPeriod() {
        return this.getLong(GATEWAY_SESSION_VERIFICATION_EXPIRED_TOKENS_CLEANING_PERIOD, GATEWAY_SESSION_VERIFICATION_EXPIRED_TOKENS_CLEANING_PERIOD_DEFAULT);
    }

    public boolean isAsyncSupported() {
        return this.getBoolean(GATEWAY_SERVLET_ASYNC_SUPPORTED, false);
    }
}

