/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.Optional;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.UnauthorizedAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.NoLogoutActionBuilder;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClient<C extends Credentials>
extends BaseClient<C> {
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    private static final String STATE_SESSION_PARAMETER = "$stateSessionParameter";
    private static final String NONCE_SESSION_PARAMETER = "$nonceSessionParameter";
    private static final String CODE_VERIFIER_SESSION_PARAMETER = "$codeVerifierSessionParameter";
    protected String callbackUrl;
    protected UrlResolver urlResolver;
    protected CallbackUrlResolver callbackUrlResolver;
    private AjaxRequestResolver ajaxRequestResolver;
    private RedirectionActionBuilder redirectionActionBuilder;
    private LogoutActionBuilder logoutActionBuilder = NoLogoutActionBuilder.INSTANCE;

    @Override
    protected final void internalInit() {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl, "set it up either on this IndirectClient or on the global Config");
        if (this.urlResolver == null) {
            this.urlResolver = new DefaultUrlResolver();
        }
        if (this.callbackUrlResolver == null) {
            this.callbackUrlResolver = this.newDefaultCallbackUrlResolver();
        }
        if (this.ajaxRequestResolver == null) {
            this.ajaxRequestResolver = new DefaultAjaxRequestResolver();
        }
        this.clientInit();
        CommonHelper.assertNotNull("redirectionActionBuilder", this.redirectionActionBuilder);
        CommonHelper.assertNotNull("credentialsExtractor", this.getCredentialsExtractor());
        CommonHelper.assertNotNull("authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull("profileCreator", this.getProfileCreator());
        CommonHelper.assertNotNull("logoutActionBuilder", this.logoutActionBuilder);
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new QueryParameterCallbackUrlResolver();
    }

    protected abstract void clientInit();

    @Override
    public final Optional<RedirectionAction> getRedirectionAction(WebContext context) {
        this.init();
        if (this.ajaxRequestResolver.isAjax(context)) {
            HttpAction httpAction = this.ajaxRequestResolver.buildAjaxResponse(context, this.redirectionActionBuilder);
            this.logger.debug("AJAX request detected -> returning " + httpAction + " for " + context.getFullRequestURL());
            this.cleanRequestedUrl(context);
            throw httpAction;
        }
        Optional<Object> attemptedAuth = context.getSessionStore().get(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (attemptedAuth.isPresent() && !"".equals(attemptedAuth.get())) {
            this.logger.debug("authentication already attempted -> 401");
            this.cleanAttemptedAuthentication(context);
            this.cleanRequestedUrl(context);
            throw UnauthorizedAction.INSTANCE;
        }
        return this.redirectionActionBuilder.getRedirectionAction(context);
    }

    private void cleanRequestedUrl(WebContext context) {
        this.logger.debug("clean requested URL");
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, "pac4jRequestedUrl").isPresent()) {
            sessionStore.set(context, "pac4jRequestedUrl", "");
        }
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        this.logger.debug("clean authentication attempt");
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX).isPresent()) {
            sessionStore.set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "");
        }
    }

    @Override
    public final Optional<C> getCredentials(WebContext context) {
        this.init();
        Optional optCredentials = this.retrieveCredentials(context);
        if (!optCredentials.isPresent() && this.getProfileFactoryWhenNotAuthenticated() == null) {
            this.logger.debug("no credentials and profile returned -> remember the authentication attempt");
            context.getSessionStore().set(context, this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        } else {
            this.cleanAttemptedAuthentication(context);
        }
        return optCredentials;
    }

    @Override
    public final Optional<RedirectionAction> getLogoutAction(WebContext context, UserProfile currentProfile, String targetUrl) {
        this.init();
        return this.logoutActionBuilder.getLogoutAction(context, currentProfile, targetUrl);
    }

    public String computeFinalCallbackUrl(WebContext context) {
        return this.callbackUrlResolver.compute(this.urlResolver, this.callbackUrl, this.getName(), context);
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public RedirectionActionBuilder getRedirectionActionBuilder() {
        return this.redirectionActionBuilder;
    }

    protected void defaultRedirectionActionBuilder(RedirectionActionBuilder redirectActionBuilder) {
        if (this.redirectionActionBuilder == null) {
            this.redirectionActionBuilder = redirectActionBuilder;
        }
    }

    public LogoutActionBuilder getLogoutActionBuilder() {
        return this.logoutActionBuilder;
    }

    protected void defaultLogoutActionBuilder(LogoutActionBuilder logoutActionBuilder) {
        if (this.logoutActionBuilder == null || this.logoutActionBuilder == NoLogoutActionBuilder.INSTANCE) {
            this.logoutActionBuilder = logoutActionBuilder;
        }
    }

    public void setRedirectionActionBuilder(RedirectionActionBuilder redirectionActionBuilder) {
        this.redirectionActionBuilder = redirectionActionBuilder;
    }

    public void setLogoutActionBuilder(LogoutActionBuilder logoutActionBuilder) {
        this.logoutActionBuilder = logoutActionBuilder;
    }

    public String getStateSessionAttributeName() {
        return this.getName() + STATE_SESSION_PARAMETER;
    }

    public String getNonceSessionAttributeName() {
        return this.getName() + NONCE_SESSION_PARAMETER;
    }

    public String getCodeVerifierSessionAttributeName() {
        return this.getName() + CODE_VERIFIER_SESSION_PARAMETER;
    }

    @Override
    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "name", this.getName(), "callbackUrl", this.callbackUrl, "urlResolver", this.urlResolver, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.ajaxRequestResolver, "redirectionActionBuilder", this.redirectionActionBuilder, "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.logoutActionBuilder, "authorizationGenerators", this.getAuthorizationGenerators());
    }
}

